/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.companies.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.types.PlanTraitResponseData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdatePlanTraitsBulkResponse.Builder.class)
public final class UpdatePlanTraitsBulkResponse {
    private final List<PlanTraitResponseData> data;

    private final Map<String, JsonNode> params;

    private final Map<String, Object> additionalProperties;

    private UpdatePlanTraitsBulkResponse(
            List<PlanTraitResponseData> data, Map<String, JsonNode> params, Map<String, Object> additionalProperties) {
        this.data = data;
        this.params = params;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("data")
    public List<PlanTraitResponseData> getData() {
        return data;
    }

    /**
     * @return Input parameters
     */
    @JsonProperty("params")
    public Map<String, JsonNode> getParams() {
        return params;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdatePlanTraitsBulkResponse && equalTo((UpdatePlanTraitsBulkResponse) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdatePlanTraitsBulkResponse other) {
        return data.equals(other.data) && params.equals(other.params);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.data, this.params);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<PlanTraitResponseData> data = new ArrayList<>();

        private Map<String, JsonNode> params = new LinkedHashMap<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(UpdatePlanTraitsBulkResponse other) {
            data(other.getData());
            params(other.getParams());
            return this;
        }

        @JsonSetter(value = "data", nulls = Nulls.SKIP)
        public Builder data(List<PlanTraitResponseData> data) {
            this.data.clear();
            if (data != null) {
                this.data.addAll(data);
            }
            return this;
        }

        public Builder addData(PlanTraitResponseData data) {
            this.data.add(data);
            return this;
        }

        public Builder addAllData(List<PlanTraitResponseData> data) {
            if (data != null) {
                this.data.addAll(data);
            }
            return this;
        }

        /**
         * <p>Input parameters</p>
         */
        @JsonSetter(value = "params", nulls = Nulls.SKIP)
        public Builder params(Map<String, JsonNode> params) {
            this.params.clear();
            if (params != null) {
                this.params.putAll(params);
            }
            return this;
        }

        public Builder putAllParams(Map<String, JsonNode> params) {
            if (params != null) {
                this.params.putAll(params);
            }
            return this;
        }

        public Builder params(String key, JsonNode value) {
            this.params.put(key, value);
            return this;
        }

        public UpdatePlanTraitsBulkResponse build() {
            return new UpdatePlanTraitsBulkResponse(data, params, additionalProperties);
        }
    }
}
