/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.components;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.components.requests.CountComponentsRequest;
import com.schematic.api.resources.components.requests.CreateComponentRequestBody;
import com.schematic.api.resources.components.requests.ListComponentsRequest;
import com.schematic.api.resources.components.requests.PreviewComponentDataRequest;
import com.schematic.api.resources.components.requests.UpdateComponentRequestBody;
import com.schematic.api.resources.components.types.CountComponentsResponse;
import com.schematic.api.resources.components.types.CreateComponentResponse;
import com.schematic.api.resources.components.types.DeleteComponentResponse;
import com.schematic.api.resources.components.types.GetComponentResponse;
import com.schematic.api.resources.components.types.ListComponentsResponse;
import com.schematic.api.resources.components.types.PreviewComponentDataResponse;
import com.schematic.api.resources.components.types.UpdateComponentResponse;

public class ComponentsClient {
    protected final ClientOptions clientOptions;

    private final RawComponentsClient rawClient;

    public ComponentsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawComponentsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawComponentsClient withRawResponse() {
        return this.rawClient;
    }

    public ListComponentsResponse listComponents() {
        return this.rawClient.listComponents().body();
    }

    public ListComponentsResponse listComponents(ListComponentsRequest request) {
        return this.rawClient.listComponents(request).body();
    }

    public ListComponentsResponse listComponents(ListComponentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listComponents(request, requestOptions).body();
    }

    public CreateComponentResponse createComponent(CreateComponentRequestBody request) {
        return this.rawClient.createComponent(request).body();
    }

    public CreateComponentResponse createComponent(CreateComponentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createComponent(request, requestOptions).body();
    }

    public GetComponentResponse getComponent(String componentId) {
        return this.rawClient.getComponent(componentId).body();
    }

    public GetComponentResponse getComponent(String componentId, RequestOptions requestOptions) {
        return this.rawClient.getComponent(componentId, requestOptions).body();
    }

    public UpdateComponentResponse updateComponent(String componentId) {
        return this.rawClient.updateComponent(componentId).body();
    }

    public UpdateComponentResponse updateComponent(String componentId, UpdateComponentRequestBody request) {
        return this.rawClient.updateComponent(componentId, request).body();
    }

    public UpdateComponentResponse updateComponent(
            String componentId, UpdateComponentRequestBody request, RequestOptions requestOptions) {
        return this.rawClient
                .updateComponent(componentId, request, requestOptions)
                .body();
    }

    public DeleteComponentResponse deleteComponent(String componentId) {
        return this.rawClient.deleteComponent(componentId).body();
    }

    public DeleteComponentResponse deleteComponent(String componentId, RequestOptions requestOptions) {
        return this.rawClient.deleteComponent(componentId, requestOptions).body();
    }

    public CountComponentsResponse countComponents() {
        return this.rawClient.countComponents().body();
    }

    public CountComponentsResponse countComponents(CountComponentsRequest request) {
        return this.rawClient.countComponents(request).body();
    }

    public CountComponentsResponse countComponents(CountComponentsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countComponents(request, requestOptions).body();
    }

    public PreviewComponentDataResponse previewComponentData() {
        return this.rawClient.previewComponentData().body();
    }

    public PreviewComponentDataResponse previewComponentData(PreviewComponentDataRequest request) {
        return this.rawClient.previewComponentData(request).body();
    }

    public PreviewComponentDataResponse previewComponentData(
            PreviewComponentDataRequest request, RequestOptions requestOptions) {
        return this.rawClient.previewComponentData(request, requestOptions).body();
    }
}
