/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CreateBillingCreditRequestBodyBurnStrategy;
import com.schematic.api.resources.credits.types.CreateBillingCreditRequestBodyDefaultRolloverPolicy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateBillingCreditRequestBody.Builder.class)
public final class CreateBillingCreditRequestBody {
    private final Optional<CreateBillingCreditRequestBodyBurnStrategy> burnStrategy;

    private final String currency;

    private final Optional<String> defaultExpiryUnit;

    private final Optional<Integer> defaultExpiryUnitCount;

    private final Optional<CreateBillingCreditRequestBodyDefaultRolloverPolicy> defaultRolloverPolicy;

    private final String description;

    private final Optional<String> icon;

    private final String name;

    private final Optional<Integer> perUnitPrice;

    private final Optional<String> perUnitPriceDecimal;

    private final Optional<String> pluralName;

    private final Optional<String> singularName;

    private final Map<String, Object> additionalProperties;

    private CreateBillingCreditRequestBody(
            Optional<CreateBillingCreditRequestBodyBurnStrategy> burnStrategy,
            String currency,
            Optional<String> defaultExpiryUnit,
            Optional<Integer> defaultExpiryUnitCount,
            Optional<CreateBillingCreditRequestBodyDefaultRolloverPolicy> defaultRolloverPolicy,
            String description,
            Optional<String> icon,
            String name,
            Optional<Integer> perUnitPrice,
            Optional<String> perUnitPriceDecimal,
            Optional<String> pluralName,
            Optional<String> singularName,
            Map<String, Object> additionalProperties) {
        this.burnStrategy = burnStrategy;
        this.currency = currency;
        this.defaultExpiryUnit = defaultExpiryUnit;
        this.defaultExpiryUnitCount = defaultExpiryUnitCount;
        this.defaultRolloverPolicy = defaultRolloverPolicy;
        this.description = description;
        this.icon = icon;
        this.name = name;
        this.perUnitPrice = perUnitPrice;
        this.perUnitPriceDecimal = perUnitPriceDecimal;
        this.pluralName = pluralName;
        this.singularName = singularName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("burn_strategy")
    public Optional<CreateBillingCreditRequestBodyBurnStrategy> getBurnStrategy() {
        return burnStrategy;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("default_expiry_unit")
    public Optional<String> getDefaultExpiryUnit() {
        return defaultExpiryUnit;
    }

    @JsonProperty("default_expiry_unit_count")
    public Optional<Integer> getDefaultExpiryUnitCount() {
        return defaultExpiryUnitCount;
    }

    @JsonProperty("default_rollover_policy")
    public Optional<CreateBillingCreditRequestBodyDefaultRolloverPolicy> getDefaultRolloverPolicy() {
        return defaultRolloverPolicy;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("per_unit_price")
    public Optional<Integer> getPerUnitPrice() {
        return perUnitPrice;
    }

    @JsonProperty("per_unit_price_decimal")
    public Optional<String> getPerUnitPriceDecimal() {
        return perUnitPriceDecimal;
    }

    @JsonProperty("plural_name")
    public Optional<String> getPluralName() {
        return pluralName;
    }

    @JsonProperty("singular_name")
    public Optional<String> getSingularName() {
        return singularName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateBillingCreditRequestBody && equalTo((CreateBillingCreditRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingCreditRequestBody other) {
        return burnStrategy.equals(other.burnStrategy)
                && currency.equals(other.currency)
                && defaultExpiryUnit.equals(other.defaultExpiryUnit)
                && defaultExpiryUnitCount.equals(other.defaultExpiryUnitCount)
                && defaultRolloverPolicy.equals(other.defaultRolloverPolicy)
                && description.equals(other.description)
                && icon.equals(other.icon)
                && name.equals(other.name)
                && perUnitPrice.equals(other.perUnitPrice)
                && perUnitPriceDecimal.equals(other.perUnitPriceDecimal)
                && pluralName.equals(other.pluralName)
                && singularName.equals(other.singularName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.burnStrategy,
                this.currency,
                this.defaultExpiryUnit,
                this.defaultExpiryUnitCount,
                this.defaultRolloverPolicy,
                this.description,
                this.icon,
                this.name,
                this.perUnitPrice,
                this.perUnitPriceDecimal,
                this.pluralName,
                this.singularName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    public interface CurrencyStage {
        DescriptionStage currency(@NotNull String currency);

        Builder from(CreateBillingCreditRequestBody other);
    }

    public interface DescriptionStage {
        NameStage description(@NotNull String description);
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        CreateBillingCreditRequestBody build();

        _FinalStage burnStrategy(Optional<CreateBillingCreditRequestBodyBurnStrategy> burnStrategy);

        _FinalStage burnStrategy(CreateBillingCreditRequestBodyBurnStrategy burnStrategy);

        _FinalStage defaultExpiryUnit(Optional<String> defaultExpiryUnit);

        _FinalStage defaultExpiryUnit(String defaultExpiryUnit);

        _FinalStage defaultExpiryUnitCount(Optional<Integer> defaultExpiryUnitCount);

        _FinalStage defaultExpiryUnitCount(Integer defaultExpiryUnitCount);

        _FinalStage defaultRolloverPolicy(
                Optional<CreateBillingCreditRequestBodyDefaultRolloverPolicy> defaultRolloverPolicy);

        _FinalStage defaultRolloverPolicy(CreateBillingCreditRequestBodyDefaultRolloverPolicy defaultRolloverPolicy);

        _FinalStage icon(Optional<String> icon);

        _FinalStage icon(String icon);

        _FinalStage perUnitPrice(Optional<Integer> perUnitPrice);

        _FinalStage perUnitPrice(Integer perUnitPrice);

        _FinalStage perUnitPriceDecimal(Optional<String> perUnitPriceDecimal);

        _FinalStage perUnitPriceDecimal(String perUnitPriceDecimal);

        _FinalStage pluralName(Optional<String> pluralName);

        _FinalStage pluralName(String pluralName);

        _FinalStage singularName(Optional<String> singularName);

        _FinalStage singularName(String singularName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CurrencyStage, DescriptionStage, NameStage, _FinalStage {
        private String currency;

        private String description;

        private String name;

        private Optional<String> singularName = Optional.empty();

        private Optional<String> pluralName = Optional.empty();

        private Optional<String> perUnitPriceDecimal = Optional.empty();

        private Optional<Integer> perUnitPrice = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<CreateBillingCreditRequestBodyDefaultRolloverPolicy> defaultRolloverPolicy = Optional.empty();

        private Optional<Integer> defaultExpiryUnitCount = Optional.empty();

        private Optional<String> defaultExpiryUnit = Optional.empty();

        private Optional<CreateBillingCreditRequestBodyBurnStrategy> burnStrategy = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateBillingCreditRequestBody other) {
            burnStrategy(other.getBurnStrategy());
            currency(other.getCurrency());
            defaultExpiryUnit(other.getDefaultExpiryUnit());
            defaultExpiryUnitCount(other.getDefaultExpiryUnitCount());
            defaultRolloverPolicy(other.getDefaultRolloverPolicy());
            description(other.getDescription());
            icon(other.getIcon());
            name(other.getName());
            perUnitPrice(other.getPerUnitPrice());
            perUnitPriceDecimal(other.getPerUnitPriceDecimal());
            pluralName(other.getPluralName());
            singularName(other.getSingularName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public DescriptionStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public NameStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "singular_name", nulls = Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @java.lang.Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plural_name", nulls = Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @java.lang.Override
        public _FinalStage perUnitPriceDecimal(String perUnitPriceDecimal) {
            this.perUnitPriceDecimal = Optional.ofNullable(perUnitPriceDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "per_unit_price_decimal", nulls = Nulls.SKIP)
        public _FinalStage perUnitPriceDecimal(Optional<String> perUnitPriceDecimal) {
            this.perUnitPriceDecimal = perUnitPriceDecimal;
            return this;
        }

        @java.lang.Override
        public _FinalStage perUnitPrice(Integer perUnitPrice) {
            this.perUnitPrice = Optional.ofNullable(perUnitPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "per_unit_price", nulls = Nulls.SKIP)
        public _FinalStage perUnitPrice(Optional<Integer> perUnitPrice) {
            this.perUnitPrice = perUnitPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultRolloverPolicy(
                CreateBillingCreditRequestBodyDefaultRolloverPolicy defaultRolloverPolicy) {
            this.defaultRolloverPolicy = Optional.ofNullable(defaultRolloverPolicy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_rollover_policy", nulls = Nulls.SKIP)
        public _FinalStage defaultRolloverPolicy(
                Optional<CreateBillingCreditRequestBodyDefaultRolloverPolicy> defaultRolloverPolicy) {
            this.defaultRolloverPolicy = defaultRolloverPolicy;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultExpiryUnitCount(Integer defaultExpiryUnitCount) {
            this.defaultExpiryUnitCount = Optional.ofNullable(defaultExpiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage defaultExpiryUnitCount(Optional<Integer> defaultExpiryUnitCount) {
            this.defaultExpiryUnitCount = defaultExpiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage defaultExpiryUnit(String defaultExpiryUnit) {
            this.defaultExpiryUnit = Optional.ofNullable(defaultExpiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "default_expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage defaultExpiryUnit(Optional<String> defaultExpiryUnit) {
            this.defaultExpiryUnit = defaultExpiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage burnStrategy(CreateBillingCreditRequestBodyBurnStrategy burnStrategy) {
            this.burnStrategy = Optional.ofNullable(burnStrategy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "burn_strategy", nulls = Nulls.SKIP)
        public _FinalStage burnStrategy(Optional<CreateBillingCreditRequestBodyBurnStrategy> burnStrategy) {
            this.burnStrategy = burnStrategy;
            return this;
        }

        @java.lang.Override
        public CreateBillingCreditRequestBody build() {
            return new CreateBillingCreditRequestBody(
                    burnStrategy,
                    currency,
                    defaultExpiryUnit,
                    defaultExpiryUnitCount,
                    defaultRolloverPolicy,
                    description,
                    icon,
                    name,
                    perUnitPrice,
                    perUnitPriceDecimal,
                    pluralName,
                    singularName,
                    additionalProperties);
        }
    }
}
