/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyExpiryType;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyExpiryUnit;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyResetCadence;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyResetStart;
import com.schematic.api.resources.credits.types.CreateBillingPlanCreditGrantRequestBodyResetType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateBillingPlanCreditGrantRequestBody.Builder.class)
public final class CreateBillingPlanCreditGrantRequestBody {
    private final Optional<Boolean> applyToExisting;

    private final int creditAmount;

    private final String creditId;

    private final Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType;

    private final Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final String planId;

    private final CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence;

    private final CreateBillingPlanCreditGrantRequestBodyResetStart resetStart;

    private final Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType;

    private final Map<String, Object> additionalProperties;

    private CreateBillingPlanCreditGrantRequestBody(
            Optional<Boolean> applyToExisting,
            int creditAmount,
            String creditId,
            Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType,
            Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit,
            Optional<Integer> expiryUnitCount,
            String planId,
            CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence,
            CreateBillingPlanCreditGrantRequestBodyResetStart resetStart,
            Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType,
            Map<String, Object> additionalProperties) {
        this.applyToExisting = applyToExisting;
        this.creditAmount = creditAmount;
        this.creditId = creditId;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.planId = planId;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("apply_to_existing")
    public Optional<Boolean> getApplyToExisting() {
        return applyToExisting;
    }

    @JsonProperty("credit_amount")
    public int getCreditAmount() {
        return creditAmount;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @JsonProperty("expiry_type")
    public Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("reset_cadence")
    public CreateBillingPlanCreditGrantRequestBodyResetCadence getResetCadence() {
        return resetCadence;
    }

    @JsonProperty("reset_start")
    public CreateBillingPlanCreditGrantRequestBodyResetStart getResetStart() {
        return resetStart;
    }

    @JsonProperty("reset_type")
    public Optional<CreateBillingPlanCreditGrantRequestBodyResetType> getResetType() {
        return resetType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateBillingPlanCreditGrantRequestBody
                && equalTo((CreateBillingPlanCreditGrantRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateBillingPlanCreditGrantRequestBody other) {
        return applyToExisting.equals(other.applyToExisting)
                && creditAmount == other.creditAmount
                && creditId.equals(other.creditId)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && planId.equals(other.planId)
                && resetCadence.equals(other.resetCadence)
                && resetStart.equals(other.resetStart)
                && resetType.equals(other.resetType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.applyToExisting,
                this.creditAmount,
                this.creditId,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.planId,
                this.resetCadence,
                this.resetStart,
                this.resetType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreditAmountStage builder() {
        return new Builder();
    }

    public interface CreditAmountStage {
        CreditIdStage creditAmount(int creditAmount);

        Builder from(CreateBillingPlanCreditGrantRequestBody other);
    }

    public interface CreditIdStage {
        PlanIdStage creditId(@NotNull String creditId);
    }

    public interface PlanIdStage {
        ResetCadenceStage planId(@NotNull String planId);
    }

    public interface ResetCadenceStage {
        ResetStartStage resetCadence(@NotNull CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence);
    }

    public interface ResetStartStage {
        _FinalStage resetStart(@NotNull CreateBillingPlanCreditGrantRequestBodyResetStart resetStart);
    }

    public interface _FinalStage {
        CreateBillingPlanCreditGrantRequestBody build();

        _FinalStage applyToExisting(Optional<Boolean> applyToExisting);

        _FinalStage applyToExisting(Boolean applyToExisting);

        _FinalStage expiryType(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType);

        _FinalStage expiryType(CreateBillingPlanCreditGrantRequestBodyExpiryType expiryType);

        _FinalStage expiryUnit(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit);

        _FinalStage expiryUnit(CreateBillingPlanCreditGrantRequestBodyExpiryUnit expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage resetType(Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType);

        _FinalStage resetType(CreateBillingPlanCreditGrantRequestBodyResetType resetType);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreditAmountStage, CreditIdStage, PlanIdStage, ResetCadenceStage, ResetStartStage, _FinalStage {
        private int creditAmount;

        private String creditId;

        private String planId;

        private CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence;

        private CreateBillingPlanCreditGrantRequestBodyResetStart resetStart;

        private Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit = Optional.empty();

        private Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType = Optional.empty();

        private Optional<Boolean> applyToExisting = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateBillingPlanCreditGrantRequestBody other) {
            applyToExisting(other.getApplyToExisting());
            creditAmount(other.getCreditAmount());
            creditId(other.getCreditId());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            planId(other.getPlanId());
            resetCadence(other.getResetCadence());
            resetStart(other.getResetStart());
            resetType(other.getResetType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_amount")
        public CreditIdStage creditAmount(int creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public PlanIdStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public ResetCadenceStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_cadence")
        public ResetStartStage resetCadence(@NotNull CreateBillingPlanCreditGrantRequestBodyResetCadence resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_start")
        public _FinalStage resetStart(@NotNull CreateBillingPlanCreditGrantRequestBodyResetStart resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage resetType(CreateBillingPlanCreditGrantRequestBodyResetType resetType) {
            this.resetType = Optional.ofNullable(resetType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "reset_type", nulls = Nulls.SKIP)
        public _FinalStage resetType(Optional<CreateBillingPlanCreditGrantRequestBodyResetType> resetType) {
            this.resetType = resetType;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(CreateBillingPlanCreditGrantRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(CreateBillingPlanCreditGrantRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<CreateBillingPlanCreditGrantRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public _FinalStage applyToExisting(Boolean applyToExisting) {
            this.applyToExisting = Optional.ofNullable(applyToExisting);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "apply_to_existing", nulls = Nulls.SKIP)
        public _FinalStage applyToExisting(Optional<Boolean> applyToExisting) {
            this.applyToExisting = applyToExisting;
            return this;
        }

        @java.lang.Override
        public CreateBillingPlanCreditGrantRequestBody build() {
            return new CreateBillingPlanCreditGrantRequestBody(
                    applyToExisting,
                    creditAmount,
                    creditId,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    planId,
                    resetCadence,
                    resetStart,
                    resetType,
                    additionalProperties);
        }
    }
}
