/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.CreateCreditBundleRequestBodyExpiryType;
import com.schematic.api.resources.credits.types.CreateCreditBundleRequestBodyExpiryUnit;
import com.schematic.api.resources.credits.types.CreateCreditBundleRequestBodyStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCreditBundleRequestBody.Builder.class)
public final class CreateCreditBundleRequestBody {
    private final String bundleName;

    private final Optional<String> bundleType;

    private final String creditId;

    private final String currency;

    private final Optional<CreateCreditBundleRequestBodyExpiryType> expiryType;

    private final Optional<CreateCreditBundleRequestBodyExpiryUnit> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final int pricePerUnit;

    private final Optional<String> pricePerUnitDecimal;

    private final Optional<Integer> quantity;

    private final Optional<CreateCreditBundleRequestBodyStatus> status;

    private final Map<String, Object> additionalProperties;

    private CreateCreditBundleRequestBody(
            String bundleName,
            Optional<String> bundleType,
            String creditId,
            String currency,
            Optional<CreateCreditBundleRequestBodyExpiryType> expiryType,
            Optional<CreateCreditBundleRequestBodyExpiryUnit> expiryUnit,
            Optional<Integer> expiryUnitCount,
            int pricePerUnit,
            Optional<String> pricePerUnitDecimal,
            Optional<Integer> quantity,
            Optional<CreateCreditBundleRequestBodyStatus> status,
            Map<String, Object> additionalProperties) {
        this.bundleName = bundleName;
        this.bundleType = bundleType;
        this.creditId = creditId;
        this.currency = currency;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.pricePerUnit = pricePerUnit;
        this.pricePerUnitDecimal = pricePerUnitDecimal;
        this.quantity = quantity;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("bundle_name")
    public String getBundleName() {
        return bundleName;
    }

    @JsonProperty("bundle_type")
    public Optional<String> getBundleType() {
        return bundleType;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("expiry_type")
    public Optional<CreateCreditBundleRequestBodyExpiryType> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<CreateCreditBundleRequestBodyExpiryUnit> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("price_per_unit")
    public int getPricePerUnit() {
        return pricePerUnit;
    }

    @JsonProperty("price_per_unit_decimal")
    public Optional<String> getPricePerUnitDecimal() {
        return pricePerUnitDecimal;
    }

    @JsonProperty("quantity")
    public Optional<Integer> getQuantity() {
        return quantity;
    }

    @JsonProperty("status")
    public Optional<CreateCreditBundleRequestBodyStatus> getStatus() {
        return status;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCreditBundleRequestBody && equalTo((CreateCreditBundleRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCreditBundleRequestBody other) {
        return bundleName.equals(other.bundleName)
                && bundleType.equals(other.bundleType)
                && creditId.equals(other.creditId)
                && currency.equals(other.currency)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && pricePerUnit == other.pricePerUnit
                && pricePerUnitDecimal.equals(other.pricePerUnitDecimal)
                && quantity.equals(other.quantity)
                && status.equals(other.status);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.bundleName,
                this.bundleType,
                this.creditId,
                this.currency,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.pricePerUnit,
                this.pricePerUnitDecimal,
                this.quantity,
                this.status);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleNameStage builder() {
        return new Builder();
    }

    public interface BundleNameStage {
        CreditIdStage bundleName(@NotNull String bundleName);

        Builder from(CreateCreditBundleRequestBody other);
    }

    public interface CreditIdStage {
        CurrencyStage creditId(@NotNull String creditId);
    }

    public interface CurrencyStage {
        PricePerUnitStage currency(@NotNull String currency);
    }

    public interface PricePerUnitStage {
        _FinalStage pricePerUnit(int pricePerUnit);
    }

    public interface _FinalStage {
        CreateCreditBundleRequestBody build();

        _FinalStage bundleType(Optional<String> bundleType);

        _FinalStage bundleType(String bundleType);

        _FinalStage expiryType(Optional<CreateCreditBundleRequestBodyExpiryType> expiryType);

        _FinalStage expiryType(CreateCreditBundleRequestBodyExpiryType expiryType);

        _FinalStage expiryUnit(Optional<CreateCreditBundleRequestBodyExpiryUnit> expiryUnit);

        _FinalStage expiryUnit(CreateCreditBundleRequestBodyExpiryUnit expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage pricePerUnitDecimal(Optional<String> pricePerUnitDecimal);

        _FinalStage pricePerUnitDecimal(String pricePerUnitDecimal);

        _FinalStage quantity(Optional<Integer> quantity);

        _FinalStage quantity(Integer quantity);

        _FinalStage status(Optional<CreateCreditBundleRequestBodyStatus> status);

        _FinalStage status(CreateCreditBundleRequestBodyStatus status);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BundleNameStage, CreditIdStage, CurrencyStage, PricePerUnitStage, _FinalStage {
        private String bundleName;

        private String creditId;

        private String currency;

        private int pricePerUnit;

        private Optional<CreateCreditBundleRequestBodyStatus> status = Optional.empty();

        private Optional<Integer> quantity = Optional.empty();

        private Optional<String> pricePerUnitDecimal = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<CreateCreditBundleRequestBodyExpiryUnit> expiryUnit = Optional.empty();

        private Optional<CreateCreditBundleRequestBodyExpiryType> expiryType = Optional.empty();

        private Optional<String> bundleType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCreditBundleRequestBody other) {
            bundleName(other.getBundleName());
            bundleType(other.getBundleType());
            creditId(other.getCreditId());
            currency(other.getCurrency());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            pricePerUnit(other.getPricePerUnit());
            pricePerUnitDecimal(other.getPricePerUnitDecimal());
            quantity(other.getQuantity());
            status(other.getStatus());
            return this;
        }

        @java.lang.Override
        @JsonSetter("bundle_name")
        public CreditIdStage bundleName(@NotNull String bundleName) {
            this.bundleName = Objects.requireNonNull(bundleName, "bundleName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public CurrencyStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public PricePerUnitStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_per_unit")
        public _FinalStage pricePerUnit(int pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(CreateCreditBundleRequestBodyStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<CreateCreditBundleRequestBodyStatus> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "quantity", nulls = Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public _FinalStage pricePerUnitDecimal(String pricePerUnitDecimal) {
            this.pricePerUnitDecimal = Optional.ofNullable(pricePerUnitDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_per_unit_decimal", nulls = Nulls.SKIP)
        public _FinalStage pricePerUnitDecimal(Optional<String> pricePerUnitDecimal) {
            this.pricePerUnitDecimal = pricePerUnitDecimal;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(CreateCreditBundleRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<CreateCreditBundleRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(CreateCreditBundleRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<CreateCreditBundleRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public _FinalStage bundleType(String bundleType) {
            this.bundleType = Optional.ofNullable(bundleType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "bundle_type", nulls = Nulls.SKIP)
        public _FinalStage bundleType(Optional<String> bundleType) {
            this.bundleType = bundleType;
            return this;
        }

        @java.lang.Override
        public CreateCreditBundleRequestBody build() {
            return new CreateCreditBundleRequestBody(
                    bundleName,
                    bundleType,
                    creditId,
                    currency,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    pricePerUnit,
                    pricePerUnitDecimal,
                    quantity,
                    status,
                    additionalProperties);
        }
    }
}
