/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.ListCompanyGrantsRequestDir;
import com.schematic.api.resources.credits.types.ListCompanyGrantsRequestOrder;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ListCompanyGrantsRequest.Builder.class)
public final class ListCompanyGrantsRequest {
    private final Optional<String> companyId;

    private final Optional<ListCompanyGrantsRequestOrder> order;

    private final Optional<ListCompanyGrantsRequestDir> dir;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private ListCompanyGrantsRequest(
            Optional<String> companyId,
            Optional<ListCompanyGrantsRequestOrder> order,
            Optional<ListCompanyGrantsRequestDir> dir,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.order = order;
        this.dir = dir;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    @JsonProperty("order")
    public Optional<ListCompanyGrantsRequestOrder> getOrder() {
        return order;
    }

    @JsonProperty("dir")
    public Optional<ListCompanyGrantsRequestDir> getDir() {
        return dir;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ListCompanyGrantsRequest && equalTo((ListCompanyGrantsRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ListCompanyGrantsRequest other) {
        return companyId.equals(other.companyId)
                && order.equals(other.order)
                && dir.equals(other.dir)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.order, this.dir, this.limit, this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> companyId = Optional.empty();

        private Optional<ListCompanyGrantsRequestOrder> order = Optional.empty();

        private Optional<ListCompanyGrantsRequestDir> dir = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(ListCompanyGrantsRequest other) {
            companyId(other.getCompanyId());
            order(other.getOrder());
            dir(other.getDir());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        @JsonSetter(value = "order", nulls = Nulls.SKIP)
        public Builder order(Optional<ListCompanyGrantsRequestOrder> order) {
            this.order = order;
            return this;
        }

        public Builder order(ListCompanyGrantsRequestOrder order) {
            this.order = Optional.ofNullable(order);
            return this;
        }

        @JsonSetter(value = "dir", nulls = Nulls.SKIP)
        public Builder dir(Optional<ListCompanyGrantsRequestDir> dir) {
            this.dir = dir;
            return this;
        }

        public Builder dir(ListCompanyGrantsRequestDir dir) {
            this.dir = Optional.ofNullable(dir);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public ListCompanyGrantsRequest build() {
            return new ListCompanyGrantsRequest(companyId, order, dir, limit, offset, additionalProperties);
        }
    }
}
