/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.UpdateBillingPlanCreditGrantRequestBodyExpiryType;
import com.schematic.api.resources.credits.types.UpdateBillingPlanCreditGrantRequestBodyExpiryUnit;
import com.schematic.api.resources.credits.types.UpdateBillingPlanCreditGrantRequestBodyResetCadence;
import com.schematic.api.resources.credits.types.UpdateBillingPlanCreditGrantRequestBodyResetStart;
import com.schematic.api.resources.credits.types.UpdateBillingPlanCreditGrantRequestBodyResetType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateBillingPlanCreditGrantRequestBody.Builder.class)
public final class UpdateBillingPlanCreditGrantRequestBody {
    private final Optional<Boolean> applyToExisting;

    private final Optional<Integer> creditAmount;

    private final Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryType> expiryType;

    private final Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final UpdateBillingPlanCreditGrantRequestBodyResetCadence resetCadence;

    private final UpdateBillingPlanCreditGrantRequestBodyResetStart resetStart;

    private final Optional<UpdateBillingPlanCreditGrantRequestBodyResetType> resetType;

    private final Map<String, Object> additionalProperties;

    private UpdateBillingPlanCreditGrantRequestBody(
            Optional<Boolean> applyToExisting,
            Optional<Integer> creditAmount,
            Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryType> expiryType,
            Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit,
            Optional<Integer> expiryUnitCount,
            UpdateBillingPlanCreditGrantRequestBodyResetCadence resetCadence,
            UpdateBillingPlanCreditGrantRequestBodyResetStart resetStart,
            Optional<UpdateBillingPlanCreditGrantRequestBodyResetType> resetType,
            Map<String, Object> additionalProperties) {
        this.applyToExisting = applyToExisting;
        this.creditAmount = creditAmount;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("apply_to_existing")
    public Optional<Boolean> getApplyToExisting() {
        return applyToExisting;
    }

    @JsonProperty("credit_amount")
    public Optional<Integer> getCreditAmount() {
        return creditAmount;
    }

    @JsonProperty("expiry_type")
    public Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryType> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryUnit> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("reset_cadence")
    public UpdateBillingPlanCreditGrantRequestBodyResetCadence getResetCadence() {
        return resetCadence;
    }

    @JsonProperty("reset_start")
    public UpdateBillingPlanCreditGrantRequestBodyResetStart getResetStart() {
        return resetStart;
    }

    @JsonProperty("reset_type")
    public Optional<UpdateBillingPlanCreditGrantRequestBodyResetType> getResetType() {
        return resetType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateBillingPlanCreditGrantRequestBody
                && equalTo((UpdateBillingPlanCreditGrantRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateBillingPlanCreditGrantRequestBody other) {
        return applyToExisting.equals(other.applyToExisting)
                && creditAmount.equals(other.creditAmount)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && resetCadence.equals(other.resetCadence)
                && resetStart.equals(other.resetStart)
                && resetType.equals(other.resetType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.applyToExisting,
                this.creditAmount,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.resetCadence,
                this.resetStart,
                this.resetType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResetCadenceStage builder() {
        return new Builder();
    }

    public interface ResetCadenceStage {
        ResetStartStage resetCadence(@NotNull UpdateBillingPlanCreditGrantRequestBodyResetCadence resetCadence);

        Builder from(UpdateBillingPlanCreditGrantRequestBody other);
    }

    public interface ResetStartStage {
        _FinalStage resetStart(@NotNull UpdateBillingPlanCreditGrantRequestBodyResetStart resetStart);
    }

    public interface _FinalStage {
        UpdateBillingPlanCreditGrantRequestBody build();

        _FinalStage applyToExisting(Optional<Boolean> applyToExisting);

        _FinalStage applyToExisting(Boolean applyToExisting);

        _FinalStage creditAmount(Optional<Integer> creditAmount);

        _FinalStage creditAmount(Integer creditAmount);

        _FinalStage expiryType(Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryType> expiryType);

        _FinalStage expiryType(UpdateBillingPlanCreditGrantRequestBodyExpiryType expiryType);

        _FinalStage expiryUnit(Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit);

        _FinalStage expiryUnit(UpdateBillingPlanCreditGrantRequestBodyExpiryUnit expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage resetType(Optional<UpdateBillingPlanCreditGrantRequestBodyResetType> resetType);

        _FinalStage resetType(UpdateBillingPlanCreditGrantRequestBodyResetType resetType);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ResetCadenceStage, ResetStartStage, _FinalStage {
        private UpdateBillingPlanCreditGrantRequestBodyResetCadence resetCadence;

        private UpdateBillingPlanCreditGrantRequestBodyResetStart resetStart;

        private Optional<UpdateBillingPlanCreditGrantRequestBodyResetType> resetType = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit = Optional.empty();

        private Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryType> expiryType = Optional.empty();

        private Optional<Integer> creditAmount = Optional.empty();

        private Optional<Boolean> applyToExisting = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateBillingPlanCreditGrantRequestBody other) {
            applyToExisting(other.getApplyToExisting());
            creditAmount(other.getCreditAmount());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            resetCadence(other.getResetCadence());
            resetStart(other.getResetStart());
            resetType(other.getResetType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_cadence")
        public ResetStartStage resetCadence(@NotNull UpdateBillingPlanCreditGrantRequestBodyResetCadence resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_start")
        public _FinalStage resetStart(@NotNull UpdateBillingPlanCreditGrantRequestBodyResetStart resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage resetType(UpdateBillingPlanCreditGrantRequestBodyResetType resetType) {
            this.resetType = Optional.ofNullable(resetType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "reset_type", nulls = Nulls.SKIP)
        public _FinalStage resetType(Optional<UpdateBillingPlanCreditGrantRequestBodyResetType> resetType) {
            this.resetType = resetType;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(UpdateBillingPlanCreditGrantRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(UpdateBillingPlanCreditGrantRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<UpdateBillingPlanCreditGrantRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditAmount(Integer creditAmount) {
            this.creditAmount = Optional.ofNullable(creditAmount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_amount", nulls = Nulls.SKIP)
        public _FinalStage creditAmount(Optional<Integer> creditAmount) {
            this.creditAmount = creditAmount;
            return this;
        }

        @java.lang.Override
        public _FinalStage applyToExisting(Boolean applyToExisting) {
            this.applyToExisting = Optional.ofNullable(applyToExisting);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "apply_to_existing", nulls = Nulls.SKIP)
        public _FinalStage applyToExisting(Optional<Boolean> applyToExisting) {
            this.applyToExisting = applyToExisting;
            return this;
        }

        @java.lang.Override
        public UpdateBillingPlanCreditGrantRequestBody build() {
            return new UpdateBillingPlanCreditGrantRequestBody(
                    applyToExisting,
                    creditAmount,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    resetCadence,
                    resetStart,
                    resetType,
                    additionalProperties);
        }
    }
}
