/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.credits.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsRequestBodyExpiryType;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsRequestBodyExpiryUnit;
import com.schematic.api.resources.credits.types.UpdateCreditBundleDetailsRequestBodyStatus;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateCreditBundleDetailsRequestBody.Builder.class)
public final class UpdateCreditBundleDetailsRequestBody {
    private final String bundleName;

    private final Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType;

    private final Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final int pricePerUnit;

    private final Optional<String> pricePerUnitDecimal;

    private final Optional<Integer> quantity;

    private final Optional<UpdateCreditBundleDetailsRequestBodyStatus> status;

    private final Map<String, Object> additionalProperties;

    private UpdateCreditBundleDetailsRequestBody(
            String bundleName,
            Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType,
            Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit,
            Optional<Integer> expiryUnitCount,
            int pricePerUnit,
            Optional<String> pricePerUnitDecimal,
            Optional<Integer> quantity,
            Optional<UpdateCreditBundleDetailsRequestBodyStatus> status,
            Map<String, Object> additionalProperties) {
        this.bundleName = bundleName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.pricePerUnit = pricePerUnit;
        this.pricePerUnitDecimal = pricePerUnitDecimal;
        this.quantity = quantity;
        this.status = status;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("bundle_name")
    public String getBundleName() {
        return bundleName;
    }

    @JsonProperty("expiry_type")
    public Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("price_per_unit")
    public int getPricePerUnit() {
        return pricePerUnit;
    }

    @JsonProperty("price_per_unit_decimal")
    public Optional<String> getPricePerUnitDecimal() {
        return pricePerUnitDecimal;
    }

    @JsonProperty("quantity")
    public Optional<Integer> getQuantity() {
        return quantity;
    }

    @JsonProperty("status")
    public Optional<UpdateCreditBundleDetailsRequestBodyStatus> getStatus() {
        return status;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateCreditBundleDetailsRequestBody
                && equalTo((UpdateCreditBundleDetailsRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCreditBundleDetailsRequestBody other) {
        return bundleName.equals(other.bundleName)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && pricePerUnit == other.pricePerUnit
                && pricePerUnitDecimal.equals(other.pricePerUnitDecimal)
                && quantity.equals(other.quantity)
                && status.equals(other.status);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.bundleName,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.pricePerUnit,
                this.pricePerUnitDecimal,
                this.quantity,
                this.status);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleNameStage builder() {
        return new Builder();
    }

    public interface BundleNameStage {
        PricePerUnitStage bundleName(@NotNull String bundleName);

        Builder from(UpdateCreditBundleDetailsRequestBody other);
    }

    public interface PricePerUnitStage {
        _FinalStage pricePerUnit(int pricePerUnit);
    }

    public interface _FinalStage {
        UpdateCreditBundleDetailsRequestBody build();

        _FinalStage expiryType(Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType);

        _FinalStage expiryType(UpdateCreditBundleDetailsRequestBodyExpiryType expiryType);

        _FinalStage expiryUnit(Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit);

        _FinalStage expiryUnit(UpdateCreditBundleDetailsRequestBodyExpiryUnit expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage pricePerUnitDecimal(Optional<String> pricePerUnitDecimal);

        _FinalStage pricePerUnitDecimal(String pricePerUnitDecimal);

        _FinalStage quantity(Optional<Integer> quantity);

        _FinalStage quantity(Integer quantity);

        _FinalStage status(Optional<UpdateCreditBundleDetailsRequestBodyStatus> status);

        _FinalStage status(UpdateCreditBundleDetailsRequestBodyStatus status);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements BundleNameStage, PricePerUnitStage, _FinalStage {
        private String bundleName;

        private int pricePerUnit;

        private Optional<UpdateCreditBundleDetailsRequestBodyStatus> status = Optional.empty();

        private Optional<Integer> quantity = Optional.empty();

        private Optional<String> pricePerUnitDecimal = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit = Optional.empty();

        private Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateCreditBundleDetailsRequestBody other) {
            bundleName(other.getBundleName());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            pricePerUnit(other.getPricePerUnit());
            pricePerUnitDecimal(other.getPricePerUnitDecimal());
            quantity(other.getQuantity());
            status(other.getStatus());
            return this;
        }

        @java.lang.Override
        @JsonSetter("bundle_name")
        public PricePerUnitStage bundleName(@NotNull String bundleName) {
            this.bundleName = Objects.requireNonNull(bundleName, "bundleName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_per_unit")
        public _FinalStage pricePerUnit(int pricePerUnit) {
            this.pricePerUnit = pricePerUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage status(UpdateCreditBundleDetailsRequestBodyStatus status) {
            this.status = Optional.ofNullable(status);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "status", nulls = Nulls.SKIP)
        public _FinalStage status(Optional<UpdateCreditBundleDetailsRequestBodyStatus> status) {
            this.status = status;
            return this;
        }

        @java.lang.Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "quantity", nulls = Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public _FinalStage pricePerUnitDecimal(String pricePerUnitDecimal) {
            this.pricePerUnitDecimal = Optional.ofNullable(pricePerUnitDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_per_unit_decimal", nulls = Nulls.SKIP)
        public _FinalStage pricePerUnitDecimal(Optional<String> pricePerUnitDecimal) {
            this.pricePerUnitDecimal = pricePerUnitDecimal;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(UpdateCreditBundleDetailsRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<UpdateCreditBundleDetailsRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(UpdateCreditBundleDetailsRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<UpdateCreditBundleDetailsRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public UpdateCreditBundleDetailsRequestBody build() {
            return new UpdateCreditBundleDetailsRequestBody(
                    bundleName,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    pricePerUnit,
                    pricePerUnitDecimal,
                    quantity,
                    status,
                    additionalProperties);
        }
    }
}
