/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.crm.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateCrmDealLineItemAssociationRequestBody.Builder.class)
public final class CreateCrmDealLineItemAssociationRequestBody {
    private final String dealExternalId;

    private final String lineItemExternalId;

    private final Map<String, Object> additionalProperties;

    private CreateCrmDealLineItemAssociationRequestBody(
            String dealExternalId, String lineItemExternalId, Map<String, Object> additionalProperties) {
        this.dealExternalId = dealExternalId;
        this.lineItemExternalId = lineItemExternalId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("deal_external_id")
    public String getDealExternalId() {
        return dealExternalId;
    }

    @JsonProperty("line_item_external_id")
    public String getLineItemExternalId() {
        return lineItemExternalId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateCrmDealLineItemAssociationRequestBody
                && equalTo((CreateCrmDealLineItemAssociationRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateCrmDealLineItemAssociationRequestBody other) {
        return dealExternalId.equals(other.dealExternalId) && lineItemExternalId.equals(other.lineItemExternalId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.dealExternalId, this.lineItemExternalId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static DealExternalIdStage builder() {
        return new Builder();
    }

    public interface DealExternalIdStage {
        LineItemExternalIdStage dealExternalId(@NotNull String dealExternalId);

        Builder from(CreateCrmDealLineItemAssociationRequestBody other);
    }

    public interface LineItemExternalIdStage {
        _FinalStage lineItemExternalId(@NotNull String lineItemExternalId);
    }

    public interface _FinalStage {
        CreateCrmDealLineItemAssociationRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements DealExternalIdStage, LineItemExternalIdStage, _FinalStage {
        private String dealExternalId;

        private String lineItemExternalId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateCrmDealLineItemAssociationRequestBody other) {
            dealExternalId(other.getDealExternalId());
            lineItemExternalId(other.getLineItemExternalId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("deal_external_id")
        public LineItemExternalIdStage dealExternalId(@NotNull String dealExternalId) {
            this.dealExternalId = Objects.requireNonNull(dealExternalId, "dealExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("line_item_external_id")
        public _FinalStage lineItemExternalId(@NotNull String lineItemExternalId) {
            this.lineItemExternalId = Objects.requireNonNull(lineItemExternalId, "lineItemExternalId must not be null");
            return this;
        }

        @java.lang.Override
        public CreateCrmDealLineItemAssociationRequestBody build() {
            return new CreateCrmDealLineItemAssociationRequestBody(
                    dealExternalId, lineItemExternalId, additionalProperties);
        }
    }
}
