/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.dataexports.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateDataExportRequestBody.Builder.class)
public final class CreateDataExportRequestBody {
    private final String metadata;

    private final Map<String, Object> additionalProperties;

    private CreateDataExportRequestBody(String metadata, Map<String, Object> additionalProperties) {
        this.metadata = metadata;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("export_type")
    public String getExportType() {
        return "company-feature-usage";
    }

    @JsonProperty("metadata")
    public String getMetadata() {
        return metadata;
    }

    @JsonProperty("output_file_type")
    public String getOutputFileType() {
        return "csv";
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateDataExportRequestBody && equalTo((CreateDataExportRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateDataExportRequestBody other) {
        return metadata.equals(other.metadata);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.metadata);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static MetadataStage builder() {
        return new Builder();
    }

    public interface MetadataStage {
        _FinalStage metadata(@NotNull String metadata);

        Builder from(CreateDataExportRequestBody other);
    }

    public interface _FinalStage {
        CreateDataExportRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements MetadataStage, _FinalStage {
        private String metadata;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateDataExportRequestBody other) {
            metadata(other.getMetadata());
            return this;
        }

        @java.lang.Override
        @JsonSetter("metadata")
        public _FinalStage metadata(@NotNull String metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata must not be null");
            return this;
        }

        @java.lang.Override
        public CreateDataExportRequestBody build() {
            return new CreateDataExportRequestBody(metadata, additionalProperties);
        }
    }
}
