/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.entitlements.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CountCompanyOverridesRequest.Builder.class)
public final class CountCompanyOverridesRequest {
    private final Optional<List<String>> companyIds;

    private final Optional<List<String>> featureIds;

    private final Optional<List<String>> ids;

    private final Optional<String> companyId;

    private final Optional<String> featureId;

    private final Optional<Boolean> withoutExpired;

    private final Optional<String> q;

    private final Optional<Integer> limit;

    private final Optional<Integer> offset;

    private final Map<String, Object> additionalProperties;

    private CountCompanyOverridesRequest(
            Optional<List<String>> companyIds,
            Optional<List<String>> featureIds,
            Optional<List<String>> ids,
            Optional<String> companyId,
            Optional<String> featureId,
            Optional<Boolean> withoutExpired,
            Optional<String> q,
            Optional<Integer> limit,
            Optional<Integer> offset,
            Map<String, Object> additionalProperties) {
        this.companyIds = companyIds;
        this.featureIds = featureIds;
        this.ids = ids;
        this.companyId = companyId;
        this.featureId = featureId;
        this.withoutExpired = withoutExpired;
        this.q = q;
        this.limit = limit;
        this.offset = offset;
        this.additionalProperties = additionalProperties;
    }

    /**
     * @return Filter company overrides by multiple company IDs (starting with comp_)
     */
    @JsonProperty("company_ids")
    public Optional<List<String>> getCompanyIds() {
        return companyIds;
    }

    /**
     * @return Filter company overrides by multiple feature IDs (starting with feat_)
     */
    @JsonProperty("feature_ids")
    public Optional<List<String>> getFeatureIds() {
        return featureIds;
    }

    /**
     * @return Filter company overrides by multiple company override IDs (starting with cmov_)
     */
    @JsonProperty("ids")
    public Optional<List<String>> getIds() {
        return ids;
    }

    /**
     * @return Filter company overrides by a single company ID (starting with comp_)
     */
    @JsonProperty("company_id")
    public Optional<String> getCompanyId() {
        return companyId;
    }

    /**
     * @return Filter company overrides by a single feature ID (starting with feat_)
     */
    @JsonProperty("feature_id")
    public Optional<String> getFeatureId() {
        return featureId;
    }

    /**
     * @return Filter company overrides by whether they have not expired
     */
    @JsonProperty("without_expired")
    public Optional<Boolean> getWithoutExpired() {
        return withoutExpired;
    }

    /**
     * @return Search for company overrides by feature or company name
     */
    @JsonProperty("q")
    public Optional<String> getQ() {
        return q;
    }

    /**
     * @return Page limit (default 100)
     */
    @JsonProperty("limit")
    public Optional<Integer> getLimit() {
        return limit;
    }

    /**
     * @return Page offset (default 0)
     */
    @JsonProperty("offset")
    public Optional<Integer> getOffset() {
        return offset;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CountCompanyOverridesRequest && equalTo((CountCompanyOverridesRequest) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CountCompanyOverridesRequest other) {
        return companyIds.equals(other.companyIds)
                && featureIds.equals(other.featureIds)
                && ids.equals(other.ids)
                && companyId.equals(other.companyId)
                && featureId.equals(other.featureId)
                && withoutExpired.equals(other.withoutExpired)
                && q.equals(other.q)
                && limit.equals(other.limit)
                && offset.equals(other.offset);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyIds,
                this.featureIds,
                this.ids,
                this.companyId,
                this.featureId,
                this.withoutExpired,
                this.q,
                this.limit,
                this.offset);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<List<String>> companyIds = Optional.empty();

        private Optional<List<String>> featureIds = Optional.empty();

        private Optional<List<String>> ids = Optional.empty();

        private Optional<String> companyId = Optional.empty();

        private Optional<String> featureId = Optional.empty();

        private Optional<Boolean> withoutExpired = Optional.empty();

        private Optional<String> q = Optional.empty();

        private Optional<Integer> limit = Optional.empty();

        private Optional<Integer> offset = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(CountCompanyOverridesRequest other) {
            companyIds(other.getCompanyIds());
            featureIds(other.getFeatureIds());
            ids(other.getIds());
            companyId(other.getCompanyId());
            featureId(other.getFeatureId());
            withoutExpired(other.getWithoutExpired());
            q(other.getQ());
            limit(other.getLimit());
            offset(other.getOffset());
            return this;
        }

        /**
         * <p>Filter company overrides by multiple company IDs (starting with comp_)</p>
         */
        @JsonSetter(value = "company_ids", nulls = Nulls.SKIP)
        public Builder companyIds(Optional<List<String>> companyIds) {
            this.companyIds = companyIds;
            return this;
        }

        public Builder companyIds(List<String> companyIds) {
            this.companyIds = Optional.ofNullable(companyIds);
            return this;
        }

        public Builder companyIds(String companyIds) {
            this.companyIds = Optional.of(Collections.singletonList(companyIds));
            return this;
        }

        /**
         * <p>Filter company overrides by multiple feature IDs (starting with feat_)</p>
         */
        @JsonSetter(value = "feature_ids", nulls = Nulls.SKIP)
        public Builder featureIds(Optional<List<String>> featureIds) {
            this.featureIds = featureIds;
            return this;
        }

        public Builder featureIds(List<String> featureIds) {
            this.featureIds = Optional.ofNullable(featureIds);
            return this;
        }

        public Builder featureIds(String featureIds) {
            this.featureIds = Optional.of(Collections.singletonList(featureIds));
            return this;
        }

        /**
         * <p>Filter company overrides by multiple company override IDs (starting with cmov_)</p>
         */
        @JsonSetter(value = "ids", nulls = Nulls.SKIP)
        public Builder ids(Optional<List<String>> ids) {
            this.ids = ids;
            return this;
        }

        public Builder ids(List<String> ids) {
            this.ids = Optional.ofNullable(ids);
            return this;
        }

        public Builder ids(String ids) {
            this.ids = Optional.of(Collections.singletonList(ids));
            return this;
        }

        /**
         * <p>Filter company overrides by a single company ID (starting with comp_)</p>
         */
        @JsonSetter(value = "company_id", nulls = Nulls.SKIP)
        public Builder companyId(Optional<String> companyId) {
            this.companyId = companyId;
            return this;
        }

        public Builder companyId(String companyId) {
            this.companyId = Optional.ofNullable(companyId);
            return this;
        }

        /**
         * <p>Filter company overrides by a single feature ID (starting with feat_)</p>
         */
        @JsonSetter(value = "feature_id", nulls = Nulls.SKIP)
        public Builder featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        public Builder featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        /**
         * <p>Filter company overrides by whether they have not expired</p>
         */
        @JsonSetter(value = "without_expired", nulls = Nulls.SKIP)
        public Builder withoutExpired(Optional<Boolean> withoutExpired) {
            this.withoutExpired = withoutExpired;
            return this;
        }

        public Builder withoutExpired(Boolean withoutExpired) {
            this.withoutExpired = Optional.ofNullable(withoutExpired);
            return this;
        }

        /**
         * <p>Search for company overrides by feature or company name</p>
         */
        @JsonSetter(value = "q", nulls = Nulls.SKIP)
        public Builder q(Optional<String> q) {
            this.q = q;
            return this;
        }

        public Builder q(String q) {
            this.q = Optional.ofNullable(q);
            return this;
        }

        /**
         * <p>Page limit (default 100)</p>
         */
        @JsonSetter(value = "limit", nulls = Nulls.SKIP)
        public Builder limit(Optional<Integer> limit) {
            this.limit = limit;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = Optional.ofNullable(limit);
            return this;
        }

        /**
         * <p>Page offset (default 0)</p>
         */
        @JsonSetter(value = "offset", nulls = Nulls.SKIP)
        public Builder offset(Optional<Integer> offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(Integer offset) {
            this.offset = Optional.ofNullable(offset);
            return this;
        }

        public CountCompanyOverridesRequest build() {
            return new CountCompanyOverridesRequest(
                    companyIds,
                    featureIds,
                    ids,
                    companyId,
                    featureId,
                    withoutExpired,
                    q,
                    limit,
                    offset,
                    additionalProperties);
        }
    }
}
