/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.events;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.events.requests.CreateEventBatchRequestBody;
import com.schematic.api.resources.events.requests.GetEventSummariesRequest;
import com.schematic.api.resources.events.requests.ListEventsRequest;
import com.schematic.api.resources.events.types.CreateEventBatchResponse;
import com.schematic.api.resources.events.types.CreateEventResponse;
import com.schematic.api.resources.events.types.GetEventResponse;
import com.schematic.api.resources.events.types.GetEventSummariesResponse;
import com.schematic.api.resources.events.types.GetSegmentIntegrationStatusResponse;
import com.schematic.api.resources.events.types.ListEventsResponse;
import com.schematic.api.types.CreateEventRequestBody;
import java.util.concurrent.CompletableFuture;

public class AsyncEventsClient {
    protected final ClientOptions clientOptions;

    private final AsyncRawEventsClient rawClient;

    public AsyncEventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new AsyncRawEventsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public AsyncRawEventsClient withRawResponse() {
        return this.rawClient;
    }

    public CompletableFuture<CreateEventBatchResponse> createEventBatch(CreateEventBatchRequestBody request) {
        return this.rawClient.createEventBatch(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateEventBatchResponse> createEventBatch(
            CreateEventBatchRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createEventBatch(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetEventSummariesResponse> getEventSummaries() {
        return this.rawClient.getEventSummaries().thenApply(response -> response.body());
    }

    public CompletableFuture<GetEventSummariesResponse> getEventSummaries(GetEventSummariesRequest request) {
        return this.rawClient.getEventSummaries(request).thenApply(response -> response.body());
    }

    public CompletableFuture<GetEventSummariesResponse> getEventSummaries(
            GetEventSummariesRequest request, RequestOptions requestOptions) {
        return this.rawClient.getEventSummaries(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<ListEventsResponse> listEvents() {
        return this.rawClient.listEvents().thenApply(response -> response.body());
    }

    public CompletableFuture<ListEventsResponse> listEvents(ListEventsRequest request) {
        return this.rawClient.listEvents(request).thenApply(response -> response.body());
    }

    public CompletableFuture<ListEventsResponse> listEvents(ListEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEvents(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateEventResponse> createEvent(CreateEventRequestBody request) {
        return this.rawClient.createEvent(request).thenApply(response -> response.body());
    }

    public CompletableFuture<CreateEventResponse> createEvent(
            CreateEventRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createEvent(request, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetEventResponse> getEvent(String eventId) {
        return this.rawClient.getEvent(eventId).thenApply(response -> response.body());
    }

    public CompletableFuture<GetEventResponse> getEvent(String eventId, RequestOptions requestOptions) {
        return this.rawClient.getEvent(eventId, requestOptions).thenApply(response -> response.body());
    }

    public CompletableFuture<GetSegmentIntegrationStatusResponse> getSegmentIntegrationStatus() {
        return this.rawClient.getSegmentIntegrationStatus().thenApply(response -> response.body());
    }

    public CompletableFuture<GetSegmentIntegrationStatusResponse> getSegmentIntegrationStatus(
            RequestOptions requestOptions) {
        return this.rawClient.getSegmentIntegrationStatus(requestOptions).thenApply(response -> response.body());
    }
}
