/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.events;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.events.requests.CreateEventBatchRequestBody;
import com.schematic.api.resources.events.requests.GetEventSummariesRequest;
import com.schematic.api.resources.events.requests.ListEventsRequest;
import com.schematic.api.resources.events.types.CreateEventBatchResponse;
import com.schematic.api.resources.events.types.CreateEventResponse;
import com.schematic.api.resources.events.types.GetEventResponse;
import com.schematic.api.resources.events.types.GetEventSummariesResponse;
import com.schematic.api.resources.events.types.GetSegmentIntegrationStatusResponse;
import com.schematic.api.resources.events.types.ListEventsResponse;
import com.schematic.api.types.CreateEventRequestBody;

public class EventsClient {
    protected final ClientOptions clientOptions;

    private final RawEventsClient rawClient;

    public EventsClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawEventsClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawEventsClient withRawResponse() {
        return this.rawClient;
    }

    public CreateEventBatchResponse createEventBatch(CreateEventBatchRequestBody request) {
        return this.rawClient.createEventBatch(request).body();
    }

    public CreateEventBatchResponse createEventBatch(
            CreateEventBatchRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createEventBatch(request, requestOptions).body();
    }

    public GetEventSummariesResponse getEventSummaries() {
        return this.rawClient.getEventSummaries().body();
    }

    public GetEventSummariesResponse getEventSummaries(GetEventSummariesRequest request) {
        return this.rawClient.getEventSummaries(request).body();
    }

    public GetEventSummariesResponse getEventSummaries(
            GetEventSummariesRequest request, RequestOptions requestOptions) {
        return this.rawClient.getEventSummaries(request, requestOptions).body();
    }

    public ListEventsResponse listEvents() {
        return this.rawClient.listEvents().body();
    }

    public ListEventsResponse listEvents(ListEventsRequest request) {
        return this.rawClient.listEvents(request).body();
    }

    public ListEventsResponse listEvents(ListEventsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listEvents(request, requestOptions).body();
    }

    public CreateEventResponse createEvent(CreateEventRequestBody request) {
        return this.rawClient.createEvent(request).body();
    }

    public CreateEventResponse createEvent(CreateEventRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createEvent(request, requestOptions).body();
    }

    public GetEventResponse getEvent(String eventId) {
        return this.rawClient.getEvent(eventId).body();
    }

    public GetEventResponse getEvent(String eventId, RequestOptions requestOptions) {
        return this.rawClient.getEvent(eventId, requestOptions).body();
    }

    public GetSegmentIntegrationStatusResponse getSegmentIntegrationStatus() {
        return this.rawClient.getSegmentIntegrationStatus().body();
    }

    public GetSegmentIntegrationStatusResponse getSegmentIntegrationStatus(RequestOptions requestOptions) {
        return this.rawClient.getSegmentIntegrationStatus(requestOptions).body();
    }
}
