/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.features;

import com.schematic.api.core.ClientOptions;
import com.schematic.api.core.RequestOptions;
import com.schematic.api.resources.features.requests.CountFeaturesRequest;
import com.schematic.api.resources.features.requests.CountFlagsRequest;
import com.schematic.api.resources.features.requests.CreateFeatureRequestBody;
import com.schematic.api.resources.features.requests.ListFeaturesRequest;
import com.schematic.api.resources.features.requests.ListFlagsRequest;
import com.schematic.api.resources.features.requests.UpdateFeatureRequestBody;
import com.schematic.api.resources.features.requests.UpdateFlagRulesRequestBody;
import com.schematic.api.resources.features.types.CheckFlagResponse;
import com.schematic.api.resources.features.types.CheckFlagsResponse;
import com.schematic.api.resources.features.types.CountFeaturesResponse;
import com.schematic.api.resources.features.types.CountFlagsResponse;
import com.schematic.api.resources.features.types.CreateFeatureResponse;
import com.schematic.api.resources.features.types.CreateFlagResponse;
import com.schematic.api.resources.features.types.DeleteFeatureResponse;
import com.schematic.api.resources.features.types.DeleteFlagResponse;
import com.schematic.api.resources.features.types.GetFeatureResponse;
import com.schematic.api.resources.features.types.GetFlagResponse;
import com.schematic.api.resources.features.types.ListFeaturesResponse;
import com.schematic.api.resources.features.types.ListFlagsResponse;
import com.schematic.api.resources.features.types.UpdateFeatureResponse;
import com.schematic.api.resources.features.types.UpdateFlagResponse;
import com.schematic.api.resources.features.types.UpdateFlagRulesResponse;
import com.schematic.api.types.CheckFlagRequestBody;
import com.schematic.api.types.CreateFlagRequestBody;

public class FeaturesClient {
    protected final ClientOptions clientOptions;

    private final RawFeaturesClient rawClient;

    public FeaturesClient(ClientOptions clientOptions) {
        this.clientOptions = clientOptions;
        this.rawClient = new RawFeaturesClient(clientOptions);
    }

    /**
     * Get responses with HTTP metadata like headers
     */
    public RawFeaturesClient withRawResponse() {
        return this.rawClient;
    }

    public ListFeaturesResponse listFeatures() {
        return this.rawClient.listFeatures().body();
    }

    public ListFeaturesResponse listFeatures(ListFeaturesRequest request) {
        return this.rawClient.listFeatures(request).body();
    }

    public ListFeaturesResponse listFeatures(ListFeaturesRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFeatures(request, requestOptions).body();
    }

    public CreateFeatureResponse createFeature(CreateFeatureRequestBody request) {
        return this.rawClient.createFeature(request).body();
    }

    public CreateFeatureResponse createFeature(CreateFeatureRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createFeature(request, requestOptions).body();
    }

    public GetFeatureResponse getFeature(String featureId) {
        return this.rawClient.getFeature(featureId).body();
    }

    public GetFeatureResponse getFeature(String featureId, RequestOptions requestOptions) {
        return this.rawClient.getFeature(featureId, requestOptions).body();
    }

    public UpdateFeatureResponse updateFeature(String featureId) {
        return this.rawClient.updateFeature(featureId).body();
    }

    public UpdateFeatureResponse updateFeature(String featureId, UpdateFeatureRequestBody request) {
        return this.rawClient.updateFeature(featureId, request).body();
    }

    public UpdateFeatureResponse updateFeature(
            String featureId, UpdateFeatureRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateFeature(featureId, request, requestOptions).body();
    }

    public DeleteFeatureResponse deleteFeature(String featureId) {
        return this.rawClient.deleteFeature(featureId).body();
    }

    public DeleteFeatureResponse deleteFeature(String featureId, RequestOptions requestOptions) {
        return this.rawClient.deleteFeature(featureId, requestOptions).body();
    }

    public CountFeaturesResponse countFeatures() {
        return this.rawClient.countFeatures().body();
    }

    public CountFeaturesResponse countFeatures(CountFeaturesRequest request) {
        return this.rawClient.countFeatures(request).body();
    }

    public CountFeaturesResponse countFeatures(CountFeaturesRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFeatures(request, requestOptions).body();
    }

    public ListFlagsResponse listFlags() {
        return this.rawClient.listFlags().body();
    }

    public ListFlagsResponse listFlags(ListFlagsRequest request) {
        return this.rawClient.listFlags(request).body();
    }

    public ListFlagsResponse listFlags(ListFlagsRequest request, RequestOptions requestOptions) {
        return this.rawClient.listFlags(request, requestOptions).body();
    }

    public CreateFlagResponse createFlag(CreateFlagRequestBody request) {
        return this.rawClient.createFlag(request).body();
    }

    public CreateFlagResponse createFlag(CreateFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.createFlag(request, requestOptions).body();
    }

    public GetFlagResponse getFlag(String flagId) {
        return this.rawClient.getFlag(flagId).body();
    }

    public GetFlagResponse getFlag(String flagId, RequestOptions requestOptions) {
        return this.rawClient.getFlag(flagId, requestOptions).body();
    }

    public UpdateFlagResponse updateFlag(String flagId, CreateFlagRequestBody request) {
        return this.rawClient.updateFlag(flagId, request).body();
    }

    public UpdateFlagResponse updateFlag(String flagId, CreateFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateFlag(flagId, request, requestOptions).body();
    }

    public DeleteFlagResponse deleteFlag(String flagId) {
        return this.rawClient.deleteFlag(flagId).body();
    }

    public DeleteFlagResponse deleteFlag(String flagId, RequestOptions requestOptions) {
        return this.rawClient.deleteFlag(flagId, requestOptions).body();
    }

    public UpdateFlagRulesResponse updateFlagRules(String flagId, UpdateFlagRulesRequestBody request) {
        return this.rawClient.updateFlagRules(flagId, request).body();
    }

    public UpdateFlagRulesResponse updateFlagRules(
            String flagId, UpdateFlagRulesRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.updateFlagRules(flagId, request, requestOptions).body();
    }

    public CheckFlagResponse checkFlag(String key) {
        return this.rawClient.checkFlag(key).body();
    }

    public CheckFlagResponse checkFlag(String key, CheckFlagRequestBody request) {
        return this.rawClient.checkFlag(key, request).body();
    }

    public CheckFlagResponse checkFlag(String key, CheckFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.checkFlag(key, request, requestOptions).body();
    }

    public CheckFlagsResponse checkFlags() {
        return this.rawClient.checkFlags().body();
    }

    public CheckFlagsResponse checkFlags(CheckFlagRequestBody request) {
        return this.rawClient.checkFlags(request).body();
    }

    public CheckFlagsResponse checkFlags(CheckFlagRequestBody request, RequestOptions requestOptions) {
        return this.rawClient.checkFlags(request, requestOptions).body();
    }

    public CountFlagsResponse countFlags() {
        return this.rawClient.countFlags().body();
    }

    public CountFlagsResponse countFlags(CountFlagsRequest request) {
        return this.rawClient.countFlags(request).body();
    }

    public CountFlagsResponse countFlags(CountFlagsRequest request, RequestOptions requestOptions) {
        return this.rawClient.countFlags(request, requestOptions).body();
    }
}
