/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.features.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.features.types.UpdateFeatureRequestBodyFeatureType;
import com.schematic.api.resources.features.types.UpdateFeatureRequestBodyLifecyclePhase;
import com.schematic.api.types.CreateOrUpdateFlagRequestBody;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateFeatureRequestBody.Builder.class)
public final class UpdateFeatureRequestBody {
    private final Optional<String> description;

    private final Optional<String> eventSubtype;

    private final Optional<UpdateFeatureRequestBodyFeatureType> featureType;

    private final Optional<CreateOrUpdateFlagRequestBody> flag;

    private final Optional<String> icon;

    private final Optional<UpdateFeatureRequestBodyLifecyclePhase> lifecyclePhase;

    private final Optional<String> maintainerId;

    private final Optional<String> name;

    private final Optional<String> pluralName;

    private final Optional<String> singularName;

    private final Optional<String> traitId;

    private final Map<String, Object> additionalProperties;

    private UpdateFeatureRequestBody(
            Optional<String> description,
            Optional<String> eventSubtype,
            Optional<UpdateFeatureRequestBodyFeatureType> featureType,
            Optional<CreateOrUpdateFlagRequestBody> flag,
            Optional<String> icon,
            Optional<UpdateFeatureRequestBodyLifecyclePhase> lifecyclePhase,
            Optional<String> maintainerId,
            Optional<String> name,
            Optional<String> pluralName,
            Optional<String> singularName,
            Optional<String> traitId,
            Map<String, Object> additionalProperties) {
        this.description = description;
        this.eventSubtype = eventSubtype;
        this.featureType = featureType;
        this.flag = flag;
        this.icon = icon;
        this.lifecyclePhase = lifecyclePhase;
        this.maintainerId = maintainerId;
        this.name = name;
        this.pluralName = pluralName;
        this.singularName = singularName;
        this.traitId = traitId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("event_subtype")
    public Optional<String> getEventSubtype() {
        return eventSubtype;
    }

    @JsonProperty("feature_type")
    public Optional<UpdateFeatureRequestBodyFeatureType> getFeatureType() {
        return featureType;
    }

    @JsonProperty("flag")
    public Optional<CreateOrUpdateFlagRequestBody> getFlag() {
        return flag;
    }

    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    @JsonProperty("lifecycle_phase")
    public Optional<UpdateFeatureRequestBodyLifecyclePhase> getLifecyclePhase() {
        return lifecyclePhase;
    }

    @JsonProperty("maintainer_id")
    public Optional<String> getMaintainerId() {
        return maintainerId;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    @JsonProperty("plural_name")
    public Optional<String> getPluralName() {
        return pluralName;
    }

    @JsonProperty("singular_name")
    public Optional<String> getSingularName() {
        return singularName;
    }

    @JsonProperty("trait_id")
    public Optional<String> getTraitId() {
        return traitId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateFeatureRequestBody && equalTo((UpdateFeatureRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateFeatureRequestBody other) {
        return description.equals(other.description)
                && eventSubtype.equals(other.eventSubtype)
                && featureType.equals(other.featureType)
                && flag.equals(other.flag)
                && icon.equals(other.icon)
                && lifecyclePhase.equals(other.lifecyclePhase)
                && maintainerId.equals(other.maintainerId)
                && name.equals(other.name)
                && pluralName.equals(other.pluralName)
                && singularName.equals(other.singularName)
                && traitId.equals(other.traitId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.description,
                this.eventSubtype,
                this.featureType,
                this.flag,
                this.icon,
                this.lifecyclePhase,
                this.maintainerId,
                this.name,
                this.pluralName,
                this.singularName,
                this.traitId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<String> description = Optional.empty();

        private Optional<String> eventSubtype = Optional.empty();

        private Optional<UpdateFeatureRequestBodyFeatureType> featureType = Optional.empty();

        private Optional<CreateOrUpdateFlagRequestBody> flag = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<UpdateFeatureRequestBodyLifecyclePhase> lifecyclePhase = Optional.empty();

        private Optional<String> maintainerId = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> pluralName = Optional.empty();

        private Optional<String> singularName = Optional.empty();

        private Optional<String> traitId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(UpdateFeatureRequestBody other) {
            description(other.getDescription());
            eventSubtype(other.getEventSubtype());
            featureType(other.getFeatureType());
            flag(other.getFlag());
            icon(other.getIcon());
            lifecyclePhase(other.getLifecyclePhase());
            maintainerId(other.getMaintainerId());
            name(other.getName());
            pluralName(other.getPluralName());
            singularName(other.getSingularName());
            traitId(other.getTraitId());
            return this;
        }

        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public Builder description(Optional<String> description) {
            this.description = description;
            return this;
        }

        public Builder description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @JsonSetter(value = "event_subtype", nulls = Nulls.SKIP)
        public Builder eventSubtype(Optional<String> eventSubtype) {
            this.eventSubtype = eventSubtype;
            return this;
        }

        public Builder eventSubtype(String eventSubtype) {
            this.eventSubtype = Optional.ofNullable(eventSubtype);
            return this;
        }

        @JsonSetter(value = "feature_type", nulls = Nulls.SKIP)
        public Builder featureType(Optional<UpdateFeatureRequestBodyFeatureType> featureType) {
            this.featureType = featureType;
            return this;
        }

        public Builder featureType(UpdateFeatureRequestBodyFeatureType featureType) {
            this.featureType = Optional.ofNullable(featureType);
            return this;
        }

        @JsonSetter(value = "flag", nulls = Nulls.SKIP)
        public Builder flag(Optional<CreateOrUpdateFlagRequestBody> flag) {
            this.flag = flag;
            return this;
        }

        public Builder flag(CreateOrUpdateFlagRequestBody flag) {
            this.flag = Optional.ofNullable(flag);
            return this;
        }

        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public Builder icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        public Builder icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @JsonSetter(value = "lifecycle_phase", nulls = Nulls.SKIP)
        public Builder lifecyclePhase(Optional<UpdateFeatureRequestBodyLifecyclePhase> lifecyclePhase) {
            this.lifecyclePhase = lifecyclePhase;
            return this;
        }

        public Builder lifecyclePhase(UpdateFeatureRequestBodyLifecyclePhase lifecyclePhase) {
            this.lifecyclePhase = Optional.ofNullable(lifecyclePhase);
            return this;
        }

        @JsonSetter(value = "maintainer_id", nulls = Nulls.SKIP)
        public Builder maintainerId(Optional<String> maintainerId) {
            this.maintainerId = maintainerId;
            return this;
        }

        public Builder maintainerId(String maintainerId) {
            this.maintainerId = Optional.ofNullable(maintainerId);
            return this;
        }

        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public Builder name(Optional<String> name) {
            this.name = name;
            return this;
        }

        public Builder name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @JsonSetter(value = "plural_name", nulls = Nulls.SKIP)
        public Builder pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        public Builder pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @JsonSetter(value = "singular_name", nulls = Nulls.SKIP)
        public Builder singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        public Builder singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @JsonSetter(value = "trait_id", nulls = Nulls.SKIP)
        public Builder traitId(Optional<String> traitId) {
            this.traitId = traitId;
            return this;
        }

        public Builder traitId(String traitId) {
            this.traitId = Optional.ofNullable(traitId);
            return this;
        }

        public UpdateFeatureRequestBody build() {
            return new UpdateFeatureRequestBody(
                    description,
                    eventSubtype,
                    featureType,
                    flag,
                    icon,
                    lifecyclePhase,
                    maintainerId,
                    name,
                    pluralName,
                    singularName,
                    traitId,
                    additionalProperties);
        }
    }
}
