/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.plans.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateCompanyPlansRequestBody.Builder.class)
public final class UpdateCompanyPlansRequestBody {
    private final List<String> addOnIds;

    private final Optional<String> basePlanId;

    private final Map<String, Object> additionalProperties;

    private UpdateCompanyPlansRequestBody(
            List<String> addOnIds, Optional<String> basePlanId, Map<String, Object> additionalProperties) {
        this.addOnIds = addOnIds;
        this.basePlanId = basePlanId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("add_on_ids")
    public List<String> getAddOnIds() {
        return addOnIds;
    }

    @JsonProperty("base_plan_id")
    public Optional<String> getBasePlanId() {
        return basePlanId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateCompanyPlansRequestBody && equalTo((UpdateCompanyPlansRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateCompanyPlansRequestBody other) {
        return addOnIds.equals(other.addOnIds) && basePlanId.equals(other.basePlanId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.addOnIds, this.basePlanId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private List<String> addOnIds = new ArrayList<>();

        private Optional<String> basePlanId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(UpdateCompanyPlansRequestBody other) {
            addOnIds(other.getAddOnIds());
            basePlanId(other.getBasePlanId());
            return this;
        }

        @JsonSetter(value = "add_on_ids", nulls = Nulls.SKIP)
        public Builder addOnIds(List<String> addOnIds) {
            this.addOnIds.clear();
            if (addOnIds != null) {
                this.addOnIds.addAll(addOnIds);
            }
            return this;
        }

        public Builder addAddOnIds(String addOnIds) {
            this.addOnIds.add(addOnIds);
            return this;
        }

        public Builder addAllAddOnIds(List<String> addOnIds) {
            if (addOnIds != null) {
                this.addOnIds.addAll(addOnIds);
            }
            return this;
        }

        @JsonSetter(value = "base_plan_id", nulls = Nulls.SKIP)
        public Builder basePlanId(Optional<String> basePlanId) {
            this.basePlanId = basePlanId;
            return this;
        }

        public Builder basePlanId(String basePlanId) {
            this.basePlanId = Optional.ofNullable(basePlanId);
            return this;
        }

        public UpdateCompanyPlansRequestBody build() {
            return new UpdateCompanyPlansRequestBody(addOnIds, basePlanId, additionalProperties);
        }
    }
}
