/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.resources.webhooks.requests;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import com.schematic.api.resources.webhooks.types.CreateWebhookRequestBodyRequestTypesItem;
import com.schematic.api.types.CreditTriggerConfig;
import com.schematic.api.types.EntitlementTriggerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateWebhookRequestBody.Builder.class)
public final class CreateWebhookRequestBody {
    private final Optional<List<CreditTriggerConfig>> creditTriggerConfigs;

    private final Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs;

    private final String name;

    private final List<CreateWebhookRequestBodyRequestTypesItem> requestTypes;

    private final String url;

    private final Map<String, Object> additionalProperties;

    private CreateWebhookRequestBody(
            Optional<List<CreditTriggerConfig>> creditTriggerConfigs,
            Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs,
            String name,
            List<CreateWebhookRequestBodyRequestTypesItem> requestTypes,
            String url,
            Map<String, Object> additionalProperties) {
        this.creditTriggerConfigs = creditTriggerConfigs;
        this.entitlementTriggerConfigs = entitlementTriggerConfigs;
        this.name = name;
        this.requestTypes = requestTypes;
        this.url = url;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("credit_trigger_configs")
    public Optional<List<CreditTriggerConfig>> getCreditTriggerConfigs() {
        return creditTriggerConfigs;
    }

    @JsonProperty("entitlement_trigger_configs")
    public Optional<List<EntitlementTriggerConfig>> getEntitlementTriggerConfigs() {
        return entitlementTriggerConfigs;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("request_types")
    public List<CreateWebhookRequestBodyRequestTypesItem> getRequestTypes() {
        return requestTypes;
    }

    @JsonProperty("url")
    public String getUrl() {
        return url;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateWebhookRequestBody && equalTo((CreateWebhookRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateWebhookRequestBody other) {
        return creditTriggerConfigs.equals(other.creditTriggerConfigs)
                && entitlementTriggerConfigs.equals(other.entitlementTriggerConfigs)
                && name.equals(other.name)
                && requestTypes.equals(other.requestTypes)
                && url.equals(other.url);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.creditTriggerConfigs, this.entitlementTriggerConfigs, this.name, this.requestTypes, this.url);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        UrlStage name(@NotNull String name);

        Builder from(CreateWebhookRequestBody other);
    }

    public interface UrlStage {
        _FinalStage url(@NotNull String url);
    }

    public interface _FinalStage {
        CreateWebhookRequestBody build();

        _FinalStage creditTriggerConfigs(Optional<List<CreditTriggerConfig>> creditTriggerConfigs);

        _FinalStage creditTriggerConfigs(List<CreditTriggerConfig> creditTriggerConfigs);

        _FinalStage entitlementTriggerConfigs(Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs);

        _FinalStage entitlementTriggerConfigs(List<EntitlementTriggerConfig> entitlementTriggerConfigs);

        _FinalStage requestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes);

        _FinalStage addRequestTypes(CreateWebhookRequestBodyRequestTypesItem requestTypes);

        _FinalStage addAllRequestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, UrlStage, _FinalStage {
        private String name;

        private String url;

        private List<CreateWebhookRequestBodyRequestTypesItem> requestTypes = new ArrayList<>();

        private Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs = Optional.empty();

        private Optional<List<CreditTriggerConfig>> creditTriggerConfigs = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateWebhookRequestBody other) {
            creditTriggerConfigs(other.getCreditTriggerConfigs());
            entitlementTriggerConfigs(other.getEntitlementTriggerConfigs());
            name(other.getName());
            requestTypes(other.getRequestTypes());
            url(other.getUrl());
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public UrlStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("url")
        public _FinalStage url(@NotNull String url) {
            this.url = Objects.requireNonNull(url, "url must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllRequestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes) {
            if (requestTypes != null) {
                this.requestTypes.addAll(requestTypes);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addRequestTypes(CreateWebhookRequestBodyRequestTypesItem requestTypes) {
            this.requestTypes.add(requestTypes);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "request_types", nulls = Nulls.SKIP)
        public _FinalStage requestTypes(List<CreateWebhookRequestBodyRequestTypesItem> requestTypes) {
            this.requestTypes.clear();
            if (requestTypes != null) {
                this.requestTypes.addAll(requestTypes);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage entitlementTriggerConfigs(List<EntitlementTriggerConfig> entitlementTriggerConfigs) {
            this.entitlementTriggerConfigs = Optional.ofNullable(entitlementTriggerConfigs);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entitlement_trigger_configs", nulls = Nulls.SKIP)
        public _FinalStage entitlementTriggerConfigs(
                Optional<List<EntitlementTriggerConfig>> entitlementTriggerConfigs) {
            this.entitlementTriggerConfigs = entitlementTriggerConfigs;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditTriggerConfigs(List<CreditTriggerConfig> creditTriggerConfigs) {
            this.creditTriggerConfigs = Optional.ofNullable(creditTriggerConfigs);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_trigger_configs", nulls = Nulls.SKIP)
        public _FinalStage creditTriggerConfigs(Optional<List<CreditTriggerConfig>> creditTriggerConfigs) {
            this.creditTriggerConfigs = creditTriggerConfigs;
            return this;
        }

        @java.lang.Override
        public CreateWebhookRequestBody build() {
            return new CreateWebhookRequestBody(
                    creditTriggerConfigs, entitlementTriggerConfigs, name, requestTypes, url, additionalProperties);
        }
    }
}
