/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingCreditBundleView.Builder.class)
public final class BillingCreditBundleView {
    private final Optional<String> billingInvoiceId;

    private final String bundleType;

    private final OffsetDateTime createdAt;

    private final Optional<String> creditDescription;

    private final Optional<String> creditIcon;

    private final String creditId;

    private final String creditName;

    private final String expiryType;

    private final String expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final boolean hasGrants;

    private final String id;

    private final String name;

    private final Optional<String> pluralName;

    private final Optional<BillingProductPriceResponseData> price;

    private final Optional<Integer> quantity;

    private final Optional<String> singularName;

    private final String status;

    private final Optional<BillingProductPriceResponseData> unitPrice;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private BillingCreditBundleView(
            Optional<String> billingInvoiceId,
            String bundleType,
            OffsetDateTime createdAt,
            Optional<String> creditDescription,
            Optional<String> creditIcon,
            String creditId,
            String creditName,
            String expiryType,
            String expiryUnit,
            Optional<Integer> expiryUnitCount,
            boolean hasGrants,
            String id,
            String name,
            Optional<String> pluralName,
            Optional<BillingProductPriceResponseData> price,
            Optional<Integer> quantity,
            Optional<String> singularName,
            String status,
            Optional<BillingProductPriceResponseData> unitPrice,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.billingInvoiceId = billingInvoiceId;
        this.bundleType = bundleType;
        this.createdAt = createdAt;
        this.creditDescription = creditDescription;
        this.creditIcon = creditIcon;
        this.creditId = creditId;
        this.creditName = creditName;
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.hasGrants = hasGrants;
        this.id = id;
        this.name = name;
        this.pluralName = pluralName;
        this.price = price;
        this.quantity = quantity;
        this.singularName = singularName;
        this.status = status;
        this.unitPrice = unitPrice;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_invoice_id")
    public Optional<String> getBillingInvoiceId() {
        return billingInvoiceId;
    }

    @JsonProperty("bundle_type")
    public String getBundleType() {
        return bundleType;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("credit_description")
    public Optional<String> getCreditDescription() {
        return creditDescription;
    }

    @JsonProperty("credit_icon")
    public Optional<String> getCreditIcon() {
        return creditIcon;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @JsonProperty("credit_name")
    public String getCreditName() {
        return creditName;
    }

    @JsonProperty("expiry_type")
    public String getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public String getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("has_grants")
    public boolean getHasGrants() {
        return hasGrants;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plural_name")
    public Optional<String> getPluralName() {
        return pluralName;
    }

    @JsonProperty("price")
    public Optional<BillingProductPriceResponseData> getPrice() {
        return price;
    }

    @JsonProperty("quantity")
    public Optional<Integer> getQuantity() {
        return quantity;
    }

    @JsonProperty("singular_name")
    public Optional<String> getSingularName() {
        return singularName;
    }

    @JsonProperty("status")
    public String getStatus() {
        return status;
    }

    @JsonProperty("unit_price")
    public Optional<BillingProductPriceResponseData> getUnitPrice() {
        return unitPrice;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingCreditBundleView && equalTo((BillingCreditBundleView) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditBundleView other) {
        return billingInvoiceId.equals(other.billingInvoiceId)
                && bundleType.equals(other.bundleType)
                && createdAt.equals(other.createdAt)
                && creditDescription.equals(other.creditDescription)
                && creditIcon.equals(other.creditIcon)
                && creditId.equals(other.creditId)
                && creditName.equals(other.creditName)
                && expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && hasGrants == other.hasGrants
                && id.equals(other.id)
                && name.equals(other.name)
                && pluralName.equals(other.pluralName)
                && price.equals(other.price)
                && quantity.equals(other.quantity)
                && singularName.equals(other.singularName)
                && status.equals(other.status)
                && unitPrice.equals(other.unitPrice)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingInvoiceId,
                this.bundleType,
                this.createdAt,
                this.creditDescription,
                this.creditIcon,
                this.creditId,
                this.creditName,
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.hasGrants,
                this.id,
                this.name,
                this.pluralName,
                this.price,
                this.quantity,
                this.singularName,
                this.status,
                this.unitPrice,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BundleTypeStage builder() {
        return new Builder();
    }

    public interface BundleTypeStage {
        CreatedAtStage bundleType(@NotNull String bundleType);

        Builder from(BillingCreditBundleView other);
    }

    public interface CreatedAtStage {
        CreditIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CreditIdStage {
        CreditNameStage creditId(@NotNull String creditId);
    }

    public interface CreditNameStage {
        ExpiryTypeStage creditName(@NotNull String creditName);
    }

    public interface ExpiryTypeStage {
        ExpiryUnitStage expiryType(@NotNull String expiryType);
    }

    public interface ExpiryUnitStage {
        HasGrantsStage expiryUnit(@NotNull String expiryUnit);
    }

    public interface HasGrantsStage {
        IdStage hasGrants(boolean hasGrants);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        StatusStage name(@NotNull String name);
    }

    public interface StatusStage {
        UpdatedAtStage status(@NotNull String status);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        BillingCreditBundleView build();

        _FinalStage billingInvoiceId(Optional<String> billingInvoiceId);

        _FinalStage billingInvoiceId(String billingInvoiceId);

        _FinalStage creditDescription(Optional<String> creditDescription);

        _FinalStage creditDescription(String creditDescription);

        _FinalStage creditIcon(Optional<String> creditIcon);

        _FinalStage creditIcon(String creditIcon);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage pluralName(Optional<String> pluralName);

        _FinalStage pluralName(String pluralName);

        _FinalStage price(Optional<BillingProductPriceResponseData> price);

        _FinalStage price(BillingProductPriceResponseData price);

        _FinalStage quantity(Optional<Integer> quantity);

        _FinalStage quantity(Integer quantity);

        _FinalStage singularName(Optional<String> singularName);

        _FinalStage singularName(String singularName);

        _FinalStage unitPrice(Optional<BillingProductPriceResponseData> unitPrice);

        _FinalStage unitPrice(BillingProductPriceResponseData unitPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BundleTypeStage,
                    CreatedAtStage,
                    CreditIdStage,
                    CreditNameStage,
                    ExpiryTypeStage,
                    ExpiryUnitStage,
                    HasGrantsStage,
                    IdStage,
                    NameStage,
                    StatusStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String bundleType;

        private OffsetDateTime createdAt;

        private String creditId;

        private String creditName;

        private String expiryType;

        private String expiryUnit;

        private boolean hasGrants;

        private String id;

        private String name;

        private String status;

        private OffsetDateTime updatedAt;

        private Optional<BillingProductPriceResponseData> unitPrice = Optional.empty();

        private Optional<String> singularName = Optional.empty();

        private Optional<Integer> quantity = Optional.empty();

        private Optional<BillingProductPriceResponseData> price = Optional.empty();

        private Optional<String> pluralName = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<String> creditIcon = Optional.empty();

        private Optional<String> creditDescription = Optional.empty();

        private Optional<String> billingInvoiceId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingCreditBundleView other) {
            billingInvoiceId(other.getBillingInvoiceId());
            bundleType(other.getBundleType());
            createdAt(other.getCreatedAt());
            creditDescription(other.getCreditDescription());
            creditIcon(other.getCreditIcon());
            creditId(other.getCreditId());
            creditName(other.getCreditName());
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            hasGrants(other.getHasGrants());
            id(other.getId());
            name(other.getName());
            pluralName(other.getPluralName());
            price(other.getPrice());
            quantity(other.getQuantity());
            singularName(other.getSingularName());
            status(other.getStatus());
            unitPrice(other.getUnitPrice());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("bundle_type")
        public CreatedAtStage bundleType(@NotNull String bundleType) {
            this.bundleType = Objects.requireNonNull(bundleType, "bundleType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CreditIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_name")
        public ExpiryTypeStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("expiry_type")
        public ExpiryUnitStage expiryType(@NotNull String expiryType) {
            this.expiryType = Objects.requireNonNull(expiryType, "expiryType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("expiry_unit")
        public HasGrantsStage expiryUnit(@NotNull String expiryUnit) {
            this.expiryUnit = Objects.requireNonNull(expiryUnit, "expiryUnit must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("has_grants")
        public IdStage hasGrants(boolean hasGrants) {
            this.hasGrants = hasGrants;
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public StatusStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("status")
        public UpdatedAtStage status(@NotNull String status) {
            this.status = Objects.requireNonNull(status, "status must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage unitPrice(BillingProductPriceResponseData unitPrice) {
            this.unitPrice = Optional.ofNullable(unitPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "unit_price", nulls = Nulls.SKIP)
        public _FinalStage unitPrice(Optional<BillingProductPriceResponseData> unitPrice) {
            this.unitPrice = unitPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "singular_name", nulls = Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @java.lang.Override
        public _FinalStage quantity(Integer quantity) {
            this.quantity = Optional.ofNullable(quantity);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "quantity", nulls = Nulls.SKIP)
        public _FinalStage quantity(Optional<Integer> quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public _FinalStage price(BillingProductPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price", nulls = Nulls.SKIP)
        public _FinalStage price(Optional<BillingProductPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plural_name", nulls = Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_icon", nulls = Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditDescription(String creditDescription) {
            this.creditDescription = Optional.ofNullable(creditDescription);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_description", nulls = Nulls.SKIP)
        public _FinalStage creditDescription(Optional<String> creditDescription) {
            this.creditDescription = creditDescription;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingInvoiceId(String billingInvoiceId) {
            this.billingInvoiceId = Optional.ofNullable(billingInvoiceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_invoice_id", nulls = Nulls.SKIP)
        public _FinalStage billingInvoiceId(Optional<String> billingInvoiceId) {
            this.billingInvoiceId = billingInvoiceId;
            return this;
        }

        @java.lang.Override
        public BillingCreditBundleView build() {
            return new BillingCreditBundleView(
                    billingInvoiceId,
                    bundleType,
                    createdAt,
                    creditDescription,
                    creditIcon,
                    creditId,
                    creditName,
                    expiryType,
                    expiryUnit,
                    expiryUnitCount,
                    hasGrants,
                    id,
                    name,
                    pluralName,
                    price,
                    quantity,
                    singularName,
                    status,
                    unitPrice,
                    updatedAt,
                    additionalProperties);
        }
    }
}
