/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingCreditGrantResponseData.Builder.class)
public final class BillingCreditGrantResponseData {
    private final String companyId;

    private final String companyName;

    private final OffsetDateTime createdAt;

    private final Optional<String> creditIcon;

    private final String creditId;

    private final String creditName;

    private final Optional<OffsetDateTime> expiresAt;

    private final String grantReason;

    private final String id;

    private final Optional<String> planId;

    private final Optional<String> planName;

    private final Optional<BillingPriceResponseData> price;

    private final int quantity;

    private final double quantityRemaining;

    private final double quantityUsed;

    private final String sourceLabel;

    private final OffsetDateTime updatedAt;

    private final Optional<OffsetDateTime> validFrom;

    private final Optional<OffsetDateTime> zeroedOutDate;

    private final Optional<String> zeroedOutReason;

    private final Map<String, Object> additionalProperties;

    private BillingCreditGrantResponseData(
            String companyId,
            String companyName,
            OffsetDateTime createdAt,
            Optional<String> creditIcon,
            String creditId,
            String creditName,
            Optional<OffsetDateTime> expiresAt,
            String grantReason,
            String id,
            Optional<String> planId,
            Optional<String> planName,
            Optional<BillingPriceResponseData> price,
            int quantity,
            double quantityRemaining,
            double quantityUsed,
            String sourceLabel,
            OffsetDateTime updatedAt,
            Optional<OffsetDateTime> validFrom,
            Optional<OffsetDateTime> zeroedOutDate,
            Optional<String> zeroedOutReason,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.companyName = companyName;
        this.createdAt = createdAt;
        this.creditIcon = creditIcon;
        this.creditId = creditId;
        this.creditName = creditName;
        this.expiresAt = expiresAt;
        this.grantReason = grantReason;
        this.id = id;
        this.planId = planId;
        this.planName = planName;
        this.price = price;
        this.quantity = quantity;
        this.quantityRemaining = quantityRemaining;
        this.quantityUsed = quantityUsed;
        this.sourceLabel = sourceLabel;
        this.updatedAt = updatedAt;
        this.validFrom = validFrom;
        this.zeroedOutDate = zeroedOutDate;
        this.zeroedOutReason = zeroedOutReason;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("company_name")
    public String getCompanyName() {
        return companyName;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("credit_icon")
    public Optional<String> getCreditIcon() {
        return creditIcon;
    }

    @JsonProperty("credit_id")
    public String getCreditId() {
        return creditId;
    }

    @JsonProperty("credit_name")
    public String getCreditName() {
        return creditName;
    }

    @JsonProperty("expires_at")
    public Optional<OffsetDateTime> getExpiresAt() {
        return expiresAt;
    }

    @JsonProperty("grant_reason")
    public String getGrantReason() {
        return grantReason;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("plan_id")
    public Optional<String> getPlanId() {
        return planId;
    }

    @JsonProperty("plan_name")
    public Optional<String> getPlanName() {
        return planName;
    }

    @JsonProperty("price")
    public Optional<BillingPriceResponseData> getPrice() {
        return price;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @JsonProperty("quantity_remaining")
    public double getQuantityRemaining() {
        return quantityRemaining;
    }

    @JsonProperty("quantity_used")
    public double getQuantityUsed() {
        return quantityUsed;
    }

    @JsonProperty("source_label")
    public String getSourceLabel() {
        return sourceLabel;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("valid_from")
    public Optional<OffsetDateTime> getValidFrom() {
        return validFrom;
    }

    @JsonProperty("zeroed_out_date")
    public Optional<OffsetDateTime> getZeroedOutDate() {
        return zeroedOutDate;
    }

    @JsonProperty("zeroed_out_reason")
    public Optional<String> getZeroedOutReason() {
        return zeroedOutReason;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingCreditGrantResponseData && equalTo((BillingCreditGrantResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditGrantResponseData other) {
        return companyId.equals(other.companyId)
                && companyName.equals(other.companyName)
                && createdAt.equals(other.createdAt)
                && creditIcon.equals(other.creditIcon)
                && creditId.equals(other.creditId)
                && creditName.equals(other.creditName)
                && expiresAt.equals(other.expiresAt)
                && grantReason.equals(other.grantReason)
                && id.equals(other.id)
                && planId.equals(other.planId)
                && planName.equals(other.planName)
                && price.equals(other.price)
                && quantity == other.quantity
                && quantityRemaining == other.quantityRemaining
                && quantityUsed == other.quantityUsed
                && sourceLabel.equals(other.sourceLabel)
                && updatedAt.equals(other.updatedAt)
                && validFrom.equals(other.validFrom)
                && zeroedOutDate.equals(other.zeroedOutDate)
                && zeroedOutReason.equals(other.zeroedOutReason);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.companyId,
                this.companyName,
                this.createdAt,
                this.creditIcon,
                this.creditId,
                this.creditName,
                this.expiresAt,
                this.grantReason,
                this.id,
                this.planId,
                this.planName,
                this.price,
                this.quantity,
                this.quantityRemaining,
                this.quantityUsed,
                this.sourceLabel,
                this.updatedAt,
                this.validFrom,
                this.zeroedOutDate,
                this.zeroedOutReason);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        CompanyNameStage companyId(@NotNull String companyId);

        Builder from(BillingCreditGrantResponseData other);
    }

    public interface CompanyNameStage {
        CreatedAtStage companyName(@NotNull String companyName);
    }

    public interface CreatedAtStage {
        CreditIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CreditIdStage {
        CreditNameStage creditId(@NotNull String creditId);
    }

    public interface CreditNameStage {
        GrantReasonStage creditName(@NotNull String creditName);
    }

    public interface GrantReasonStage {
        IdStage grantReason(@NotNull String grantReason);
    }

    public interface IdStage {
        QuantityStage id(@NotNull String id);
    }

    public interface QuantityStage {
        QuantityRemainingStage quantity(int quantity);
    }

    public interface QuantityRemainingStage {
        QuantityUsedStage quantityRemaining(double quantityRemaining);
    }

    public interface QuantityUsedStage {
        SourceLabelStage quantityUsed(double quantityUsed);
    }

    public interface SourceLabelStage {
        UpdatedAtStage sourceLabel(@NotNull String sourceLabel);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        BillingCreditGrantResponseData build();

        _FinalStage creditIcon(Optional<String> creditIcon);

        _FinalStage creditIcon(String creditIcon);

        _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt);

        _FinalStage expiresAt(OffsetDateTime expiresAt);

        _FinalStage planId(Optional<String> planId);

        _FinalStage planId(String planId);

        _FinalStage planName(Optional<String> planName);

        _FinalStage planName(String planName);

        _FinalStage price(Optional<BillingPriceResponseData> price);

        _FinalStage price(BillingPriceResponseData price);

        _FinalStage validFrom(Optional<OffsetDateTime> validFrom);

        _FinalStage validFrom(OffsetDateTime validFrom);

        _FinalStage zeroedOutDate(Optional<OffsetDateTime> zeroedOutDate);

        _FinalStage zeroedOutDate(OffsetDateTime zeroedOutDate);

        _FinalStage zeroedOutReason(Optional<String> zeroedOutReason);

        _FinalStage zeroedOutReason(String zeroedOutReason);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CompanyIdStage,
                    CompanyNameStage,
                    CreatedAtStage,
                    CreditIdStage,
                    CreditNameStage,
                    GrantReasonStage,
                    IdStage,
                    QuantityStage,
                    QuantityRemainingStage,
                    QuantityUsedStage,
                    SourceLabelStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String companyId;

        private String companyName;

        private OffsetDateTime createdAt;

        private String creditId;

        private String creditName;

        private String grantReason;

        private String id;

        private int quantity;

        private double quantityRemaining;

        private double quantityUsed;

        private String sourceLabel;

        private OffsetDateTime updatedAt;

        private Optional<String> zeroedOutReason = Optional.empty();

        private Optional<OffsetDateTime> zeroedOutDate = Optional.empty();

        private Optional<OffsetDateTime> validFrom = Optional.empty();

        private Optional<BillingPriceResponseData> price = Optional.empty();

        private Optional<String> planName = Optional.empty();

        private Optional<String> planId = Optional.empty();

        private Optional<OffsetDateTime> expiresAt = Optional.empty();

        private Optional<String> creditIcon = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingCreditGrantResponseData other) {
            companyId(other.getCompanyId());
            companyName(other.getCompanyName());
            createdAt(other.getCreatedAt());
            creditIcon(other.getCreditIcon());
            creditId(other.getCreditId());
            creditName(other.getCreditName());
            expiresAt(other.getExpiresAt());
            grantReason(other.getGrantReason());
            id(other.getId());
            planId(other.getPlanId());
            planName(other.getPlanName());
            price(other.getPrice());
            quantity(other.getQuantity());
            quantityRemaining(other.getQuantityRemaining());
            quantityUsed(other.getQuantityUsed());
            sourceLabel(other.getSourceLabel());
            updatedAt(other.getUpdatedAt());
            validFrom(other.getValidFrom());
            zeroedOutDate(other.getZeroedOutDate());
            zeroedOutReason(other.getZeroedOutReason());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public CompanyNameStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_name")
        public CreatedAtStage companyName(@NotNull String companyName) {
            this.companyName = Objects.requireNonNull(companyName, "companyName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CreditIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_id")
        public CreditNameStage creditId(@NotNull String creditId) {
            this.creditId = Objects.requireNonNull(creditId, "creditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("credit_name")
        public GrantReasonStage creditName(@NotNull String creditName) {
            this.creditName = Objects.requireNonNull(creditName, "creditName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("grant_reason")
        public IdStage grantReason(@NotNull String grantReason) {
            this.grantReason = Objects.requireNonNull(grantReason, "grantReason must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public QuantityStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public QuantityRemainingStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity_remaining")
        public QuantityUsedStage quantityRemaining(double quantityRemaining) {
            this.quantityRemaining = quantityRemaining;
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity_used")
        public SourceLabelStage quantityUsed(double quantityUsed) {
            this.quantityUsed = quantityUsed;
            return this;
        }

        @java.lang.Override
        @JsonSetter("source_label")
        public UpdatedAtStage sourceLabel(@NotNull String sourceLabel) {
            this.sourceLabel = Objects.requireNonNull(sourceLabel, "sourceLabel must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage zeroedOutReason(String zeroedOutReason) {
            this.zeroedOutReason = Optional.ofNullable(zeroedOutReason);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "zeroed_out_reason", nulls = Nulls.SKIP)
        public _FinalStage zeroedOutReason(Optional<String> zeroedOutReason) {
            this.zeroedOutReason = zeroedOutReason;
            return this;
        }

        @java.lang.Override
        public _FinalStage zeroedOutDate(OffsetDateTime zeroedOutDate) {
            this.zeroedOutDate = Optional.ofNullable(zeroedOutDate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "zeroed_out_date", nulls = Nulls.SKIP)
        public _FinalStage zeroedOutDate(Optional<OffsetDateTime> zeroedOutDate) {
            this.zeroedOutDate = zeroedOutDate;
            return this;
        }

        @java.lang.Override
        public _FinalStage validFrom(OffsetDateTime validFrom) {
            this.validFrom = Optional.ofNullable(validFrom);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "valid_from", nulls = Nulls.SKIP)
        public _FinalStage validFrom(Optional<OffsetDateTime> validFrom) {
            this.validFrom = validFrom;
            return this;
        }

        @java.lang.Override
        public _FinalStage price(BillingPriceResponseData price) {
            this.price = Optional.ofNullable(price);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price", nulls = Nulls.SKIP)
        public _FinalStage price(Optional<BillingPriceResponseData> price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        public _FinalStage planName(String planName) {
            this.planName = Optional.ofNullable(planName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_name", nulls = Nulls.SKIP)
        public _FinalStage planName(Optional<String> planName) {
            this.planName = planName;
            return this;
        }

        @java.lang.Override
        public _FinalStage planId(String planId) {
            this.planId = Optional.ofNullable(planId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_id", nulls = Nulls.SKIP)
        public _FinalStage planId(Optional<String> planId) {
            this.planId = planId;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiresAt(OffsetDateTime expiresAt) {
            this.expiresAt = Optional.ofNullable(expiresAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expires_at", nulls = Nulls.SKIP)
        public _FinalStage expiresAt(Optional<OffsetDateTime> expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditIcon(String creditIcon) {
            this.creditIcon = Optional.ofNullable(creditIcon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_icon", nulls = Nulls.SKIP)
        public _FinalStage creditIcon(Optional<String> creditIcon) {
            this.creditIcon = creditIcon;
            return this;
        }

        @java.lang.Override
        public BillingCreditGrantResponseData build() {
            return new BillingCreditGrantResponseData(
                    companyId,
                    companyName,
                    createdAt,
                    creditIcon,
                    creditId,
                    creditName,
                    expiresAt,
                    grantReason,
                    id,
                    planId,
                    planName,
                    price,
                    quantity,
                    quantityRemaining,
                    quantityUsed,
                    sourceLabel,
                    updatedAt,
                    validFrom,
                    zeroedOutDate,
                    zeroedOutReason,
                    additionalProperties);
        }
    }
}
