/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingCreditLedgerResponseData.Builder.class)
public final class BillingCreditLedgerResponseData {
    private final Optional<String> description;

    private final Optional<String> icon;

    private final String id;

    private final String name;

    private final Optional<String> pluralName;

    private final Optional<String> singularName;

    private final Map<String, Object> additionalProperties;

    private BillingCreditLedgerResponseData(
            Optional<String> description,
            Optional<String> icon,
            String id,
            String name,
            Optional<String> pluralName,
            Optional<String> singularName,
            Map<String, Object> additionalProperties) {
        this.description = description;
        this.icon = icon;
        this.id = id;
        this.name = name;
        this.pluralName = pluralName;
        this.singularName = singularName;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("icon")
    public Optional<String> getIcon() {
        return icon;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plural_name")
    public Optional<String> getPluralName() {
        return pluralName;
    }

    @JsonProperty("singular_name")
    public Optional<String> getSingularName() {
        return singularName;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingCreditLedgerResponseData && equalTo((BillingCreditLedgerResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingCreditLedgerResponseData other) {
        return description.equals(other.description)
                && icon.equals(other.icon)
                && id.equals(other.id)
                && name.equals(other.name)
                && pluralName.equals(other.pluralName)
                && singularName.equals(other.singularName);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.description, this.icon, this.id, this.name, this.pluralName, this.singularName);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        NameStage id(@NotNull String id);

        Builder from(BillingCreditLedgerResponseData other);
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        BillingCreditLedgerResponseData build();

        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        _FinalStage icon(Optional<String> icon);

        _FinalStage icon(String icon);

        _FinalStage pluralName(Optional<String> pluralName);

        _FinalStage pluralName(String pluralName);

        _FinalStage singularName(Optional<String> singularName);

        _FinalStage singularName(String singularName);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, NameStage, _FinalStage {
        private String id;

        private String name;

        private Optional<String> singularName = Optional.empty();

        private Optional<String> pluralName = Optional.empty();

        private Optional<String> icon = Optional.empty();

        private Optional<String> description = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingCreditLedgerResponseData other) {
            description(other.getDescription());
            icon(other.getIcon());
            id(other.getId());
            name(other.getName());
            pluralName(other.getPluralName());
            singularName(other.getSingularName());
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage singularName(String singularName) {
            this.singularName = Optional.ofNullable(singularName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "singular_name", nulls = Nulls.SKIP)
        public _FinalStage singularName(Optional<String> singularName) {
            this.singularName = singularName;
            return this;
        }

        @java.lang.Override
        public _FinalStage pluralName(String pluralName) {
            this.pluralName = Optional.ofNullable(pluralName);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plural_name", nulls = Nulls.SKIP)
        public _FinalStage pluralName(Optional<String> pluralName) {
            this.pluralName = pluralName;
            return this;
        }

        @java.lang.Override
        public _FinalStage icon(String icon) {
            this.icon = Optional.ofNullable(icon);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "icon", nulls = Nulls.SKIP)
        public _FinalStage icon(Optional<String> icon) {
            this.icon = icon;
            return this;
        }

        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public BillingCreditLedgerResponseData build() {
            return new BillingCreditLedgerResponseData(
                    description, icon, id, name, pluralName, singularName, additionalProperties);
        }
    }
}
