/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingPriceResponseData.Builder.class)
public final class BillingPriceResponseData {
    private final String currency;

    private final String externalPriceId;

    private final String id;

    private final String interval;

    private final int price;

    private final Optional<String> priceDecimal;

    private final String scheme;

    private final Map<String, Object> additionalProperties;

    private BillingPriceResponseData(
            String currency,
            String externalPriceId,
            String id,
            String interval,
            int price,
            Optional<String> priceDecimal,
            String scheme,
            Map<String, Object> additionalProperties) {
        this.currency = currency;
        this.externalPriceId = externalPriceId;
        this.id = id;
        this.interval = interval;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.scheme = scheme;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("currency")
    public String getCurrency() {
        return currency;
    }

    @JsonProperty("external_price_id")
    public String getExternalPriceId() {
        return externalPriceId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("interval")
    public String getInterval() {
        return interval;
    }

    @JsonProperty("price")
    public int getPrice() {
        return price;
    }

    @JsonProperty("price_decimal")
    public Optional<String> getPriceDecimal() {
        return priceDecimal;
    }

    @JsonProperty("scheme")
    public String getScheme() {
        return scheme;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingPriceResponseData && equalTo((BillingPriceResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingPriceResponseData other) {
        return currency.equals(other.currency)
                && externalPriceId.equals(other.externalPriceId)
                && id.equals(other.id)
                && interval.equals(other.interval)
                && price == other.price
                && priceDecimal.equals(other.priceDecimal)
                && scheme.equals(other.scheme);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.currency,
                this.externalPriceId,
                this.id,
                this.interval,
                this.price,
                this.priceDecimal,
                this.scheme);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CurrencyStage builder() {
        return new Builder();
    }

    public interface CurrencyStage {
        ExternalPriceIdStage currency(@NotNull String currency);

        Builder from(BillingPriceResponseData other);
    }

    public interface ExternalPriceIdStage {
        IdStage externalPriceId(@NotNull String externalPriceId);
    }

    public interface IdStage {
        IntervalStage id(@NotNull String id);
    }

    public interface IntervalStage {
        PriceStage interval(@NotNull String interval);
    }

    public interface PriceStage {
        SchemeStage price(int price);
    }

    public interface SchemeStage {
        _FinalStage scheme(@NotNull String scheme);
    }

    public interface _FinalStage {
        BillingPriceResponseData build();

        _FinalStage priceDecimal(Optional<String> priceDecimal);

        _FinalStage priceDecimal(String priceDecimal);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CurrencyStage,
                    ExternalPriceIdStage,
                    IdStage,
                    IntervalStage,
                    PriceStage,
                    SchemeStage,
                    _FinalStage {
        private String currency;

        private String externalPriceId;

        private String id;

        private String interval;

        private int price;

        private String scheme;

        private Optional<String> priceDecimal = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingPriceResponseData other) {
            currency(other.getCurrency());
            externalPriceId(other.getExternalPriceId());
            id(other.getId());
            interval(other.getInterval());
            price(other.getPrice());
            priceDecimal(other.getPriceDecimal());
            scheme(other.getScheme());
            return this;
        }

        @java.lang.Override
        @JsonSetter("currency")
        public ExternalPriceIdStage currency(@NotNull String currency) {
            this.currency = Objects.requireNonNull(currency, "currency must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_price_id")
        public IdStage externalPriceId(@NotNull String externalPriceId) {
            this.externalPriceId = Objects.requireNonNull(externalPriceId, "externalPriceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IntervalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("interval")
        public PriceStage interval(@NotNull String interval) {
            this.interval = Objects.requireNonNull(interval, "interval must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public SchemeStage price(int price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        @JsonSetter("scheme")
        public _FinalStage scheme(@NotNull String scheme) {
            this.scheme = Objects.requireNonNull(scheme, "scheme must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_decimal", nulls = Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        @java.lang.Override
        public BillingPriceResponseData build() {
            return new BillingPriceResponseData(
                    currency, externalPriceId, id, interval, price, priceDecimal, scheme, additionalProperties);
        }
    }
}
