/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingProductDetailResponseData.Builder.class)
public final class BillingProductDetailResponseData {
    private final String accountId;

    private final OffsetDateTime createdAt;

    private final Optional<String> currency;

    private final String environmentId;

    private final String externalId;

    private final boolean isActive;

    private final String name;

    private final double price;

    private final Optional<String> priceDecimal;

    private final List<BillingPriceResponseData> prices;

    private final String productId;

    private final double quantity;

    private final int subscriptionCount;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private BillingProductDetailResponseData(
            String accountId,
            OffsetDateTime createdAt,
            Optional<String> currency,
            String environmentId,
            String externalId,
            boolean isActive,
            String name,
            double price,
            Optional<String> priceDecimal,
            List<BillingPriceResponseData> prices,
            String productId,
            double quantity,
            int subscriptionCount,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.currency = currency;
        this.environmentId = environmentId;
        this.externalId = externalId;
        this.isActive = isActive;
        this.name = name;
        this.price = price;
        this.priceDecimal = priceDecimal;
        this.prices = prices;
        this.productId = productId;
        this.quantity = quantity;
        this.subscriptionCount = subscriptionCount;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    /**
     * @return Deprecated; currencies are associated with prices, not products
     */
    @JsonProperty("currency")
    public Optional<String> getCurrency() {
        return currency;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("external_id")
    public String getExternalId() {
        return externalId;
    }

    @JsonProperty("is_active")
    public boolean getIsActive() {
        return isActive;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("price")
    public double getPrice() {
        return price;
    }

    @JsonProperty("price_decimal")
    public Optional<String> getPriceDecimal() {
        return priceDecimal;
    }

    @JsonProperty("prices")
    public List<BillingPriceResponseData> getPrices() {
        return prices;
    }

    @JsonProperty("product_id")
    public String getProductId() {
        return productId;
    }

    @JsonProperty("quantity")
    public double getQuantity() {
        return quantity;
    }

    @JsonProperty("subscription_count")
    public int getSubscriptionCount() {
        return subscriptionCount;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingProductDetailResponseData && equalTo((BillingProductDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductDetailResponseData other) {
        return accountId.equals(other.accountId)
                && createdAt.equals(other.createdAt)
                && currency.equals(other.currency)
                && environmentId.equals(other.environmentId)
                && externalId.equals(other.externalId)
                && isActive == other.isActive
                && name.equals(other.name)
                && price == other.price
                && priceDecimal.equals(other.priceDecimal)
                && prices.equals(other.prices)
                && productId.equals(other.productId)
                && quantity == other.quantity
                && subscriptionCount == other.subscriptionCount
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.createdAt,
                this.currency,
                this.environmentId,
                this.externalId,
                this.isActive,
                this.name,
                this.price,
                this.priceDecimal,
                this.prices,
                this.productId,
                this.quantity,
                this.subscriptionCount,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        CreatedAtStage accountId(@NotNull String accountId);

        Builder from(BillingProductDetailResponseData other);
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface EnvironmentIdStage {
        ExternalIdStage environmentId(@NotNull String environmentId);
    }

    public interface ExternalIdStage {
        IsActiveStage externalId(@NotNull String externalId);
    }

    public interface IsActiveStage {
        NameStage isActive(boolean isActive);
    }

    public interface NameStage {
        PriceStage name(@NotNull String name);
    }

    public interface PriceStage {
        ProductIdStage price(double price);
    }

    public interface ProductIdStage {
        QuantityStage productId(@NotNull String productId);
    }

    public interface QuantityStage {
        SubscriptionCountStage quantity(double quantity);
    }

    public interface SubscriptionCountStage {
        UpdatedAtStage subscriptionCount(int subscriptionCount);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        BillingProductDetailResponseData build();

        /**
         * <p>Deprecated; currencies are associated with prices, not products</p>
         */
        _FinalStage currency(Optional<String> currency);

        _FinalStage currency(String currency);

        _FinalStage priceDecimal(Optional<String> priceDecimal);

        _FinalStage priceDecimal(String priceDecimal);

        _FinalStage prices(List<BillingPriceResponseData> prices);

        _FinalStage addPrices(BillingPriceResponseData prices);

        _FinalStage addAllPrices(List<BillingPriceResponseData> prices);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    CreatedAtStage,
                    EnvironmentIdStage,
                    ExternalIdStage,
                    IsActiveStage,
                    NameStage,
                    PriceStage,
                    ProductIdStage,
                    QuantityStage,
                    SubscriptionCountStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String accountId;

        private OffsetDateTime createdAt;

        private String environmentId;

        private String externalId;

        private boolean isActive;

        private String name;

        private double price;

        private String productId;

        private double quantity;

        private int subscriptionCount;

        private OffsetDateTime updatedAt;

        private List<BillingPriceResponseData> prices = new ArrayList<>();

        private Optional<String> priceDecimal = Optional.empty();

        private Optional<String> currency = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(BillingProductDetailResponseData other) {
            accountId(other.getAccountId());
            createdAt(other.getCreatedAt());
            currency(other.getCurrency());
            environmentId(other.getEnvironmentId());
            externalId(other.getExternalId());
            isActive(other.getIsActive());
            name(other.getName());
            price(other.getPrice());
            priceDecimal(other.getPriceDecimal());
            prices(other.getPrices());
            productId(other.getProductId());
            quantity(other.getQuantity());
            subscriptionCount(other.getSubscriptionCount());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public ExternalIdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_id")
        public IsActiveStage externalId(@NotNull String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_active")
        public NameStage isActive(boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriceStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price")
        public ProductIdStage price(double price) {
            this.price = price;
            return this;
        }

        @java.lang.Override
        @JsonSetter("product_id")
        public QuantityStage productId(@NotNull String productId) {
            this.productId = Objects.requireNonNull(productId, "productId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public SubscriptionCountStage quantity(double quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        @JsonSetter("subscription_count")
        public UpdatedAtStage subscriptionCount(int subscriptionCount) {
            this.subscriptionCount = subscriptionCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllPrices(List<BillingPriceResponseData> prices) {
            if (prices != null) {
                this.prices.addAll(prices);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addPrices(BillingPriceResponseData prices) {
            this.prices.add(prices);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "prices", nulls = Nulls.SKIP)
        public _FinalStage prices(List<BillingPriceResponseData> prices) {
            this.prices.clear();
            if (prices != null) {
                this.prices.addAll(prices);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage priceDecimal(String priceDecimal) {
            this.priceDecimal = Optional.ofNullable(priceDecimal);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_decimal", nulls = Nulls.SKIP)
        public _FinalStage priceDecimal(Optional<String> priceDecimal) {
            this.priceDecimal = priceDecimal;
            return this;
        }

        /**
         * <p>Deprecated; currencies are associated with prices, not products</p>
         * @return Reference to {@code this} so that method calls can be chained together.
         */
        @java.lang.Override
        public _FinalStage currency(String currency) {
            this.currency = Optional.ofNullable(currency);
            return this;
        }

        /**
         * <p>Deprecated; currencies are associated with prices, not products</p>
         */
        @java.lang.Override
        @JsonSetter(value = "currency", nulls = Nulls.SKIP)
        public _FinalStage currency(Optional<String> currency) {
            this.currency = currency;
            return this;
        }

        @java.lang.Override
        public BillingProductDetailResponseData build() {
            return new BillingProductDetailResponseData(
                    accountId,
                    createdAt,
                    currency,
                    environmentId,
                    externalId,
                    isActive,
                    name,
                    price,
                    priceDecimal,
                    prices,
                    productId,
                    quantity,
                    subscriptionCount,
                    updatedAt,
                    additionalProperties);
        }
    }
}
