/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = BillingProductPriceTierResponseData.Builder.class)
public final class BillingProductPriceTierResponseData {
    private final Optional<Integer> flatAmount;

    private final Optional<Integer> perUnitPrice;

    private final Optional<String> perUnitPriceDecimal;

    private final Optional<Integer> upTo;

    private final Map<String, Object> additionalProperties;

    private BillingProductPriceTierResponseData(
            Optional<Integer> flatAmount,
            Optional<Integer> perUnitPrice,
            Optional<String> perUnitPriceDecimal,
            Optional<Integer> upTo,
            Map<String, Object> additionalProperties) {
        this.flatAmount = flatAmount;
        this.perUnitPrice = perUnitPrice;
        this.perUnitPriceDecimal = perUnitPriceDecimal;
        this.upTo = upTo;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("flat_amount")
    public Optional<Integer> getFlatAmount() {
        return flatAmount;
    }

    @JsonProperty("per_unit_price")
    public Optional<Integer> getPerUnitPrice() {
        return perUnitPrice;
    }

    @JsonProperty("per_unit_price_decimal")
    public Optional<String> getPerUnitPriceDecimal() {
        return perUnitPriceDecimal;
    }

    @JsonProperty("up_to")
    public Optional<Integer> getUpTo() {
        return upTo;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof BillingProductPriceTierResponseData
                && equalTo((BillingProductPriceTierResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(BillingProductPriceTierResponseData other) {
        return flatAmount.equals(other.flatAmount)
                && perUnitPrice.equals(other.perUnitPrice)
                && perUnitPriceDecimal.equals(other.perUnitPriceDecimal)
                && upTo.equals(other.upTo);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.flatAmount, this.perUnitPrice, this.perUnitPriceDecimal, this.upTo);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Optional<Integer> flatAmount = Optional.empty();

        private Optional<Integer> perUnitPrice = Optional.empty();

        private Optional<String> perUnitPriceDecimal = Optional.empty();

        private Optional<Integer> upTo = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        public Builder from(BillingProductPriceTierResponseData other) {
            flatAmount(other.getFlatAmount());
            perUnitPrice(other.getPerUnitPrice());
            perUnitPriceDecimal(other.getPerUnitPriceDecimal());
            upTo(other.getUpTo());
            return this;
        }

        @JsonSetter(value = "flat_amount", nulls = Nulls.SKIP)
        public Builder flatAmount(Optional<Integer> flatAmount) {
            this.flatAmount = flatAmount;
            return this;
        }

        public Builder flatAmount(Integer flatAmount) {
            this.flatAmount = Optional.ofNullable(flatAmount);
            return this;
        }

        @JsonSetter(value = "per_unit_price", nulls = Nulls.SKIP)
        public Builder perUnitPrice(Optional<Integer> perUnitPrice) {
            this.perUnitPrice = perUnitPrice;
            return this;
        }

        public Builder perUnitPrice(Integer perUnitPrice) {
            this.perUnitPrice = Optional.ofNullable(perUnitPrice);
            return this;
        }

        @JsonSetter(value = "per_unit_price_decimal", nulls = Nulls.SKIP)
        public Builder perUnitPriceDecimal(Optional<String> perUnitPriceDecimal) {
            this.perUnitPriceDecimal = perUnitPriceDecimal;
            return this;
        }

        public Builder perUnitPriceDecimal(String perUnitPriceDecimal) {
            this.perUnitPriceDecimal = Optional.ofNullable(perUnitPriceDecimal);
            return this;
        }

        @JsonSetter(value = "up_to", nulls = Nulls.SKIP)
        public Builder upTo(Optional<Integer> upTo) {
            this.upTo = upTo;
            return this;
        }

        public Builder upTo(Integer upTo) {
            this.upTo = Optional.ofNullable(upTo);
            return this;
        }

        public BillingProductPriceTierResponseData build() {
            return new BillingProductPriceTierResponseData(
                    flatAmount, perUnitPrice, perUnitPriceDecimal, upTo, additionalProperties);
        }
    }
}
