/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyMembershipResponseData.Builder.class)
public final class CompanyMembershipResponseData {
    private final String companyId;

    private final OffsetDateTime createdAt;

    private final String id;

    private final OffsetDateTime updatedAt;

    private final String userId;

    private final Map<String, Object> additionalProperties;

    private CompanyMembershipResponseData(
            String companyId,
            OffsetDateTime createdAt,
            String id,
            OffsetDateTime updatedAt,
            String userId,
            Map<String, Object> additionalProperties) {
        this.companyId = companyId;
        this.createdAt = createdAt;
        this.id = id;
        this.updatedAt = updatedAt;
        this.userId = userId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("user_id")
    public String getUserId() {
        return userId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyMembershipResponseData && equalTo((CompanyMembershipResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyMembershipResponseData other) {
        return companyId.equals(other.companyId)
                && createdAt.equals(other.createdAt)
                && id.equals(other.id)
                && updatedAt.equals(other.updatedAt)
                && userId.equals(other.userId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.companyId, this.createdAt, this.id, this.updatedAt, this.userId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CompanyIdStage builder() {
        return new Builder();
    }

    public interface CompanyIdStage {
        CreatedAtStage companyId(@NotNull String companyId);

        Builder from(CompanyMembershipResponseData other);
    }

    public interface CreatedAtStage {
        IdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface IdStage {
        UpdatedAtStage id(@NotNull String id);
    }

    public interface UpdatedAtStage {
        UserIdStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface UserIdStage {
        _FinalStage userId(@NotNull String userId);
    }

    public interface _FinalStage {
        CompanyMembershipResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CompanyIdStage, CreatedAtStage, IdStage, UpdatedAtStage, UserIdStage, _FinalStage {
        private String companyId;

        private OffsetDateTime createdAt;

        private String id;

        private OffsetDateTime updatedAt;

        private String userId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CompanyMembershipResponseData other) {
            companyId(other.getCompanyId());
            createdAt(other.getCreatedAt());
            id(other.getId());
            updatedAt(other.getUpdatedAt());
            userId(other.getUserId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public CreatedAtStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public IdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public UpdatedAtStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public UserIdStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("user_id")
        public _FinalStage userId(@NotNull String userId) {
            this.userId = Objects.requireNonNull(userId, "userId must not be null");
            return this;
        }

        @java.lang.Override
        public CompanyMembershipResponseData build() {
            return new CompanyMembershipResponseData(companyId, createdAt, id, updatedAt, userId, additionalProperties);
        }
    }
}
