/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyOverrideNoteResponseData.Builder.class)
public final class CompanyOverrideNoteResponseData {
    private final OffsetDateTime createdAt;

    private final String externalUserId;

    private final String externalUserName;

    private final String id;

    private final String note;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private CompanyOverrideNoteResponseData(
            OffsetDateTime createdAt,
            String externalUserId,
            String externalUserName,
            String id,
            String note,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.externalUserId = externalUserId;
        this.externalUserName = externalUserName;
        this.id = id;
        this.note = note;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("external_user_id")
    public String getExternalUserId() {
        return externalUserId;
    }

    @JsonProperty("external_user_name")
    public String getExternalUserName() {
        return externalUserName;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("note")
    public String getNote() {
        return note;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyOverrideNoteResponseData && equalTo((CompanyOverrideNoteResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyOverrideNoteResponseData other) {
        return createdAt.equals(other.createdAt)
                && externalUserId.equals(other.externalUserId)
                && externalUserName.equals(other.externalUserName)
                && id.equals(other.id)
                && note.equals(other.note)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.createdAt, this.externalUserId, this.externalUserName, this.id, this.note, this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        ExternalUserIdStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(CompanyOverrideNoteResponseData other);
    }

    public interface ExternalUserIdStage {
        ExternalUserNameStage externalUserId(@NotNull String externalUserId);
    }

    public interface ExternalUserNameStage {
        IdStage externalUserName(@NotNull String externalUserName);
    }

    public interface IdStage {
        NoteStage id(@NotNull String id);
    }

    public interface NoteStage {
        UpdatedAtStage note(@NotNull String note);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        CompanyOverrideNoteResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage,
                    ExternalUserIdStage,
                    ExternalUserNameStage,
                    IdStage,
                    NoteStage,
                    UpdatedAtStage,
                    _FinalStage {
        private OffsetDateTime createdAt;

        private String externalUserId;

        private String externalUserName;

        private String id;

        private String note;

        private OffsetDateTime updatedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CompanyOverrideNoteResponseData other) {
            createdAt(other.getCreatedAt());
            externalUserId(other.getExternalUserId());
            externalUserName(other.getExternalUserName());
            id(other.getId());
            note(other.getNote());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public ExternalUserIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_user_id")
        public ExternalUserNameStage externalUserId(@NotNull String externalUserId) {
            this.externalUserId = Objects.requireNonNull(externalUserId, "externalUserId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("external_user_name")
        public IdStage externalUserName(@NotNull String externalUserName) {
            this.externalUserName = Objects.requireNonNull(externalUserName, "externalUserName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NoteStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("note")
        public UpdatedAtStage note(@NotNull String note) {
            this.note = Objects.requireNonNull(note, "note must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public CompanyOverrideNoteResponseData build() {
            return new CompanyOverrideNoteResponseData(
                    createdAt, externalUserId, externalUserName, id, note, updatedAt, additionalProperties);
        }
    }
}
