/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyPlanDetailResponseData.Builder.class)
public final class CompanyPlanDetailResponseData {
    private final Optional<String> audienceType;

    private final Optional<BillingProductDetailResponseData> billingProduct;

    private final String chargeType;

    private final boolean companyCanTrial;

    private final int companyCount;

    private final List<String> compatiblePlanIds;

    private final String controlledBy;

    private final OffsetDateTime createdAt;

    private final boolean current;

    private final boolean custom;

    private final Optional<CustomPlanConfig> customPlanConfig;

    private final String description;

    private final List<PlanEntitlementResponseData> entitlements;

    private final List<FeatureDetailResponseData> features;

    private final String icon;

    private final String id;

    private final List<PlanCreditGrantView> includedCreditGrants;

    private final boolean isCustom;

    private final boolean isDefault;

    private final boolean isFree;

    private final boolean isTrialable;

    private final Optional<BillingPriceResponseData> monthlyPrice;

    private final String name;

    private final Optional<BillingPriceResponseData> oneTimePrice;

    private final String planType;

    private final Optional<Integer> trialDays;

    private final OffsetDateTime updatedAt;

    private final List<FeatureUsageResponseData> usageViolations;

    private final boolean valid;

    private final Optional<BillingPriceResponseData> yearlyPrice;

    private final Map<String, Object> additionalProperties;

    private CompanyPlanDetailResponseData(
            Optional<String> audienceType,
            Optional<BillingProductDetailResponseData> billingProduct,
            String chargeType,
            boolean companyCanTrial,
            int companyCount,
            List<String> compatiblePlanIds,
            String controlledBy,
            OffsetDateTime createdAt,
            boolean current,
            boolean custom,
            Optional<CustomPlanConfig> customPlanConfig,
            String description,
            List<PlanEntitlementResponseData> entitlements,
            List<FeatureDetailResponseData> features,
            String icon,
            String id,
            List<PlanCreditGrantView> includedCreditGrants,
            boolean isCustom,
            boolean isDefault,
            boolean isFree,
            boolean isTrialable,
            Optional<BillingPriceResponseData> monthlyPrice,
            String name,
            Optional<BillingPriceResponseData> oneTimePrice,
            String planType,
            Optional<Integer> trialDays,
            OffsetDateTime updatedAt,
            List<FeatureUsageResponseData> usageViolations,
            boolean valid,
            Optional<BillingPriceResponseData> yearlyPrice,
            Map<String, Object> additionalProperties) {
        this.audienceType = audienceType;
        this.billingProduct = billingProduct;
        this.chargeType = chargeType;
        this.companyCanTrial = companyCanTrial;
        this.companyCount = companyCount;
        this.compatiblePlanIds = compatiblePlanIds;
        this.controlledBy = controlledBy;
        this.createdAt = createdAt;
        this.current = current;
        this.custom = custom;
        this.customPlanConfig = customPlanConfig;
        this.description = description;
        this.entitlements = entitlements;
        this.features = features;
        this.icon = icon;
        this.id = id;
        this.includedCreditGrants = includedCreditGrants;
        this.isCustom = isCustom;
        this.isDefault = isDefault;
        this.isFree = isFree;
        this.isTrialable = isTrialable;
        this.monthlyPrice = monthlyPrice;
        this.name = name;
        this.oneTimePrice = oneTimePrice;
        this.planType = planType;
        this.trialDays = trialDays;
        this.updatedAt = updatedAt;
        this.usageViolations = usageViolations;
        this.valid = valid;
        this.yearlyPrice = yearlyPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("audience_type")
    public Optional<String> getAudienceType() {
        return audienceType;
    }

    @JsonProperty("billing_product")
    public Optional<BillingProductDetailResponseData> getBillingProduct() {
        return billingProduct;
    }

    @JsonProperty("charge_type")
    public String getChargeType() {
        return chargeType;
    }

    @JsonProperty("company_can_trial")
    public boolean getCompanyCanTrial() {
        return companyCanTrial;
    }

    @JsonProperty("company_count")
    public int getCompanyCount() {
        return companyCount;
    }

    @JsonProperty("compatible_plan_ids")
    public List<String> getCompatiblePlanIds() {
        return compatiblePlanIds;
    }

    @JsonProperty("controlled_by")
    public String getControlledBy() {
        return controlledBy;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("current")
    public boolean getCurrent() {
        return current;
    }

    @JsonProperty("custom")
    public boolean getCustom() {
        return custom;
    }

    @JsonProperty("custom_plan_config")
    public Optional<CustomPlanConfig> getCustomPlanConfig() {
        return customPlanConfig;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("entitlements")
    public List<PlanEntitlementResponseData> getEntitlements() {
        return entitlements;
    }

    @JsonProperty("features")
    public List<FeatureDetailResponseData> getFeatures() {
        return features;
    }

    @JsonProperty("icon")
    public String getIcon() {
        return icon;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("included_credit_grants")
    public List<PlanCreditGrantView> getIncludedCreditGrants() {
        return includedCreditGrants;
    }

    @JsonProperty("is_custom")
    public boolean getIsCustom() {
        return isCustom;
    }

    @JsonProperty("is_default")
    public boolean getIsDefault() {
        return isDefault;
    }

    @JsonProperty("is_free")
    public boolean getIsFree() {
        return isFree;
    }

    @JsonProperty("is_trialable")
    public boolean getIsTrialable() {
        return isTrialable;
    }

    @JsonProperty("monthly_price")
    public Optional<BillingPriceResponseData> getMonthlyPrice() {
        return monthlyPrice;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("one_time_price")
    public Optional<BillingPriceResponseData> getOneTimePrice() {
        return oneTimePrice;
    }

    @JsonProperty("plan_type")
    public String getPlanType() {
        return planType;
    }

    @JsonProperty("trial_days")
    public Optional<Integer> getTrialDays() {
        return trialDays;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @JsonProperty("usage_violations")
    public List<FeatureUsageResponseData> getUsageViolations() {
        return usageViolations;
    }

    @JsonProperty("valid")
    public boolean getValid() {
        return valid;
    }

    @JsonProperty("yearly_price")
    public Optional<BillingPriceResponseData> getYearlyPrice() {
        return yearlyPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyPlanDetailResponseData && equalTo((CompanyPlanDetailResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyPlanDetailResponseData other) {
        return audienceType.equals(other.audienceType)
                && billingProduct.equals(other.billingProduct)
                && chargeType.equals(other.chargeType)
                && companyCanTrial == other.companyCanTrial
                && companyCount == other.companyCount
                && compatiblePlanIds.equals(other.compatiblePlanIds)
                && controlledBy.equals(other.controlledBy)
                && createdAt.equals(other.createdAt)
                && current == other.current
                && custom == other.custom
                && customPlanConfig.equals(other.customPlanConfig)
                && description.equals(other.description)
                && entitlements.equals(other.entitlements)
                && features.equals(other.features)
                && icon.equals(other.icon)
                && id.equals(other.id)
                && includedCreditGrants.equals(other.includedCreditGrants)
                && isCustom == other.isCustom
                && isDefault == other.isDefault
                && isFree == other.isFree
                && isTrialable == other.isTrialable
                && monthlyPrice.equals(other.monthlyPrice)
                && name.equals(other.name)
                && oneTimePrice.equals(other.oneTimePrice)
                && planType.equals(other.planType)
                && trialDays.equals(other.trialDays)
                && updatedAt.equals(other.updatedAt)
                && usageViolations.equals(other.usageViolations)
                && valid == other.valid
                && yearlyPrice.equals(other.yearlyPrice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.audienceType,
                this.billingProduct,
                this.chargeType,
                this.companyCanTrial,
                this.companyCount,
                this.compatiblePlanIds,
                this.controlledBy,
                this.createdAt,
                this.current,
                this.custom,
                this.customPlanConfig,
                this.description,
                this.entitlements,
                this.features,
                this.icon,
                this.id,
                this.includedCreditGrants,
                this.isCustom,
                this.isDefault,
                this.isFree,
                this.isTrialable,
                this.monthlyPrice,
                this.name,
                this.oneTimePrice,
                this.planType,
                this.trialDays,
                this.updatedAt,
                this.usageViolations,
                this.valid,
                this.yearlyPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ChargeTypeStage builder() {
        return new Builder();
    }

    public interface ChargeTypeStage {
        CompanyCanTrialStage chargeType(@NotNull String chargeType);

        Builder from(CompanyPlanDetailResponseData other);
    }

    public interface CompanyCanTrialStage {
        CompanyCountStage companyCanTrial(boolean companyCanTrial);
    }

    public interface CompanyCountStage {
        ControlledByStage companyCount(int companyCount);
    }

    public interface ControlledByStage {
        CreatedAtStage controlledBy(@NotNull String controlledBy);
    }

    public interface CreatedAtStage {
        CurrentStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface CurrentStage {
        CustomStage current(boolean current);
    }

    public interface CustomStage {
        DescriptionStage custom(boolean custom);
    }

    public interface DescriptionStage {
        IconStage description(@NotNull String description);
    }

    public interface IconStage {
        IdStage icon(@NotNull String icon);
    }

    public interface IdStage {
        IsCustomStage id(@NotNull String id);
    }

    public interface IsCustomStage {
        IsDefaultStage isCustom(boolean isCustom);
    }

    public interface IsDefaultStage {
        IsFreeStage isDefault(boolean isDefault);
    }

    public interface IsFreeStage {
        IsTrialableStage isFree(boolean isFree);
    }

    public interface IsTrialableStage {
        NameStage isTrialable(boolean isTrialable);
    }

    public interface NameStage {
        PlanTypeStage name(@NotNull String name);
    }

    public interface PlanTypeStage {
        UpdatedAtStage planType(@NotNull String planType);
    }

    public interface UpdatedAtStage {
        ValidStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface ValidStage {
        _FinalStage valid(boolean valid);
    }

    public interface _FinalStage {
        CompanyPlanDetailResponseData build();

        _FinalStage audienceType(Optional<String> audienceType);

        _FinalStage audienceType(String audienceType);

        _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct);

        _FinalStage billingProduct(BillingProductDetailResponseData billingProduct);

        _FinalStage compatiblePlanIds(List<String> compatiblePlanIds);

        _FinalStage addCompatiblePlanIds(String compatiblePlanIds);

        _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds);

        _FinalStage customPlanConfig(Optional<CustomPlanConfig> customPlanConfig);

        _FinalStage customPlanConfig(CustomPlanConfig customPlanConfig);

        _FinalStage entitlements(List<PlanEntitlementResponseData> entitlements);

        _FinalStage addEntitlements(PlanEntitlementResponseData entitlements);

        _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> entitlements);

        _FinalStage features(List<FeatureDetailResponseData> features);

        _FinalStage addFeatures(FeatureDetailResponseData features);

        _FinalStage addAllFeatures(List<FeatureDetailResponseData> features);

        _FinalStage includedCreditGrants(List<PlanCreditGrantView> includedCreditGrants);

        _FinalStage addIncludedCreditGrants(PlanCreditGrantView includedCreditGrants);

        _FinalStage addAllIncludedCreditGrants(List<PlanCreditGrantView> includedCreditGrants);

        _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice);

        _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice);

        _FinalStage oneTimePrice(Optional<BillingPriceResponseData> oneTimePrice);

        _FinalStage oneTimePrice(BillingPriceResponseData oneTimePrice);

        _FinalStage trialDays(Optional<Integer> trialDays);

        _FinalStage trialDays(Integer trialDays);

        _FinalStage usageViolations(List<FeatureUsageResponseData> usageViolations);

        _FinalStage addUsageViolations(FeatureUsageResponseData usageViolations);

        _FinalStage addAllUsageViolations(List<FeatureUsageResponseData> usageViolations);

        _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice);

        _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements ChargeTypeStage,
                    CompanyCanTrialStage,
                    CompanyCountStage,
                    ControlledByStage,
                    CreatedAtStage,
                    CurrentStage,
                    CustomStage,
                    DescriptionStage,
                    IconStage,
                    IdStage,
                    IsCustomStage,
                    IsDefaultStage,
                    IsFreeStage,
                    IsTrialableStage,
                    NameStage,
                    PlanTypeStage,
                    UpdatedAtStage,
                    ValidStage,
                    _FinalStage {
        private String chargeType;

        private boolean companyCanTrial;

        private int companyCount;

        private String controlledBy;

        private OffsetDateTime createdAt;

        private boolean current;

        private boolean custom;

        private String description;

        private String icon;

        private String id;

        private boolean isCustom;

        private boolean isDefault;

        private boolean isFree;

        private boolean isTrialable;

        private String name;

        private String planType;

        private OffsetDateTime updatedAt;

        private boolean valid;

        private Optional<BillingPriceResponseData> yearlyPrice = Optional.empty();

        private List<FeatureUsageResponseData> usageViolations = new ArrayList<>();

        private Optional<Integer> trialDays = Optional.empty();

        private Optional<BillingPriceResponseData> oneTimePrice = Optional.empty();

        private Optional<BillingPriceResponseData> monthlyPrice = Optional.empty();

        private List<PlanCreditGrantView> includedCreditGrants = new ArrayList<>();

        private List<FeatureDetailResponseData> features = new ArrayList<>();

        private List<PlanEntitlementResponseData> entitlements = new ArrayList<>();

        private Optional<CustomPlanConfig> customPlanConfig = Optional.empty();

        private List<String> compatiblePlanIds = new ArrayList<>();

        private Optional<BillingProductDetailResponseData> billingProduct = Optional.empty();

        private Optional<String> audienceType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CompanyPlanDetailResponseData other) {
            audienceType(other.getAudienceType());
            billingProduct(other.getBillingProduct());
            chargeType(other.getChargeType());
            companyCanTrial(other.getCompanyCanTrial());
            companyCount(other.getCompanyCount());
            compatiblePlanIds(other.getCompatiblePlanIds());
            controlledBy(other.getControlledBy());
            createdAt(other.getCreatedAt());
            current(other.getCurrent());
            custom(other.getCustom());
            customPlanConfig(other.getCustomPlanConfig());
            description(other.getDescription());
            entitlements(other.getEntitlements());
            features(other.getFeatures());
            icon(other.getIcon());
            id(other.getId());
            includedCreditGrants(other.getIncludedCreditGrants());
            isCustom(other.getIsCustom());
            isDefault(other.getIsDefault());
            isFree(other.getIsFree());
            isTrialable(other.getIsTrialable());
            monthlyPrice(other.getMonthlyPrice());
            name(other.getName());
            oneTimePrice(other.getOneTimePrice());
            planType(other.getPlanType());
            trialDays(other.getTrialDays());
            updatedAt(other.getUpdatedAt());
            usageViolations(other.getUsageViolations());
            valid(other.getValid());
            yearlyPrice(other.getYearlyPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("charge_type")
        public CompanyCanTrialStage chargeType(@NotNull String chargeType) {
            this.chargeType = Objects.requireNonNull(chargeType, "chargeType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_can_trial")
        public CompanyCountStage companyCanTrial(boolean companyCanTrial) {
            this.companyCanTrial = companyCanTrial;
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_count")
        public ControlledByStage companyCount(int companyCount) {
            this.companyCount = companyCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("controlled_by")
        public CreatedAtStage controlledBy(@NotNull String controlledBy) {
            this.controlledBy = Objects.requireNonNull(controlledBy, "controlledBy must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public CurrentStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("current")
        public CustomStage current(boolean current) {
            this.current = current;
            return this;
        }

        @java.lang.Override
        @JsonSetter("custom")
        public DescriptionStage custom(boolean custom) {
            this.custom = custom;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public IconStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("icon")
        public IdStage icon(@NotNull String icon) {
            this.icon = Objects.requireNonNull(icon, "icon must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public IsCustomStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_custom")
        public IsDefaultStage isCustom(boolean isCustom) {
            this.isCustom = isCustom;
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_default")
        public IsFreeStage isDefault(boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_free")
        public IsTrialableStage isFree(boolean isFree) {
            this.isFree = isFree;
            return this;
        }

        @java.lang.Override
        @JsonSetter("is_trialable")
        public NameStage isTrialable(boolean isTrialable) {
            this.isTrialable = isTrialable;
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PlanTypeStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_type")
        public UpdatedAtStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public ValidStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("valid")
        public _FinalStage valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyPrice(BillingPriceResponseData yearlyPrice) {
            this.yearlyPrice = Optional.ofNullable(yearlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_price", nulls = Nulls.SKIP)
        public _FinalStage yearlyPrice(Optional<BillingPriceResponseData> yearlyPrice) {
            this.yearlyPrice = yearlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllUsageViolations(List<FeatureUsageResponseData> usageViolations) {
            if (usageViolations != null) {
                this.usageViolations.addAll(usageViolations);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addUsageViolations(FeatureUsageResponseData usageViolations) {
            this.usageViolations.add(usageViolations);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "usage_violations", nulls = Nulls.SKIP)
        public _FinalStage usageViolations(List<FeatureUsageResponseData> usageViolations) {
            this.usageViolations.clear();
            if (usageViolations != null) {
                this.usageViolations.addAll(usageViolations);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage trialDays(Integer trialDays) {
            this.trialDays = Optional.ofNullable(trialDays);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "trial_days", nulls = Nulls.SKIP)
        public _FinalStage trialDays(Optional<Integer> trialDays) {
            this.trialDays = trialDays;
            return this;
        }

        @java.lang.Override
        public _FinalStage oneTimePrice(BillingPriceResponseData oneTimePrice) {
            this.oneTimePrice = Optional.ofNullable(oneTimePrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "one_time_price", nulls = Nulls.SKIP)
        public _FinalStage oneTimePrice(Optional<BillingPriceResponseData> oneTimePrice) {
            this.oneTimePrice = oneTimePrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyPrice(BillingPriceResponseData monthlyPrice) {
            this.monthlyPrice = Optional.ofNullable(monthlyPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_price", nulls = Nulls.SKIP)
        public _FinalStage monthlyPrice(Optional<BillingPriceResponseData> monthlyPrice) {
            this.monthlyPrice = monthlyPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllIncludedCreditGrants(List<PlanCreditGrantView> includedCreditGrants) {
            if (includedCreditGrants != null) {
                this.includedCreditGrants.addAll(includedCreditGrants);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addIncludedCreditGrants(PlanCreditGrantView includedCreditGrants) {
            this.includedCreditGrants.add(includedCreditGrants);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "included_credit_grants", nulls = Nulls.SKIP)
        public _FinalStage includedCreditGrants(List<PlanCreditGrantView> includedCreditGrants) {
            this.includedCreditGrants.clear();
            if (includedCreditGrants != null) {
                this.includedCreditGrants.addAll(includedCreditGrants);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllFeatures(List<FeatureDetailResponseData> features) {
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addFeatures(FeatureDetailResponseData features) {
            this.features.add(features);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "features", nulls = Nulls.SKIP)
        public _FinalStage features(List<FeatureDetailResponseData> features) {
            this.features.clear();
            if (features != null) {
                this.features.addAll(features);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllEntitlements(List<PlanEntitlementResponseData> entitlements) {
            if (entitlements != null) {
                this.entitlements.addAll(entitlements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addEntitlements(PlanEntitlementResponseData entitlements) {
            this.entitlements.add(entitlements);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "entitlements", nulls = Nulls.SKIP)
        public _FinalStage entitlements(List<PlanEntitlementResponseData> entitlements) {
            this.entitlements.clear();
            if (entitlements != null) {
                this.entitlements.addAll(entitlements);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage customPlanConfig(CustomPlanConfig customPlanConfig) {
            this.customPlanConfig = Optional.ofNullable(customPlanConfig);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "custom_plan_config", nulls = Nulls.SKIP)
        public _FinalStage customPlanConfig(Optional<CustomPlanConfig> customPlanConfig) {
            this.customPlanConfig = customPlanConfig;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds) {
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCompatiblePlanIds(String compatiblePlanIds) {
            this.compatiblePlanIds.add(compatiblePlanIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "compatible_plan_ids", nulls = Nulls.SKIP)
        public _FinalStage compatiblePlanIds(List<String> compatiblePlanIds) {
            this.compatiblePlanIds.clear();
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage billingProduct(BillingProductDetailResponseData billingProduct) {
            this.billingProduct = Optional.ofNullable(billingProduct);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_product", nulls = Nulls.SKIP)
        public _FinalStage billingProduct(Optional<BillingProductDetailResponseData> billingProduct) {
            this.billingProduct = billingProduct;
            return this;
        }

        @java.lang.Override
        public _FinalStage audienceType(String audienceType) {
            this.audienceType = Optional.ofNullable(audienceType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "audience_type", nulls = Nulls.SKIP)
        public _FinalStage audienceType(Optional<String> audienceType) {
            this.audienceType = audienceType;
            return this;
        }

        @java.lang.Override
        public CompanyPlanDetailResponseData build() {
            return new CompanyPlanDetailResponseData(
                    audienceType,
                    billingProduct,
                    chargeType,
                    companyCanTrial,
                    companyCount,
                    compatiblePlanIds,
                    controlledBy,
                    createdAt,
                    current,
                    custom,
                    customPlanConfig,
                    description,
                    entitlements,
                    features,
                    icon,
                    id,
                    includedCreditGrants,
                    isCustom,
                    isDefault,
                    isFree,
                    isTrialable,
                    monthlyPrice,
                    name,
                    oneTimePrice,
                    planType,
                    trialDays,
                    updatedAt,
                    usageViolations,
                    valid,
                    yearlyPrice,
                    additionalProperties);
        }
    }
}
