/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompanyPlanWithBillingSubView.Builder.class)
public final class CompanyPlanWithBillingSubView {
    private final Optional<OffsetDateTime> addedOn;

    private final Optional<String> billingProductExternalId;

    private final Optional<String> billingProductId;

    private final Optional<String> description;

    private final String id;

    private final Optional<String> imageUrl;

    private final String name;

    private final Optional<String> planPeriod;

    private final Optional<Integer> planPrice;

    private final Map<String, Object> additionalProperties;

    private CompanyPlanWithBillingSubView(
            Optional<OffsetDateTime> addedOn,
            Optional<String> billingProductExternalId,
            Optional<String> billingProductId,
            Optional<String> description,
            String id,
            Optional<String> imageUrl,
            String name,
            Optional<String> planPeriod,
            Optional<Integer> planPrice,
            Map<String, Object> additionalProperties) {
        this.addedOn = addedOn;
        this.billingProductExternalId = billingProductExternalId;
        this.billingProductId = billingProductId;
        this.description = description;
        this.id = id;
        this.imageUrl = imageUrl;
        this.name = name;
        this.planPeriod = planPeriod;
        this.planPrice = planPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("added_on")
    public Optional<OffsetDateTime> getAddedOn() {
        return addedOn;
    }

    @JsonProperty("billing_product_external_id")
    public Optional<String> getBillingProductExternalId() {
        return billingProductExternalId;
    }

    @JsonProperty("billing_product_id")
    public Optional<String> getBillingProductId() {
        return billingProductId;
    }

    @JsonProperty("description")
    public Optional<String> getDescription() {
        return description;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("image_url")
    public Optional<String> getImageUrl() {
        return imageUrl;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("plan_period")
    public Optional<String> getPlanPeriod() {
        return planPeriod;
    }

    @JsonProperty("plan_price")
    public Optional<Integer> getPlanPrice() {
        return planPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompanyPlanWithBillingSubView && equalTo((CompanyPlanWithBillingSubView) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompanyPlanWithBillingSubView other) {
        return addedOn.equals(other.addedOn)
                && billingProductExternalId.equals(other.billingProductExternalId)
                && billingProductId.equals(other.billingProductId)
                && description.equals(other.description)
                && id.equals(other.id)
                && imageUrl.equals(other.imageUrl)
                && name.equals(other.name)
                && planPeriod.equals(other.planPeriod)
                && planPrice.equals(other.planPrice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.addedOn,
                this.billingProductExternalId,
                this.billingProductId,
                this.description,
                this.id,
                this.imageUrl,
                this.name,
                this.planPeriod,
                this.planPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static IdStage builder() {
        return new Builder();
    }

    public interface IdStage {
        NameStage id(@NotNull String id);

        Builder from(CompanyPlanWithBillingSubView other);
    }

    public interface NameStage {
        _FinalStage name(@NotNull String name);
    }

    public interface _FinalStage {
        CompanyPlanWithBillingSubView build();

        _FinalStage addedOn(Optional<OffsetDateTime> addedOn);

        _FinalStage addedOn(OffsetDateTime addedOn);

        _FinalStage billingProductExternalId(Optional<String> billingProductExternalId);

        _FinalStage billingProductExternalId(String billingProductExternalId);

        _FinalStage billingProductId(Optional<String> billingProductId);

        _FinalStage billingProductId(String billingProductId);

        _FinalStage description(Optional<String> description);

        _FinalStage description(String description);

        _FinalStage imageUrl(Optional<String> imageUrl);

        _FinalStage imageUrl(String imageUrl);

        _FinalStage planPeriod(Optional<String> planPeriod);

        _FinalStage planPeriod(String planPeriod);

        _FinalStage planPrice(Optional<Integer> planPrice);

        _FinalStage planPrice(Integer planPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements IdStage, NameStage, _FinalStage {
        private String id;

        private String name;

        private Optional<Integer> planPrice = Optional.empty();

        private Optional<String> planPeriod = Optional.empty();

        private Optional<String> imageUrl = Optional.empty();

        private Optional<String> description = Optional.empty();

        private Optional<String> billingProductId = Optional.empty();

        private Optional<String> billingProductExternalId = Optional.empty();

        private Optional<OffsetDateTime> addedOn = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CompanyPlanWithBillingSubView other) {
            addedOn(other.getAddedOn());
            billingProductExternalId(other.getBillingProductExternalId());
            billingProductId(other.getBillingProductId());
            description(other.getDescription());
            id(other.getId());
            imageUrl(other.getImageUrl());
            name(other.getName());
            planPeriod(other.getPlanPeriod());
            planPrice(other.getPlanPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public _FinalStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage planPrice(Integer planPrice) {
            this.planPrice = Optional.ofNullable(planPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_price", nulls = Nulls.SKIP)
        public _FinalStage planPrice(Optional<Integer> planPrice) {
            this.planPrice = planPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage planPeriod(String planPeriod) {
            this.planPeriod = Optional.ofNullable(planPeriod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "plan_period", nulls = Nulls.SKIP)
        public _FinalStage planPeriod(Optional<String> planPeriod) {
            this.planPeriod = planPeriod;
            return this;
        }

        @java.lang.Override
        public _FinalStage imageUrl(String imageUrl) {
            this.imageUrl = Optional.ofNullable(imageUrl);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "image_url", nulls = Nulls.SKIP)
        public _FinalStage imageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        @java.lang.Override
        public _FinalStage description(String description) {
            this.description = Optional.ofNullable(description);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "description", nulls = Nulls.SKIP)
        public _FinalStage description(Optional<String> description) {
            this.description = description;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingProductId(String billingProductId) {
            this.billingProductId = Optional.ofNullable(billingProductId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_product_id", nulls = Nulls.SKIP)
        public _FinalStage billingProductId(Optional<String> billingProductId) {
            this.billingProductId = billingProductId;
            return this;
        }

        @java.lang.Override
        public _FinalStage billingProductExternalId(String billingProductExternalId) {
            this.billingProductExternalId = Optional.ofNullable(billingProductExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "billing_product_external_id", nulls = Nulls.SKIP)
        public _FinalStage billingProductExternalId(Optional<String> billingProductExternalId) {
            this.billingProductExternalId = billingProductExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addedOn(OffsetDateTime addedOn) {
            this.addedOn = Optional.ofNullable(addedOn);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "added_on", nulls = Nulls.SKIP)
        public _FinalStage addedOn(Optional<OffsetDateTime> addedOn) {
            this.addedOn = addedOn;
            return this;
        }

        @java.lang.Override
        public CompanyPlanWithBillingSubView build() {
            return new CompanyPlanWithBillingSubView(
                    addedOn,
                    billingProductExternalId,
                    billingProductId,
                    description,
                    id,
                    imageUrl,
                    name,
                    planPeriod,
                    planPrice,
                    additionalProperties);
        }
    }
}
