/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CompatiblePlansResponseData.Builder.class)
public final class CompatiblePlansResponseData {
    private final List<String> compatiblePlanIds;

    private final String sourcePlanId;

    private final Map<String, Object> additionalProperties;

    private CompatiblePlansResponseData(
            List<String> compatiblePlanIds, String sourcePlanId, Map<String, Object> additionalProperties) {
        this.compatiblePlanIds = compatiblePlanIds;
        this.sourcePlanId = sourcePlanId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("compatible_plan_ids")
    public List<String> getCompatiblePlanIds() {
        return compatiblePlanIds;
    }

    @JsonProperty("source_plan_id")
    public String getSourcePlanId() {
        return sourcePlanId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CompatiblePlansResponseData && equalTo((CompatiblePlansResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CompatiblePlansResponseData other) {
        return compatiblePlanIds.equals(other.compatiblePlanIds) && sourcePlanId.equals(other.sourcePlanId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.compatiblePlanIds, this.sourcePlanId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SourcePlanIdStage builder() {
        return new Builder();
    }

    public interface SourcePlanIdStage {
        _FinalStage sourcePlanId(@NotNull String sourcePlanId);

        Builder from(CompatiblePlansResponseData other);
    }

    public interface _FinalStage {
        CompatiblePlansResponseData build();

        _FinalStage compatiblePlanIds(List<String> compatiblePlanIds);

        _FinalStage addCompatiblePlanIds(String compatiblePlanIds);

        _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SourcePlanIdStage, _FinalStage {
        private String sourcePlanId;

        private List<String> compatiblePlanIds = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CompatiblePlansResponseData other) {
            compatiblePlanIds(other.getCompatiblePlanIds());
            sourcePlanId(other.getSourcePlanId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("source_plan_id")
        public _FinalStage sourcePlanId(@NotNull String sourcePlanId) {
            this.sourcePlanId = Objects.requireNonNull(sourcePlanId, "sourcePlanId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllCompatiblePlanIds(List<String> compatiblePlanIds) {
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addCompatiblePlanIds(String compatiblePlanIds) {
            this.compatiblePlanIds.add(compatiblePlanIds);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "compatible_plan_ids", nulls = Nulls.SKIP)
        public _FinalStage compatiblePlanIds(List<String> compatiblePlanIds) {
            this.compatiblePlanIds.clear();
            if (compatiblePlanIds != null) {
                this.compatiblePlanIds.addAll(compatiblePlanIds);
            }
            return this;
        }

        @java.lang.Override
        public CompatiblePlansResponseData build() {
            return new CompatiblePlansResponseData(compatiblePlanIds, sourcePlanId, additionalProperties);
        }
    }
}
