/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = ComponentCheckoutSettings.Builder.class)
public final class ComponentCheckoutSettings {
    private final boolean collectAddress;

    private final boolean collectEmail;

    private final boolean collectPhone;

    private final boolean taxCollectionEnabled;

    private final Map<String, Object> additionalProperties;

    private ComponentCheckoutSettings(
            boolean collectAddress,
            boolean collectEmail,
            boolean collectPhone,
            boolean taxCollectionEnabled,
            Map<String, Object> additionalProperties) {
        this.collectAddress = collectAddress;
        this.collectEmail = collectEmail;
        this.collectPhone = collectPhone;
        this.taxCollectionEnabled = taxCollectionEnabled;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("collect_address")
    public boolean getCollectAddress() {
        return collectAddress;
    }

    @JsonProperty("collect_email")
    public boolean getCollectEmail() {
        return collectEmail;
    }

    @JsonProperty("collect_phone")
    public boolean getCollectPhone() {
        return collectPhone;
    }

    @JsonProperty("tax_collection_enabled")
    public boolean getTaxCollectionEnabled() {
        return taxCollectionEnabled;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof ComponentCheckoutSettings && equalTo((ComponentCheckoutSettings) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(ComponentCheckoutSettings other) {
        return collectAddress == other.collectAddress
                && collectEmail == other.collectEmail
                && collectPhone == other.collectPhone
                && taxCollectionEnabled == other.taxCollectionEnabled;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.collectAddress, this.collectEmail, this.collectPhone, this.taxCollectionEnabled);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CollectAddressStage builder() {
        return new Builder();
    }

    public interface CollectAddressStage {
        CollectEmailStage collectAddress(boolean collectAddress);

        Builder from(ComponentCheckoutSettings other);
    }

    public interface CollectEmailStage {
        CollectPhoneStage collectEmail(boolean collectEmail);
    }

    public interface CollectPhoneStage {
        TaxCollectionEnabledStage collectPhone(boolean collectPhone);
    }

    public interface TaxCollectionEnabledStage {
        _FinalStage taxCollectionEnabled(boolean taxCollectionEnabled);
    }

    public interface _FinalStage {
        ComponentCheckoutSettings build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CollectAddressStage,
                    CollectEmailStage,
                    CollectPhoneStage,
                    TaxCollectionEnabledStage,
                    _FinalStage {
        private boolean collectAddress;

        private boolean collectEmail;

        private boolean collectPhone;

        private boolean taxCollectionEnabled;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(ComponentCheckoutSettings other) {
            collectAddress(other.getCollectAddress());
            collectEmail(other.getCollectEmail());
            collectPhone(other.getCollectPhone());
            taxCollectionEnabled(other.getTaxCollectionEnabled());
            return this;
        }

        @java.lang.Override
        @JsonSetter("collect_address")
        public CollectEmailStage collectAddress(boolean collectAddress) {
            this.collectAddress = collectAddress;
            return this;
        }

        @java.lang.Override
        @JsonSetter("collect_email")
        public CollectPhoneStage collectEmail(boolean collectEmail) {
            this.collectEmail = collectEmail;
            return this;
        }

        @java.lang.Override
        @JsonSetter("collect_phone")
        public TaxCollectionEnabledStage collectPhone(boolean collectPhone) {
            this.collectPhone = collectPhone;
            return this;
        }

        @java.lang.Override
        @JsonSetter("tax_collection_enabled")
        public _FinalStage taxCollectionEnabled(boolean taxCollectionEnabled) {
            this.taxCollectionEnabled = taxCollectionEnabled;
            return this;
        }

        @java.lang.Override
        public ComponentCheckoutSettings build() {
            return new ComponentCheckoutSettings(
                    collectAddress, collectEmail, collectPhone, taxCollectionEnabled, additionalProperties);
        }
    }
}
