/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreateOrUpdateRuleRequestBody.Builder.class)
public final class CreateOrUpdateRuleRequestBody {
    private final List<CreateOrUpdateConditionGroupRequestBody> conditionGroups;

    private final List<CreateOrUpdateConditionRequestBody> conditions;

    private final Optional<String> id;

    private final String name;

    private final int priority;

    private final Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType;

    private final boolean value;

    private final Map<String, Object> additionalProperties;

    private CreateOrUpdateRuleRequestBody(
            List<CreateOrUpdateConditionGroupRequestBody> conditionGroups,
            List<CreateOrUpdateConditionRequestBody> conditions,
            Optional<String> id,
            String name,
            int priority,
            Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType,
            boolean value,
            Map<String, Object> additionalProperties) {
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.id = id;
        this.name = name;
        this.priority = priority;
        this.ruleType = ruleType;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("condition_groups")
    public List<CreateOrUpdateConditionGroupRequestBody> getConditionGroups() {
        return conditionGroups;
    }

    @JsonProperty("conditions")
    public List<CreateOrUpdateConditionRequestBody> getConditions() {
        return conditions;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("priority")
    public int getPriority() {
        return priority;
    }

    @JsonProperty("rule_type")
    public Optional<CreateOrUpdateRuleRequestBodyRuleType> getRuleType() {
        return ruleType;
    }

    @JsonProperty("value")
    public boolean getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreateOrUpdateRuleRequestBody && equalTo((CreateOrUpdateRuleRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreateOrUpdateRuleRequestBody other) {
        return conditionGroups.equals(other.conditionGroups)
                && conditions.equals(other.conditions)
                && id.equals(other.id)
                && name.equals(other.name)
                && priority == other.priority
                && ruleType.equals(other.ruleType)
                && value == other.value;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.conditionGroups, this.conditions, this.id, this.name, this.priority, this.ruleType, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static NameStage builder() {
        return new Builder();
    }

    public interface NameStage {
        PriorityStage name(@NotNull String name);

        Builder from(CreateOrUpdateRuleRequestBody other);
    }

    public interface PriorityStage {
        ValueStage priority(int priority);
    }

    public interface ValueStage {
        _FinalStage value(boolean value);
    }

    public interface _FinalStage {
        CreateOrUpdateRuleRequestBody build();

        _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups);

        _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups);

        _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups);

        _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> conditions);

        _FinalStage addConditions(CreateOrUpdateConditionRequestBody conditions);

        _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions);

        _FinalStage id(Optional<String> id);

        _FinalStage id(String id);

        _FinalStage ruleType(Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType);

        _FinalStage ruleType(CreateOrUpdateRuleRequestBodyRuleType ruleType);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements NameStage, PriorityStage, ValueStage, _FinalStage {
        private String name;

        private int priority;

        private boolean value;

        private Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType = Optional.empty();

        private Optional<String> id = Optional.empty();

        private List<CreateOrUpdateConditionRequestBody> conditions = new ArrayList<>();

        private List<CreateOrUpdateConditionGroupRequestBody> conditionGroups = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreateOrUpdateRuleRequestBody other) {
            conditionGroups(other.getConditionGroups());
            conditions(other.getConditions());
            id(other.getId());
            name(other.getName());
            priority(other.getPriority());
            ruleType(other.getRuleType());
            value(other.getValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("priority")
        public ValueStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @java.lang.Override
        public _FinalStage ruleType(CreateOrUpdateRuleRequestBodyRuleType ruleType) {
            this.ruleType = Optional.ofNullable(ruleType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "rule_type", nulls = Nulls.SKIP)
        public _FinalStage ruleType(Optional<CreateOrUpdateRuleRequestBodyRuleType> ruleType) {
            this.ruleType = ruleType;
            return this;
        }

        @java.lang.Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditions(CreateOrUpdateConditionRequestBody conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public _FinalStage conditions(List<CreateOrUpdateConditionRequestBody> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditionGroups(CreateOrUpdateConditionGroupRequestBody conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "condition_groups", nulls = Nulls.SKIP)
        public _FinalStage conditionGroups(List<CreateOrUpdateConditionGroupRequestBody> conditionGroups) {
            this.conditionGroups.clear();
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @java.lang.Override
        public CreateOrUpdateRuleRequestBody build() {
            return new CreateOrUpdateRuleRequestBody(
                    conditionGroups, conditions, id, name, priority, ruleType, value, additionalProperties);
        }
    }
}
