/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreditGrantExpiryRequestBody.Builder.class)
public final class CreditGrantExpiryRequestBody {
    private final Optional<CreditGrantExpiryRequestBodyExpiryType> expiryType;

    private final Optional<CreditGrantExpiryRequestBodyExpiryUnit> expiryUnit;

    private final Optional<Integer> expiryUnitCount;

    private final CreditGrantExpiryRequestBodyResetCadence resetCadence;

    private final CreditGrantExpiryRequestBodyResetStart resetStart;

    private final Optional<CreditGrantExpiryRequestBodyResetType> resetType;

    private final Map<String, Object> additionalProperties;

    private CreditGrantExpiryRequestBody(
            Optional<CreditGrantExpiryRequestBodyExpiryType> expiryType,
            Optional<CreditGrantExpiryRequestBodyExpiryUnit> expiryUnit,
            Optional<Integer> expiryUnitCount,
            CreditGrantExpiryRequestBodyResetCadence resetCadence,
            CreditGrantExpiryRequestBodyResetStart resetStart,
            Optional<CreditGrantExpiryRequestBodyResetType> resetType,
            Map<String, Object> additionalProperties) {
        this.expiryType = expiryType;
        this.expiryUnit = expiryUnit;
        this.expiryUnitCount = expiryUnitCount;
        this.resetCadence = resetCadence;
        this.resetStart = resetStart;
        this.resetType = resetType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("expiry_type")
    public Optional<CreditGrantExpiryRequestBodyExpiryType> getExpiryType() {
        return expiryType;
    }

    @JsonProperty("expiry_unit")
    public Optional<CreditGrantExpiryRequestBodyExpiryUnit> getExpiryUnit() {
        return expiryUnit;
    }

    @JsonProperty("expiry_unit_count")
    public Optional<Integer> getExpiryUnitCount() {
        return expiryUnitCount;
    }

    @JsonProperty("reset_cadence")
    public CreditGrantExpiryRequestBodyResetCadence getResetCadence() {
        return resetCadence;
    }

    @JsonProperty("reset_start")
    public CreditGrantExpiryRequestBodyResetStart getResetStart() {
        return resetStart;
    }

    @JsonProperty("reset_type")
    public Optional<CreditGrantExpiryRequestBodyResetType> getResetType() {
        return resetType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreditGrantExpiryRequestBody && equalTo((CreditGrantExpiryRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditGrantExpiryRequestBody other) {
        return expiryType.equals(other.expiryType)
                && expiryUnit.equals(other.expiryUnit)
                && expiryUnitCount.equals(other.expiryUnitCount)
                && resetCadence.equals(other.resetCadence)
                && resetStart.equals(other.resetStart)
                && resetType.equals(other.resetType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.expiryType,
                this.expiryUnit,
                this.expiryUnitCount,
                this.resetCadence,
                this.resetStart,
                this.resetType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ResetCadenceStage builder() {
        return new Builder();
    }

    public interface ResetCadenceStage {
        ResetStartStage resetCadence(@NotNull CreditGrantExpiryRequestBodyResetCadence resetCadence);

        Builder from(CreditGrantExpiryRequestBody other);
    }

    public interface ResetStartStage {
        _FinalStage resetStart(@NotNull CreditGrantExpiryRequestBodyResetStart resetStart);
    }

    public interface _FinalStage {
        CreditGrantExpiryRequestBody build();

        _FinalStage expiryType(Optional<CreditGrantExpiryRequestBodyExpiryType> expiryType);

        _FinalStage expiryType(CreditGrantExpiryRequestBodyExpiryType expiryType);

        _FinalStage expiryUnit(Optional<CreditGrantExpiryRequestBodyExpiryUnit> expiryUnit);

        _FinalStage expiryUnit(CreditGrantExpiryRequestBodyExpiryUnit expiryUnit);

        _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount);

        _FinalStage expiryUnitCount(Integer expiryUnitCount);

        _FinalStage resetType(Optional<CreditGrantExpiryRequestBodyResetType> resetType);

        _FinalStage resetType(CreditGrantExpiryRequestBodyResetType resetType);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ResetCadenceStage, ResetStartStage, _FinalStage {
        private CreditGrantExpiryRequestBodyResetCadence resetCadence;

        private CreditGrantExpiryRequestBodyResetStart resetStart;

        private Optional<CreditGrantExpiryRequestBodyResetType> resetType = Optional.empty();

        private Optional<Integer> expiryUnitCount = Optional.empty();

        private Optional<CreditGrantExpiryRequestBodyExpiryUnit> expiryUnit = Optional.empty();

        private Optional<CreditGrantExpiryRequestBodyExpiryType> expiryType = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreditGrantExpiryRequestBody other) {
            expiryType(other.getExpiryType());
            expiryUnit(other.getExpiryUnit());
            expiryUnitCount(other.getExpiryUnitCount());
            resetCadence(other.getResetCadence());
            resetStart(other.getResetStart());
            resetType(other.getResetType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_cadence")
        public ResetStartStage resetCadence(@NotNull CreditGrantExpiryRequestBodyResetCadence resetCadence) {
            this.resetCadence = Objects.requireNonNull(resetCadence, "resetCadence must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reset_start")
        public _FinalStage resetStart(@NotNull CreditGrantExpiryRequestBodyResetStart resetStart) {
            this.resetStart = Objects.requireNonNull(resetStart, "resetStart must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage resetType(CreditGrantExpiryRequestBodyResetType resetType) {
            this.resetType = Optional.ofNullable(resetType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "reset_type", nulls = Nulls.SKIP)
        public _FinalStage resetType(Optional<CreditGrantExpiryRequestBodyResetType> resetType) {
            this.resetType = resetType;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnitCount(Integer expiryUnitCount) {
            this.expiryUnitCount = Optional.ofNullable(expiryUnitCount);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit_count", nulls = Nulls.SKIP)
        public _FinalStage expiryUnitCount(Optional<Integer> expiryUnitCount) {
            this.expiryUnitCount = expiryUnitCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryUnit(CreditGrantExpiryRequestBodyExpiryUnit expiryUnit) {
            this.expiryUnit = Optional.ofNullable(expiryUnit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_unit", nulls = Nulls.SKIP)
        public _FinalStage expiryUnit(Optional<CreditGrantExpiryRequestBodyExpiryUnit> expiryUnit) {
            this.expiryUnit = expiryUnit;
            return this;
        }

        @java.lang.Override
        public _FinalStage expiryType(CreditGrantExpiryRequestBodyExpiryType expiryType) {
            this.expiryType = Optional.ofNullable(expiryType);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "expiry_type", nulls = Nulls.SKIP)
        public _FinalStage expiryType(Optional<CreditGrantExpiryRequestBodyExpiryType> expiryType) {
            this.expiryType = expiryType;
            return this;
        }

        @java.lang.Override
        public CreditGrantExpiryRequestBody build() {
            return new CreditGrantExpiryRequestBody(
                    expiryType, expiryUnit, expiryUnitCount, resetCadence, resetStart, resetType, additionalProperties);
        }
    }
}
