/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CreditLedgerEnrichedEntryResponseData.Builder.class)
public final class CreditLedgerEnrichedEntryResponseData {
    private final String billingCreditId;

    private final Optional<CompanyLedgerResponseData> company;

    private final String companyId;

    private final Optional<BillingCreditLedgerResponseData> credit;

    private final int expiredGrantCount;

    private final Optional<FeatureLedgerResponseData> feature;

    private final Optional<String> featureId;

    private final OffsetDateTime firstTransactionAt;

    private final int freeGrantCount;

    private final int grantCount;

    private final OffsetDateTime lastTransactionAt;

    private final int manuallyZeroedCount;

    private final double netChange;

    private final int planGrantCount;

    private final int purchasedGrantCount;

    private final OffsetDateTime timeBucket;

    private final double totalConsumed;

    private final double totalGranted;

    private final int transactionCount;

    private final int usageCount;

    private final int zeroedOutCount;

    private final Map<String, Object> additionalProperties;

    private CreditLedgerEnrichedEntryResponseData(
            String billingCreditId,
            Optional<CompanyLedgerResponseData> company,
            String companyId,
            Optional<BillingCreditLedgerResponseData> credit,
            int expiredGrantCount,
            Optional<FeatureLedgerResponseData> feature,
            Optional<String> featureId,
            OffsetDateTime firstTransactionAt,
            int freeGrantCount,
            int grantCount,
            OffsetDateTime lastTransactionAt,
            int manuallyZeroedCount,
            double netChange,
            int planGrantCount,
            int purchasedGrantCount,
            OffsetDateTime timeBucket,
            double totalConsumed,
            double totalGranted,
            int transactionCount,
            int usageCount,
            int zeroedOutCount,
            Map<String, Object> additionalProperties) {
        this.billingCreditId = billingCreditId;
        this.company = company;
        this.companyId = companyId;
        this.credit = credit;
        this.expiredGrantCount = expiredGrantCount;
        this.feature = feature;
        this.featureId = featureId;
        this.firstTransactionAt = firstTransactionAt;
        this.freeGrantCount = freeGrantCount;
        this.grantCount = grantCount;
        this.lastTransactionAt = lastTransactionAt;
        this.manuallyZeroedCount = manuallyZeroedCount;
        this.netChange = netChange;
        this.planGrantCount = planGrantCount;
        this.purchasedGrantCount = purchasedGrantCount;
        this.timeBucket = timeBucket;
        this.totalConsumed = totalConsumed;
        this.totalGranted = totalGranted;
        this.transactionCount = transactionCount;
        this.usageCount = usageCount;
        this.zeroedOutCount = zeroedOutCount;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("billing_credit_id")
    public String getBillingCreditId() {
        return billingCreditId;
    }

    @JsonProperty("company")
    public Optional<CompanyLedgerResponseData> getCompany() {
        return company;
    }

    @JsonProperty("company_id")
    public String getCompanyId() {
        return companyId;
    }

    @JsonProperty("credit")
    public Optional<BillingCreditLedgerResponseData> getCredit() {
        return credit;
    }

    @JsonProperty("expired_grant_count")
    public int getExpiredGrantCount() {
        return expiredGrantCount;
    }

    @JsonProperty("feature")
    public Optional<FeatureLedgerResponseData> getFeature() {
        return feature;
    }

    @JsonProperty("feature_id")
    public Optional<String> getFeatureId() {
        return featureId;
    }

    @JsonProperty("first_transaction_at")
    public OffsetDateTime getFirstTransactionAt() {
        return firstTransactionAt;
    }

    @JsonProperty("free_grant_count")
    public int getFreeGrantCount() {
        return freeGrantCount;
    }

    @JsonProperty("grant_count")
    public int getGrantCount() {
        return grantCount;
    }

    @JsonProperty("last_transaction_at")
    public OffsetDateTime getLastTransactionAt() {
        return lastTransactionAt;
    }

    @JsonProperty("manually_zeroed_count")
    public int getManuallyZeroedCount() {
        return manuallyZeroedCount;
    }

    @JsonProperty("net_change")
    public double getNetChange() {
        return netChange;
    }

    @JsonProperty("plan_grant_count")
    public int getPlanGrantCount() {
        return planGrantCount;
    }

    @JsonProperty("purchased_grant_count")
    public int getPurchasedGrantCount() {
        return purchasedGrantCount;
    }

    @JsonProperty("time_bucket")
    public OffsetDateTime getTimeBucket() {
        return timeBucket;
    }

    @JsonProperty("total_consumed")
    public double getTotalConsumed() {
        return totalConsumed;
    }

    @JsonProperty("total_granted")
    public double getTotalGranted() {
        return totalGranted;
    }

    @JsonProperty("transaction_count")
    public int getTransactionCount() {
        return transactionCount;
    }

    @JsonProperty("usage_count")
    public int getUsageCount() {
        return usageCount;
    }

    @JsonProperty("zeroed_out_count")
    public int getZeroedOutCount() {
        return zeroedOutCount;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CreditLedgerEnrichedEntryResponseData
                && equalTo((CreditLedgerEnrichedEntryResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CreditLedgerEnrichedEntryResponseData other) {
        return billingCreditId.equals(other.billingCreditId)
                && company.equals(other.company)
                && companyId.equals(other.companyId)
                && credit.equals(other.credit)
                && expiredGrantCount == other.expiredGrantCount
                && feature.equals(other.feature)
                && featureId.equals(other.featureId)
                && firstTransactionAt.equals(other.firstTransactionAt)
                && freeGrantCount == other.freeGrantCount
                && grantCount == other.grantCount
                && lastTransactionAt.equals(other.lastTransactionAt)
                && manuallyZeroedCount == other.manuallyZeroedCount
                && netChange == other.netChange
                && planGrantCount == other.planGrantCount
                && purchasedGrantCount == other.purchasedGrantCount
                && timeBucket.equals(other.timeBucket)
                && totalConsumed == other.totalConsumed
                && totalGranted == other.totalGranted
                && transactionCount == other.transactionCount
                && usageCount == other.usageCount
                && zeroedOutCount == other.zeroedOutCount;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.billingCreditId,
                this.company,
                this.companyId,
                this.credit,
                this.expiredGrantCount,
                this.feature,
                this.featureId,
                this.firstTransactionAt,
                this.freeGrantCount,
                this.grantCount,
                this.lastTransactionAt,
                this.manuallyZeroedCount,
                this.netChange,
                this.planGrantCount,
                this.purchasedGrantCount,
                this.timeBucket,
                this.totalConsumed,
                this.totalGranted,
                this.transactionCount,
                this.usageCount,
                this.zeroedOutCount);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static BillingCreditIdStage builder() {
        return new Builder();
    }

    public interface BillingCreditIdStage {
        CompanyIdStage billingCreditId(@NotNull String billingCreditId);

        Builder from(CreditLedgerEnrichedEntryResponseData other);
    }

    public interface CompanyIdStage {
        ExpiredGrantCountStage companyId(@NotNull String companyId);
    }

    public interface ExpiredGrantCountStage {
        FirstTransactionAtStage expiredGrantCount(int expiredGrantCount);
    }

    public interface FirstTransactionAtStage {
        FreeGrantCountStage firstTransactionAt(@NotNull OffsetDateTime firstTransactionAt);
    }

    public interface FreeGrantCountStage {
        GrantCountStage freeGrantCount(int freeGrantCount);
    }

    public interface GrantCountStage {
        LastTransactionAtStage grantCount(int grantCount);
    }

    public interface LastTransactionAtStage {
        ManuallyZeroedCountStage lastTransactionAt(@NotNull OffsetDateTime lastTransactionAt);
    }

    public interface ManuallyZeroedCountStage {
        NetChangeStage manuallyZeroedCount(int manuallyZeroedCount);
    }

    public interface NetChangeStage {
        PlanGrantCountStage netChange(double netChange);
    }

    public interface PlanGrantCountStage {
        PurchasedGrantCountStage planGrantCount(int planGrantCount);
    }

    public interface PurchasedGrantCountStage {
        TimeBucketStage purchasedGrantCount(int purchasedGrantCount);
    }

    public interface TimeBucketStage {
        TotalConsumedStage timeBucket(@NotNull OffsetDateTime timeBucket);
    }

    public interface TotalConsumedStage {
        TotalGrantedStage totalConsumed(double totalConsumed);
    }

    public interface TotalGrantedStage {
        TransactionCountStage totalGranted(double totalGranted);
    }

    public interface TransactionCountStage {
        UsageCountStage transactionCount(int transactionCount);
    }

    public interface UsageCountStage {
        ZeroedOutCountStage usageCount(int usageCount);
    }

    public interface ZeroedOutCountStage {
        _FinalStage zeroedOutCount(int zeroedOutCount);
    }

    public interface _FinalStage {
        CreditLedgerEnrichedEntryResponseData build();

        _FinalStage company(Optional<CompanyLedgerResponseData> company);

        _FinalStage company(CompanyLedgerResponseData company);

        _FinalStage credit(Optional<BillingCreditLedgerResponseData> credit);

        _FinalStage credit(BillingCreditLedgerResponseData credit);

        _FinalStage feature(Optional<FeatureLedgerResponseData> feature);

        _FinalStage feature(FeatureLedgerResponseData feature);

        _FinalStage featureId(Optional<String> featureId);

        _FinalStage featureId(String featureId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements BillingCreditIdStage,
                    CompanyIdStage,
                    ExpiredGrantCountStage,
                    FirstTransactionAtStage,
                    FreeGrantCountStage,
                    GrantCountStage,
                    LastTransactionAtStage,
                    ManuallyZeroedCountStage,
                    NetChangeStage,
                    PlanGrantCountStage,
                    PurchasedGrantCountStage,
                    TimeBucketStage,
                    TotalConsumedStage,
                    TotalGrantedStage,
                    TransactionCountStage,
                    UsageCountStage,
                    ZeroedOutCountStage,
                    _FinalStage {
        private String billingCreditId;

        private String companyId;

        private int expiredGrantCount;

        private OffsetDateTime firstTransactionAt;

        private int freeGrantCount;

        private int grantCount;

        private OffsetDateTime lastTransactionAt;

        private int manuallyZeroedCount;

        private double netChange;

        private int planGrantCount;

        private int purchasedGrantCount;

        private OffsetDateTime timeBucket;

        private double totalConsumed;

        private double totalGranted;

        private int transactionCount;

        private int usageCount;

        private int zeroedOutCount;

        private Optional<String> featureId = Optional.empty();

        private Optional<FeatureLedgerResponseData> feature = Optional.empty();

        private Optional<BillingCreditLedgerResponseData> credit = Optional.empty();

        private Optional<CompanyLedgerResponseData> company = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CreditLedgerEnrichedEntryResponseData other) {
            billingCreditId(other.getBillingCreditId());
            company(other.getCompany());
            companyId(other.getCompanyId());
            credit(other.getCredit());
            expiredGrantCount(other.getExpiredGrantCount());
            feature(other.getFeature());
            featureId(other.getFeatureId());
            firstTransactionAt(other.getFirstTransactionAt());
            freeGrantCount(other.getFreeGrantCount());
            grantCount(other.getGrantCount());
            lastTransactionAt(other.getLastTransactionAt());
            manuallyZeroedCount(other.getManuallyZeroedCount());
            netChange(other.getNetChange());
            planGrantCount(other.getPlanGrantCount());
            purchasedGrantCount(other.getPurchasedGrantCount());
            timeBucket(other.getTimeBucket());
            totalConsumed(other.getTotalConsumed());
            totalGranted(other.getTotalGranted());
            transactionCount(other.getTransactionCount());
            usageCount(other.getUsageCount());
            zeroedOutCount(other.getZeroedOutCount());
            return this;
        }

        @java.lang.Override
        @JsonSetter("billing_credit_id")
        public CompanyIdStage billingCreditId(@NotNull String billingCreditId) {
            this.billingCreditId = Objects.requireNonNull(billingCreditId, "billingCreditId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("company_id")
        public ExpiredGrantCountStage companyId(@NotNull String companyId) {
            this.companyId = Objects.requireNonNull(companyId, "companyId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("expired_grant_count")
        public FirstTransactionAtStage expiredGrantCount(int expiredGrantCount) {
            this.expiredGrantCount = expiredGrantCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("first_transaction_at")
        public FreeGrantCountStage firstTransactionAt(@NotNull OffsetDateTime firstTransactionAt) {
            this.firstTransactionAt = Objects.requireNonNull(firstTransactionAt, "firstTransactionAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("free_grant_count")
        public GrantCountStage freeGrantCount(int freeGrantCount) {
            this.freeGrantCount = freeGrantCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("grant_count")
        public LastTransactionAtStage grantCount(int grantCount) {
            this.grantCount = grantCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("last_transaction_at")
        public ManuallyZeroedCountStage lastTransactionAt(@NotNull OffsetDateTime lastTransactionAt) {
            this.lastTransactionAt = Objects.requireNonNull(lastTransactionAt, "lastTransactionAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("manually_zeroed_count")
        public NetChangeStage manuallyZeroedCount(int manuallyZeroedCount) {
            this.manuallyZeroedCount = manuallyZeroedCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("net_change")
        public PlanGrantCountStage netChange(double netChange) {
            this.netChange = netChange;
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_grant_count")
        public PurchasedGrantCountStage planGrantCount(int planGrantCount) {
            this.planGrantCount = planGrantCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("purchased_grant_count")
        public TimeBucketStage purchasedGrantCount(int purchasedGrantCount) {
            this.purchasedGrantCount = purchasedGrantCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("time_bucket")
        public TotalConsumedStage timeBucket(@NotNull OffsetDateTime timeBucket) {
            this.timeBucket = Objects.requireNonNull(timeBucket, "timeBucket must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_consumed")
        public TotalGrantedStage totalConsumed(double totalConsumed) {
            this.totalConsumed = totalConsumed;
            return this;
        }

        @java.lang.Override
        @JsonSetter("total_granted")
        public TransactionCountStage totalGranted(double totalGranted) {
            this.totalGranted = totalGranted;
            return this;
        }

        @java.lang.Override
        @JsonSetter("transaction_count")
        public UsageCountStage transactionCount(int transactionCount) {
            this.transactionCount = transactionCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("usage_count")
        public ZeroedOutCountStage usageCount(int usageCount) {
            this.usageCount = usageCount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("zeroed_out_count")
        public _FinalStage zeroedOutCount(int zeroedOutCount) {
            this.zeroedOutCount = zeroedOutCount;
            return this;
        }

        @java.lang.Override
        public _FinalStage featureId(String featureId) {
            this.featureId = Optional.ofNullable(featureId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature_id", nulls = Nulls.SKIP)
        public _FinalStage featureId(Optional<String> featureId) {
            this.featureId = featureId;
            return this;
        }

        @java.lang.Override
        public _FinalStage feature(FeatureLedgerResponseData feature) {
            this.feature = Optional.ofNullable(feature);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "feature", nulls = Nulls.SKIP)
        public _FinalStage feature(Optional<FeatureLedgerResponseData> feature) {
            this.feature = feature;
            return this;
        }

        @java.lang.Override
        public _FinalStage credit(BillingCreditLedgerResponseData credit) {
            this.credit = Optional.ofNullable(credit);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit", nulls = Nulls.SKIP)
        public _FinalStage credit(Optional<BillingCreditLedgerResponseData> credit) {
            this.credit = credit;
            return this;
        }

        @java.lang.Override
        public _FinalStage company(CompanyLedgerResponseData company) {
            this.company = Optional.ofNullable(company);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company", nulls = Nulls.SKIP)
        public _FinalStage company(Optional<CompanyLedgerResponseData> company) {
            this.company = company;
            return this;
        }

        @java.lang.Override
        public CreditLedgerEnrichedEntryResponseData build() {
            return new CreditLedgerEnrichedEntryResponseData(
                    billingCreditId,
                    company,
                    companyId,
                    credit,
                    expiredGrantCount,
                    feature,
                    featureId,
                    firstTransactionAt,
                    freeGrantCount,
                    grantCount,
                    lastTransactionAt,
                    manuallyZeroedCount,
                    netChange,
                    planGrantCount,
                    purchasedGrantCount,
                    timeBucket,
                    totalConsumed,
                    totalGranted,
                    transactionCount,
                    usageCount,
                    zeroedOutCount,
                    additionalProperties);
        }
    }
}
