/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = CrmDealResponseData.Builder.class)
public final class CrmDealResponseData {
    private final String accountId;

    private final String arr;

    private final Optional<String> companyExternalId;

    private final OffsetDateTime createdAt;

    private final String dealExternalId;

    private final String dealId;

    private final String environmentId;

    private final String mrr;

    private final Optional<String> name;

    private final Optional<String> productExternalId;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private CrmDealResponseData(
            String accountId,
            String arr,
            Optional<String> companyExternalId,
            OffsetDateTime createdAt,
            String dealExternalId,
            String dealId,
            String environmentId,
            String mrr,
            Optional<String> name,
            Optional<String> productExternalId,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.arr = arr;
        this.companyExternalId = companyExternalId;
        this.createdAt = createdAt;
        this.dealExternalId = dealExternalId;
        this.dealId = dealId;
        this.environmentId = environmentId;
        this.mrr = mrr;
        this.name = name;
        this.productExternalId = productExternalId;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("arr")
    public String getArr() {
        return arr;
    }

    @JsonProperty("company_external_id")
    public Optional<String> getCompanyExternalId() {
        return companyExternalId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("deal_external_id")
    public String getDealExternalId() {
        return dealExternalId;
    }

    @JsonProperty("deal_id")
    public String getDealId() {
        return dealId;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("mrr")
    public String getMrr() {
        return mrr;
    }

    @JsonProperty("name")
    public Optional<String> getName() {
        return name;
    }

    @JsonProperty("product_external_id")
    public Optional<String> getProductExternalId() {
        return productExternalId;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof CrmDealResponseData && equalTo((CrmDealResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(CrmDealResponseData other) {
        return accountId.equals(other.accountId)
                && arr.equals(other.arr)
                && companyExternalId.equals(other.companyExternalId)
                && createdAt.equals(other.createdAt)
                && dealExternalId.equals(other.dealExternalId)
                && dealId.equals(other.dealId)
                && environmentId.equals(other.environmentId)
                && mrr.equals(other.mrr)
                && name.equals(other.name)
                && productExternalId.equals(other.productExternalId)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.arr,
                this.companyExternalId,
                this.createdAt,
                this.dealExternalId,
                this.dealId,
                this.environmentId,
                this.mrr,
                this.name,
                this.productExternalId,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        ArrStage accountId(@NotNull String accountId);

        Builder from(CrmDealResponseData other);
    }

    public interface ArrStage {
        CreatedAtStage arr(@NotNull String arr);
    }

    public interface CreatedAtStage {
        DealExternalIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface DealExternalIdStage {
        DealIdStage dealExternalId(@NotNull String dealExternalId);
    }

    public interface DealIdStage {
        EnvironmentIdStage dealId(@NotNull String dealId);
    }

    public interface EnvironmentIdStage {
        MrrStage environmentId(@NotNull String environmentId);
    }

    public interface MrrStage {
        UpdatedAtStage mrr(@NotNull String mrr);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        CrmDealResponseData build();

        _FinalStage companyExternalId(Optional<String> companyExternalId);

        _FinalStage companyExternalId(String companyExternalId);

        _FinalStage name(Optional<String> name);

        _FinalStage name(String name);

        _FinalStage productExternalId(Optional<String> productExternalId);

        _FinalStage productExternalId(String productExternalId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    ArrStage,
                    CreatedAtStage,
                    DealExternalIdStage,
                    DealIdStage,
                    EnvironmentIdStage,
                    MrrStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String accountId;

        private String arr;

        private OffsetDateTime createdAt;

        private String dealExternalId;

        private String dealId;

        private String environmentId;

        private String mrr;

        private OffsetDateTime updatedAt;

        private Optional<String> productExternalId = Optional.empty();

        private Optional<String> name = Optional.empty();

        private Optional<String> companyExternalId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(CrmDealResponseData other) {
            accountId(other.getAccountId());
            arr(other.getArr());
            companyExternalId(other.getCompanyExternalId());
            createdAt(other.getCreatedAt());
            dealExternalId(other.getDealExternalId());
            dealId(other.getDealId());
            environmentId(other.getEnvironmentId());
            mrr(other.getMrr());
            name(other.getName());
            productExternalId(other.getProductExternalId());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public ArrStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("arr")
        public CreatedAtStage arr(@NotNull String arr) {
            this.arr = Objects.requireNonNull(arr, "arr must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public DealExternalIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("deal_external_id")
        public DealIdStage dealExternalId(@NotNull String dealExternalId) {
            this.dealExternalId = Objects.requireNonNull(dealExternalId, "dealExternalId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("deal_id")
        public EnvironmentIdStage dealId(@NotNull String dealId) {
            this.dealId = Objects.requireNonNull(dealId, "dealId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public MrrStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("mrr")
        public UpdatedAtStage mrr(@NotNull String mrr) {
            this.mrr = Objects.requireNonNull(mrr, "mrr must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage productExternalId(String productExternalId) {
            this.productExternalId = Optional.ofNullable(productExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "product_external_id", nulls = Nulls.SKIP)
        public _FinalStage productExternalId(Optional<String> productExternalId) {
            this.productExternalId = productExternalId;
            return this;
        }

        @java.lang.Override
        public _FinalStage name(String name) {
            this.name = Optional.ofNullable(name);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "name", nulls = Nulls.SKIP)
        public _FinalStage name(Optional<String> name) {
            this.name = name;
            return this;
        }

        @java.lang.Override
        public _FinalStage companyExternalId(String companyExternalId) {
            this.companyExternalId = Optional.ofNullable(companyExternalId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "company_external_id", nulls = Nulls.SKIP)
        public _FinalStage companyExternalId(Optional<String> companyExternalId) {
            this.companyExternalId = companyExternalId;
            return this;
        }

        @java.lang.Override
        public CrmDealResponseData build() {
            return new CrmDealResponseData(
                    accountId,
                    arr,
                    companyExternalId,
                    createdAt,
                    dealExternalId,
                    dealId,
                    environmentId,
                    mrr,
                    name,
                    productExternalId,
                    updatedAt,
                    additionalProperties);
        }
    }
}
