/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = EntitlementsInPlan.Builder.class)
public final class EntitlementsInPlan {
    private final String entitlementId;

    private final Optional<Boolean> visible;

    private final Map<String, Object> additionalProperties;

    private EntitlementsInPlan(
            String entitlementId, Optional<Boolean> visible, Map<String, Object> additionalProperties) {
        this.entitlementId = entitlementId;
        this.visible = visible;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("entitlement_id")
    public String getEntitlementId() {
        return entitlementId;
    }

    @JsonProperty("visible")
    public Optional<Boolean> getVisible() {
        return visible;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EntitlementsInPlan && equalTo((EntitlementsInPlan) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntitlementsInPlan other) {
        return entitlementId.equals(other.entitlementId) && visible.equals(other.visible);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.entitlementId, this.visible);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntitlementIdStage builder() {
        return new Builder();
    }

    public interface EntitlementIdStage {
        _FinalStage entitlementId(@NotNull String entitlementId);

        Builder from(EntitlementsInPlan other);
    }

    public interface _FinalStage {
        EntitlementsInPlan build();

        _FinalStage visible(Optional<Boolean> visible);

        _FinalStage visible(Boolean visible);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements EntitlementIdStage, _FinalStage {
        private String entitlementId;

        private Optional<Boolean> visible = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(EntitlementsInPlan other) {
            entitlementId(other.getEntitlementId());
            visible(other.getVisible());
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_id")
        public _FinalStage entitlementId(@NotNull String entitlementId) {
            this.entitlementId = Objects.requireNonNull(entitlementId, "entitlementId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage visible(Boolean visible) {
            this.visible = Optional.ofNullable(visible);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "visible", nulls = Nulls.SKIP)
        public _FinalStage visible(Optional<Boolean> visible) {
            this.visible = visible;
            return this;
        }

        @java.lang.Override
        public EntitlementsInPlan build() {
            return new EntitlementsInPlan(entitlementId, visible, additionalProperties);
        }
    }
}
