/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = EntityKeyDefinitionResponseData.Builder.class)
public final class EntityKeyDefinitionResponseData {
    private final OffsetDateTime createdAt;

    private final String entityType;

    private final String id;

    private final String key;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private EntityKeyDefinitionResponseData(
            OffsetDateTime createdAt,
            String entityType,
            String id,
            String key,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.createdAt = createdAt;
        this.entityType = entityType;
        this.id = id;
        this.key = key;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("entity_type")
    public String getEntityType() {
        return entityType;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("key")
    public String getKey() {
        return key;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof EntityKeyDefinitionResponseData && equalTo((EntityKeyDefinitionResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(EntityKeyDefinitionResponseData other) {
        return createdAt.equals(other.createdAt)
                && entityType.equals(other.entityType)
                && id.equals(other.id)
                && key.equals(other.key)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.createdAt, this.entityType, this.id, this.key, this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CreatedAtStage builder() {
        return new Builder();
    }

    public interface CreatedAtStage {
        EntityTypeStage createdAt(@NotNull OffsetDateTime createdAt);

        Builder from(EntityKeyDefinitionResponseData other);
    }

    public interface EntityTypeStage {
        IdStage entityType(@NotNull String entityType);
    }

    public interface IdStage {
        KeyStage id(@NotNull String id);
    }

    public interface KeyStage {
        UpdatedAtStage key(@NotNull String key);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        EntityKeyDefinitionResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements CreatedAtStage, EntityTypeStage, IdStage, KeyStage, UpdatedAtStage, _FinalStage {
        private OffsetDateTime createdAt;

        private String entityType;

        private String id;

        private String key;

        private OffsetDateTime updatedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(EntityKeyDefinitionResponseData other) {
            createdAt(other.getCreatedAt());
            entityType(other.getEntityType());
            id(other.getId());
            key(other.getKey());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EntityTypeStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entity_type")
        public IdStage entityType(@NotNull String entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public KeyStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("key")
        public UpdatedAtStage key(@NotNull String key) {
            this.key = Objects.requireNonNull(key, "key must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public EntityKeyDefinitionResponseData build() {
            return new EntityKeyDefinitionResponseData(createdAt, entityType, id, key, updatedAt, additionalProperties);
        }
    }
}
