/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = FeatureUsageDataResponseData.Builder.class)
public final class FeatureUsageDataResponseData {
    private final Optional<String> creditTypeId;

    private final Optional<CreditUsageResponseData> creditUsage;

    private final String entitlementSource;

    private final String entitlementValueType;

    private final String featureId;

    private final String featureName;

    private final String featureType;

    private final String hardLimit;

    private final boolean hasAccess;

    private final Optional<OffsetDateTime> metricResetAt;

    private final Optional<BillingPriceView> monthlyUsageBasedPrice;

    private final Optional<String> priceBehavior;

    private final String softLimit;

    private final String usage;

    private final Optional<Integer> valueNumeric;

    private final Optional<BillingPriceView> yearlyUsageBasedPrice;

    private final Map<String, Object> additionalProperties;

    private FeatureUsageDataResponseData(
            Optional<String> creditTypeId,
            Optional<CreditUsageResponseData> creditUsage,
            String entitlementSource,
            String entitlementValueType,
            String featureId,
            String featureName,
            String featureType,
            String hardLimit,
            boolean hasAccess,
            Optional<OffsetDateTime> metricResetAt,
            Optional<BillingPriceView> monthlyUsageBasedPrice,
            Optional<String> priceBehavior,
            String softLimit,
            String usage,
            Optional<Integer> valueNumeric,
            Optional<BillingPriceView> yearlyUsageBasedPrice,
            Map<String, Object> additionalProperties) {
        this.creditTypeId = creditTypeId;
        this.creditUsage = creditUsage;
        this.entitlementSource = entitlementSource;
        this.entitlementValueType = entitlementValueType;
        this.featureId = featureId;
        this.featureName = featureName;
        this.featureType = featureType;
        this.hardLimit = hardLimit;
        this.hasAccess = hasAccess;
        this.metricResetAt = metricResetAt;
        this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
        this.priceBehavior = priceBehavior;
        this.softLimit = softLimit;
        this.usage = usage;
        this.valueNumeric = valueNumeric;
        this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("credit_type_id")
    public Optional<String> getCreditTypeId() {
        return creditTypeId;
    }

    @JsonProperty("credit_usage")
    public Optional<CreditUsageResponseData> getCreditUsage() {
        return creditUsage;
    }

    @JsonProperty("entitlement_source")
    public String getEntitlementSource() {
        return entitlementSource;
    }

    @JsonProperty("entitlement_value_type")
    public String getEntitlementValueType() {
        return entitlementValueType;
    }

    @JsonProperty("feature_id")
    public String getFeatureId() {
        return featureId;
    }

    @JsonProperty("feature_name")
    public String getFeatureName() {
        return featureName;
    }

    @JsonProperty("feature_type")
    public String getFeatureType() {
        return featureType;
    }

    @JsonProperty("hard_limit")
    public String getHardLimit() {
        return hardLimit;
    }

    @JsonProperty("has_access")
    public boolean getHasAccess() {
        return hasAccess;
    }

    @JsonProperty("metric_reset_at")
    public Optional<OffsetDateTime> getMetricResetAt() {
        return metricResetAt;
    }

    @JsonProperty("monthly_usage_based_price")
    public Optional<BillingPriceView> getMonthlyUsageBasedPrice() {
        return monthlyUsageBasedPrice;
    }

    @JsonProperty("price_behavior")
    public Optional<String> getPriceBehavior() {
        return priceBehavior;
    }

    @JsonProperty("soft_limit")
    public String getSoftLimit() {
        return softLimit;
    }

    @JsonProperty("usage")
    public String getUsage() {
        return usage;
    }

    @JsonProperty("value_numeric")
    public Optional<Integer> getValueNumeric() {
        return valueNumeric;
    }

    @JsonProperty("yearly_usage_based_price")
    public Optional<BillingPriceView> getYearlyUsageBasedPrice() {
        return yearlyUsageBasedPrice;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof FeatureUsageDataResponseData && equalTo((FeatureUsageDataResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(FeatureUsageDataResponseData other) {
        return creditTypeId.equals(other.creditTypeId)
                && creditUsage.equals(other.creditUsage)
                && entitlementSource.equals(other.entitlementSource)
                && entitlementValueType.equals(other.entitlementValueType)
                && featureId.equals(other.featureId)
                && featureName.equals(other.featureName)
                && featureType.equals(other.featureType)
                && hardLimit.equals(other.hardLimit)
                && hasAccess == other.hasAccess
                && metricResetAt.equals(other.metricResetAt)
                && monthlyUsageBasedPrice.equals(other.monthlyUsageBasedPrice)
                && priceBehavior.equals(other.priceBehavior)
                && softLimit.equals(other.softLimit)
                && usage.equals(other.usage)
                && valueNumeric.equals(other.valueNumeric)
                && yearlyUsageBasedPrice.equals(other.yearlyUsageBasedPrice);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.creditTypeId,
                this.creditUsage,
                this.entitlementSource,
                this.entitlementValueType,
                this.featureId,
                this.featureName,
                this.featureType,
                this.hardLimit,
                this.hasAccess,
                this.metricResetAt,
                this.monthlyUsageBasedPrice,
                this.priceBehavior,
                this.softLimit,
                this.usage,
                this.valueNumeric,
                this.yearlyUsageBasedPrice);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static EntitlementSourceStage builder() {
        return new Builder();
    }

    public interface EntitlementSourceStage {
        EntitlementValueTypeStage entitlementSource(@NotNull String entitlementSource);

        Builder from(FeatureUsageDataResponseData other);
    }

    public interface EntitlementValueTypeStage {
        FeatureIdStage entitlementValueType(@NotNull String entitlementValueType);
    }

    public interface FeatureIdStage {
        FeatureNameStage featureId(@NotNull String featureId);
    }

    public interface FeatureNameStage {
        FeatureTypeStage featureName(@NotNull String featureName);
    }

    public interface FeatureTypeStage {
        HardLimitStage featureType(@NotNull String featureType);
    }

    public interface HardLimitStage {
        HasAccessStage hardLimit(@NotNull String hardLimit);
    }

    public interface HasAccessStage {
        SoftLimitStage hasAccess(boolean hasAccess);
    }

    public interface SoftLimitStage {
        UsageStage softLimit(@NotNull String softLimit);
    }

    public interface UsageStage {
        _FinalStage usage(@NotNull String usage);
    }

    public interface _FinalStage {
        FeatureUsageDataResponseData build();

        _FinalStage creditTypeId(Optional<String> creditTypeId);

        _FinalStage creditTypeId(String creditTypeId);

        _FinalStage creditUsage(Optional<CreditUsageResponseData> creditUsage);

        _FinalStage creditUsage(CreditUsageResponseData creditUsage);

        _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt);

        _FinalStage metricResetAt(OffsetDateTime metricResetAt);

        _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice);

        _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice);

        _FinalStage priceBehavior(Optional<String> priceBehavior);

        _FinalStage priceBehavior(String priceBehavior);

        _FinalStage valueNumeric(Optional<Integer> valueNumeric);

        _FinalStage valueNumeric(Integer valueNumeric);

        _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice);

        _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements EntitlementSourceStage,
                    EntitlementValueTypeStage,
                    FeatureIdStage,
                    FeatureNameStage,
                    FeatureTypeStage,
                    HardLimitStage,
                    HasAccessStage,
                    SoftLimitStage,
                    UsageStage,
                    _FinalStage {
        private String entitlementSource;

        private String entitlementValueType;

        private String featureId;

        private String featureName;

        private String featureType;

        private String hardLimit;

        private boolean hasAccess;

        private String softLimit;

        private String usage;

        private Optional<BillingPriceView> yearlyUsageBasedPrice = Optional.empty();

        private Optional<Integer> valueNumeric = Optional.empty();

        private Optional<String> priceBehavior = Optional.empty();

        private Optional<BillingPriceView> monthlyUsageBasedPrice = Optional.empty();

        private Optional<OffsetDateTime> metricResetAt = Optional.empty();

        private Optional<CreditUsageResponseData> creditUsage = Optional.empty();

        private Optional<String> creditTypeId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(FeatureUsageDataResponseData other) {
            creditTypeId(other.getCreditTypeId());
            creditUsage(other.getCreditUsage());
            entitlementSource(other.getEntitlementSource());
            entitlementValueType(other.getEntitlementValueType());
            featureId(other.getFeatureId());
            featureName(other.getFeatureName());
            featureType(other.getFeatureType());
            hardLimit(other.getHardLimit());
            hasAccess(other.getHasAccess());
            metricResetAt(other.getMetricResetAt());
            monthlyUsageBasedPrice(other.getMonthlyUsageBasedPrice());
            priceBehavior(other.getPriceBehavior());
            softLimit(other.getSoftLimit());
            usage(other.getUsage());
            valueNumeric(other.getValueNumeric());
            yearlyUsageBasedPrice(other.getYearlyUsageBasedPrice());
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_source")
        public EntitlementValueTypeStage entitlementSource(@NotNull String entitlementSource) {
            this.entitlementSource = Objects.requireNonNull(entitlementSource, "entitlementSource must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entitlement_value_type")
        public FeatureIdStage entitlementValueType(@NotNull String entitlementValueType) {
            this.entitlementValueType =
                    Objects.requireNonNull(entitlementValueType, "entitlementValueType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_id")
        public FeatureNameStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_name")
        public FeatureTypeStage featureName(@NotNull String featureName) {
            this.featureName = Objects.requireNonNull(featureName, "featureName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_type")
        public HardLimitStage featureType(@NotNull String featureType) {
            this.featureType = Objects.requireNonNull(featureType, "featureType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("hard_limit")
        public HasAccessStage hardLimit(@NotNull String hardLimit) {
            this.hardLimit = Objects.requireNonNull(hardLimit, "hardLimit must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("has_access")
        public SoftLimitStage hasAccess(boolean hasAccess) {
            this.hasAccess = hasAccess;
            return this;
        }

        @java.lang.Override
        @JsonSetter("soft_limit")
        public UsageStage softLimit(@NotNull String softLimit) {
            this.softLimit = Objects.requireNonNull(softLimit, "softLimit must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("usage")
        public _FinalStage usage(@NotNull String usage) {
            this.usage = Objects.requireNonNull(usage, "usage must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage yearlyUsageBasedPrice(BillingPriceView yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = Optional.ofNullable(yearlyUsageBasedPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "yearly_usage_based_price", nulls = Nulls.SKIP)
        public _FinalStage yearlyUsageBasedPrice(Optional<BillingPriceView> yearlyUsageBasedPrice) {
            this.yearlyUsageBasedPrice = yearlyUsageBasedPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_numeric", nulls = Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @java.lang.Override
        public _FinalStage priceBehavior(String priceBehavior) {
            this.priceBehavior = Optional.ofNullable(priceBehavior);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_behavior", nulls = Nulls.SKIP)
        public _FinalStage priceBehavior(Optional<String> priceBehavior) {
            this.priceBehavior = priceBehavior;
            return this;
        }

        @java.lang.Override
        public _FinalStage monthlyUsageBasedPrice(BillingPriceView monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = Optional.ofNullable(monthlyUsageBasedPrice);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "monthly_usage_based_price", nulls = Nulls.SKIP)
        public _FinalStage monthlyUsageBasedPrice(Optional<BillingPriceView> monthlyUsageBasedPrice) {
            this.monthlyUsageBasedPrice = monthlyUsageBasedPrice;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricResetAt(OffsetDateTime metricResetAt) {
            this.metricResetAt = Optional.ofNullable(metricResetAt);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_reset_at", nulls = Nulls.SKIP)
        public _FinalStage metricResetAt(Optional<OffsetDateTime> metricResetAt) {
            this.metricResetAt = metricResetAt;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditUsage(CreditUsageResponseData creditUsage) {
            this.creditUsage = Optional.ofNullable(creditUsage);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_usage", nulls = Nulls.SKIP)
        public _FinalStage creditUsage(Optional<CreditUsageResponseData> creditUsage) {
            this.creditUsage = creditUsage;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditTypeId(String creditTypeId) {
            this.creditTypeId = Optional.ofNullable(creditTypeId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_type_id", nulls = Nulls.SKIP)
        public _FinalStage creditTypeId(Optional<String> creditTypeId) {
            this.creditTypeId = creditTypeId;
            return this;
        }

        @java.lang.Override
        public FeatureUsageDataResponseData build() {
            return new FeatureUsageDataResponseData(
                    creditTypeId,
                    creditUsage,
                    entitlementSource,
                    entitlementValueType,
                    featureId,
                    featureName,
                    featureType,
                    hardLimit,
                    hasAccess,
                    metricResetAt,
                    monthlyUsageBasedPrice,
                    priceBehavior,
                    softLimit,
                    usage,
                    valueNumeric,
                    yearlyUsageBasedPrice,
                    additionalProperties);
        }
    }
}
