/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanIssueResponseData.Builder.class)
public final class PlanIssueResponseData {
    private final String code;

    private final String description;

    private final Optional<String> detail;

    private final Optional<String> id;

    private final Map<String, Object> additionalProperties;

    private PlanIssueResponseData(
            String code,
            String description,
            Optional<String> detail,
            Optional<String> id,
            Map<String, Object> additionalProperties) {
        this.code = code;
        this.description = description;
        this.detail = detail;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("code")
    public String getCode() {
        return code;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("detail")
    public Optional<String> getDetail() {
        return detail;
    }

    @JsonProperty("id")
    public Optional<String> getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanIssueResponseData && equalTo((PlanIssueResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanIssueResponseData other) {
        return code.equals(other.code)
                && description.equals(other.description)
                && detail.equals(other.detail)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.code, this.description, this.detail, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static CodeStage builder() {
        return new Builder();
    }

    public interface CodeStage {
        DescriptionStage code(@NotNull String code);

        Builder from(PlanIssueResponseData other);
    }

    public interface DescriptionStage {
        _FinalStage description(@NotNull String description);
    }

    public interface _FinalStage {
        PlanIssueResponseData build();

        _FinalStage detail(Optional<String> detail);

        _FinalStage detail(String detail);

        _FinalStage id(Optional<String> id);

        _FinalStage id(String id);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements CodeStage, DescriptionStage, _FinalStage {
        private String code;

        private String description;

        private Optional<String> id = Optional.empty();

        private Optional<String> detail = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanIssueResponseData other) {
            code(other.getCode());
            description(other.getDescription());
            detail(other.getDetail());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("code")
        public DescriptionStage code(@NotNull String code) {
            this.code = Objects.requireNonNull(code, "code must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public _FinalStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage id(String id) {
            this.id = Optional.ofNullable(id);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "id", nulls = Nulls.SKIP)
        public _FinalStage id(Optional<String> id) {
            this.id = id;
            return this;
        }

        @java.lang.Override
        public _FinalStage detail(String detail) {
            this.detail = Optional.ofNullable(detail);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "detail", nulls = Nulls.SKIP)
        public _FinalStage detail(Optional<String> detail) {
            this.detail = detail;
            return this;
        }

        @java.lang.Override
        public PlanIssueResponseData build() {
            return new PlanIssueResponseData(code, description, detail, id, additionalProperties);
        }
    }
}
