/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanSelection.Builder.class)
public final class PlanSelection {
    private final String planId;

    private final Optional<String> priceId;

    private final Map<String, Object> additionalProperties;

    private PlanSelection(String planId, Optional<String> priceId, Map<String, Object> additionalProperties) {
        this.planId = planId;
        this.priceId = priceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("price_id")
    public Optional<String> getPriceId() {
        return priceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanSelection && equalTo((PlanSelection) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanSelection other) {
        return planId.equals(other.planId) && priceId.equals(other.priceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.planId, this.priceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static PlanIdStage builder() {
        return new Builder();
    }

    public interface PlanIdStage {
        _FinalStage planId(@NotNull String planId);

        Builder from(PlanSelection other);
    }

    public interface _FinalStage {
        PlanSelection build();

        _FinalStage priceId(Optional<String> priceId);

        _FinalStage priceId(String priceId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements PlanIdStage, _FinalStage {
        private String planId;

        private Optional<String> priceId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanSelection other) {
            planId(other.getPlanId());
            priceId(other.getPriceId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public _FinalStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage priceId(String priceId) {
            this.priceId = Optional.ofNullable(priceId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "price_id", nulls = Nulls.SKIP)
        public _FinalStage priceId(Optional<String> priceId) {
            this.priceId = priceId;
            return this;
        }

        @java.lang.Override
        public PlanSelection build() {
            return new PlanSelection(planId, priceId, additionalProperties);
        }
    }
}
