/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PlanTraitResponseData.Builder.class)
public final class PlanTraitResponseData {
    private final String accountId;

    private final OffsetDateTime createdAt;

    private final String environmentId;

    private final String id;

    private final String planId;

    private final String planType;

    private final String traitId;

    private final String traitValue;

    private final OffsetDateTime updatedAt;

    private final Map<String, Object> additionalProperties;

    private PlanTraitResponseData(
            String accountId,
            OffsetDateTime createdAt,
            String environmentId,
            String id,
            String planId,
            String planType,
            String traitId,
            String traitValue,
            OffsetDateTime updatedAt,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.createdAt = createdAt;
        this.environmentId = environmentId;
        this.id = id;
        this.planId = planId;
        this.planType = planType;
        this.traitId = traitId;
        this.traitValue = traitValue;
        this.updatedAt = updatedAt;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("created_at")
    public OffsetDateTime getCreatedAt() {
        return createdAt;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("plan_id")
    public String getPlanId() {
        return planId;
    }

    @JsonProperty("plan_type")
    public String getPlanType() {
        return planType;
    }

    @JsonProperty("trait_id")
    public String getTraitId() {
        return traitId;
    }

    @JsonProperty("trait_value")
    public String getTraitValue() {
        return traitValue;
    }

    @JsonProperty("updated_at")
    public OffsetDateTime getUpdatedAt() {
        return updatedAt;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PlanTraitResponseData && equalTo((PlanTraitResponseData) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PlanTraitResponseData other) {
        return accountId.equals(other.accountId)
                && createdAt.equals(other.createdAt)
                && environmentId.equals(other.environmentId)
                && id.equals(other.id)
                && planId.equals(other.planId)
                && planType.equals(other.planType)
                && traitId.equals(other.traitId)
                && traitValue.equals(other.traitValue)
                && updatedAt.equals(other.updatedAt);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.createdAt,
                this.environmentId,
                this.id,
                this.planId,
                this.planType,
                this.traitId,
                this.traitValue,
                this.updatedAt);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        CreatedAtStage accountId(@NotNull String accountId);

        Builder from(PlanTraitResponseData other);
    }

    public interface CreatedAtStage {
        EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        PlanIdStage id(@NotNull String id);
    }

    public interface PlanIdStage {
        PlanTypeStage planId(@NotNull String planId);
    }

    public interface PlanTypeStage {
        TraitIdStage planType(@NotNull String planType);
    }

    public interface TraitIdStage {
        TraitValueStage traitId(@NotNull String traitId);
    }

    public interface TraitValueStage {
        UpdatedAtStage traitValue(@NotNull String traitValue);
    }

    public interface UpdatedAtStage {
        _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt);
    }

    public interface _FinalStage {
        PlanTraitResponseData build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    CreatedAtStage,
                    EnvironmentIdStage,
                    IdStage,
                    PlanIdStage,
                    PlanTypeStage,
                    TraitIdStage,
                    TraitValueStage,
                    UpdatedAtStage,
                    _FinalStage {
        private String accountId;

        private OffsetDateTime createdAt;

        private String environmentId;

        private String id;

        private String planId;

        private String planType;

        private String traitId;

        private String traitValue;

        private OffsetDateTime updatedAt;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PlanTraitResponseData other) {
            accountId(other.getAccountId());
            createdAt(other.getCreatedAt());
            environmentId(other.getEnvironmentId());
            id(other.getId());
            planId(other.getPlanId());
            planType(other.getPlanType());
            traitId(other.getTraitId());
            traitValue(other.getTraitValue());
            updatedAt(other.getUpdatedAt());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public CreatedAtStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("created_at")
        public EnvironmentIdStage createdAt(@NotNull OffsetDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public PlanIdStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_id")
        public PlanTypeStage planId(@NotNull String planId) {
            this.planId = Objects.requireNonNull(planId, "planId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("plan_type")
        public TraitIdStage planType(@NotNull String planType) {
            this.planType = Objects.requireNonNull(planType, "planType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_id")
        public TraitValueStage traitId(@NotNull String traitId) {
            this.traitId = Objects.requireNonNull(traitId, "traitId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_value")
        public UpdatedAtStage traitValue(@NotNull String traitValue) {
            this.traitValue = Objects.requireNonNull(traitValue, "traitValue must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("updated_at")
        public _FinalStage updatedAt(@NotNull OffsetDateTime updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt must not be null");
            return this;
        }

        @java.lang.Override
        public PlanTraitResponseData build() {
            return new PlanTraitResponseData(
                    accountId,
                    createdAt,
                    environmentId,
                    id,
                    planId,
                    planType,
                    traitId,
                    traitValue,
                    updatedAt,
                    additionalProperties);
        }
    }
}
