/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = PreviewSubscriptionUpcomingInvoiceLineItems.Builder.class)
public final class PreviewSubscriptionUpcomingInvoiceLineItems {
    private final int amount;

    private final String description;

    private final String priceId;

    private final boolean proration;

    private final int quantity;

    private final Map<String, Object> additionalProperties;

    private PreviewSubscriptionUpcomingInvoiceLineItems(
            int amount,
            String description,
            String priceId,
            boolean proration,
            int quantity,
            Map<String, Object> additionalProperties) {
        this.amount = amount;
        this.description = description;
        this.priceId = priceId;
        this.proration = proration;
        this.quantity = quantity;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("amount")
    public int getAmount() {
        return amount;
    }

    @JsonProperty("description")
    public String getDescription() {
        return description;
    }

    @JsonProperty("price_id")
    public String getPriceId() {
        return priceId;
    }

    @JsonProperty("proration")
    public boolean getProration() {
        return proration;
    }

    @JsonProperty("quantity")
    public int getQuantity() {
        return quantity;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof PreviewSubscriptionUpcomingInvoiceLineItems
                && equalTo((PreviewSubscriptionUpcomingInvoiceLineItems) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(PreviewSubscriptionUpcomingInvoiceLineItems other) {
        return amount == other.amount
                && description.equals(other.description)
                && priceId.equals(other.priceId)
                && proration == other.proration
                && quantity == other.quantity;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.amount, this.description, this.priceId, this.proration, this.quantity);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AmountStage builder() {
        return new Builder();
    }

    public interface AmountStage {
        DescriptionStage amount(int amount);

        Builder from(PreviewSubscriptionUpcomingInvoiceLineItems other);
    }

    public interface DescriptionStage {
        PriceIdStage description(@NotNull String description);
    }

    public interface PriceIdStage {
        ProrationStage priceId(@NotNull String priceId);
    }

    public interface ProrationStage {
        QuantityStage proration(boolean proration);
    }

    public interface QuantityStage {
        _FinalStage quantity(int quantity);
    }

    public interface _FinalStage {
        PreviewSubscriptionUpcomingInvoiceLineItems build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AmountStage, DescriptionStage, PriceIdStage, ProrationStage, QuantityStage, _FinalStage {
        private int amount;

        private String description;

        private String priceId;

        private boolean proration;

        private int quantity;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(PreviewSubscriptionUpcomingInvoiceLineItems other) {
            amount(other.getAmount());
            description(other.getDescription());
            priceId(other.getPriceId());
            proration(other.getProration());
            quantity(other.getQuantity());
            return this;
        }

        @java.lang.Override
        @JsonSetter("amount")
        public DescriptionStage amount(int amount) {
            this.amount = amount;
            return this;
        }

        @java.lang.Override
        @JsonSetter("description")
        public PriceIdStage description(@NotNull String description) {
            this.description = Objects.requireNonNull(description, "description must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_id")
        public ProrationStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("proration")
        public QuantityStage proration(boolean proration) {
            this.proration = proration;
            return this;
        }

        @java.lang.Override
        @JsonSetter("quantity")
        public _FinalStage quantity(int quantity) {
            this.quantity = quantity;
            return this;
        }

        @java.lang.Override
        public PreviewSubscriptionUpcomingInvoiceLineItems build() {
            return new PreviewSubscriptionUpcomingInvoiceLineItems(
                    amount, description, priceId, proration, quantity, additionalProperties);
        }
    }
}
