/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = Rule.Builder.class)
public final class Rule {
    private final String accountId;

    private final List<ConditionGroup> conditionGroups;

    private final List<Condition> conditions;

    private final String environmentId;

    private final Optional<String> flagId;

    private final String id;

    private final String name;

    private final int priority;

    private final String ruleType;

    private final boolean value;

    private final Map<String, Object> additionalProperties;

    private Rule(
            String accountId,
            List<ConditionGroup> conditionGroups,
            List<Condition> conditions,
            String environmentId,
            Optional<String> flagId,
            String id,
            String name,
            int priority,
            String ruleType,
            boolean value,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.conditionGroups = conditionGroups;
        this.conditions = conditions;
        this.environmentId = environmentId;
        this.flagId = flagId;
        this.id = id;
        this.name = name;
        this.priority = priority;
        this.ruleType = ruleType;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public String getAccountId() {
        return accountId;
    }

    @JsonProperty("condition_groups")
    public List<ConditionGroup> getConditionGroups() {
        return conditionGroups;
    }

    @JsonProperty("conditions")
    public List<Condition> getConditions() {
        return conditions;
    }

    @JsonProperty("environment_id")
    public String getEnvironmentId() {
        return environmentId;
    }

    @JsonProperty("flag_id")
    public Optional<String> getFlagId() {
        return flagId;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @JsonProperty("name")
    public String getName() {
        return name;
    }

    @JsonProperty("priority")
    public int getPriority() {
        return priority;
    }

    @JsonProperty("rule_type")
    public String getRuleType() {
        return ruleType;
    }

    @JsonProperty("value")
    public boolean getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof Rule && equalTo((Rule) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(Rule other) {
        return accountId.equals(other.accountId)
                && conditionGroups.equals(other.conditionGroups)
                && conditions.equals(other.conditions)
                && environmentId.equals(other.environmentId)
                && flagId.equals(other.flagId)
                && id.equals(other.id)
                && name.equals(other.name)
                && priority == other.priority
                && ruleType.equals(other.ruleType)
                && value == other.value;
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId,
                this.conditionGroups,
                this.conditions,
                this.environmentId,
                this.flagId,
                this.id,
                this.name,
                this.priority,
                this.ruleType,
                this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AccountIdStage builder() {
        return new Builder();
    }

    public interface AccountIdStage {
        EnvironmentIdStage accountId(@NotNull String accountId);

        Builder from(Rule other);
    }

    public interface EnvironmentIdStage {
        IdStage environmentId(@NotNull String environmentId);
    }

    public interface IdStage {
        NameStage id(@NotNull String id);
    }

    public interface NameStage {
        PriorityStage name(@NotNull String name);
    }

    public interface PriorityStage {
        RuleTypeStage priority(int priority);
    }

    public interface RuleTypeStage {
        ValueStage ruleType(@NotNull String ruleType);
    }

    public interface ValueStage {
        _FinalStage value(boolean value);
    }

    public interface _FinalStage {
        Rule build();

        _FinalStage conditionGroups(List<ConditionGroup> conditionGroups);

        _FinalStage addConditionGroups(ConditionGroup conditionGroups);

        _FinalStage addAllConditionGroups(List<ConditionGroup> conditionGroups);

        _FinalStage conditions(List<Condition> conditions);

        _FinalStage addConditions(Condition conditions);

        _FinalStage addAllConditions(List<Condition> conditions);

        _FinalStage flagId(Optional<String> flagId);

        _FinalStage flagId(String flagId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements AccountIdStage,
                    EnvironmentIdStage,
                    IdStage,
                    NameStage,
                    PriorityStage,
                    RuleTypeStage,
                    ValueStage,
                    _FinalStage {
        private String accountId;

        private String environmentId;

        private String id;

        private String name;

        private int priority;

        private String ruleType;

        private boolean value;

        private Optional<String> flagId = Optional.empty();

        private List<Condition> conditions = new ArrayList<>();

        private List<ConditionGroup> conditionGroups = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(Rule other) {
            accountId(other.getAccountId());
            conditionGroups(other.getConditionGroups());
            conditions(other.getConditions());
            environmentId(other.getEnvironmentId());
            flagId(other.getFlagId());
            id(other.getId());
            name(other.getName());
            priority(other.getPriority());
            ruleType(other.getRuleType());
            value(other.getValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("account_id")
        public EnvironmentIdStage accountId(@NotNull String accountId) {
            this.accountId = Objects.requireNonNull(accountId, "accountId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("environment_id")
        public IdStage environmentId(@NotNull String environmentId) {
            this.environmentId = Objects.requireNonNull(environmentId, "environmentId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public NameStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("name")
        public PriorityStage name(@NotNull String name) {
            this.name = Objects.requireNonNull(name, "name must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("priority")
        public RuleTypeStage priority(int priority) {
            this.priority = priority;
            return this;
        }

        @java.lang.Override
        @JsonSetter("rule_type")
        public ValueStage ruleType(@NotNull String ruleType) {
            this.ruleType = Objects.requireNonNull(ruleType, "ruleType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(boolean value) {
            this.value = value;
            return this;
        }

        @java.lang.Override
        public _FinalStage flagId(String flagId) {
            this.flagId = Optional.ofNullable(flagId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "flag_id", nulls = Nulls.SKIP)
        public _FinalStage flagId(Optional<String> flagId) {
            this.flagId = flagId;
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditions(List<Condition> conditions) {
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditions(Condition conditions) {
            this.conditions.add(conditions);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "conditions", nulls = Nulls.SKIP)
        public _FinalStage conditions(List<Condition> conditions) {
            this.conditions.clear();
            if (conditions != null) {
                this.conditions.addAll(conditions);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllConditionGroups(List<ConditionGroup> conditionGroups) {
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addConditionGroups(ConditionGroup conditionGroups) {
            this.conditionGroups.add(conditionGroups);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "condition_groups", nulls = Nulls.SKIP)
        public _FinalStage conditionGroups(List<ConditionGroup> conditionGroups) {
            this.conditionGroups.clear();
            if (conditionGroups != null) {
                this.conditionGroups.addAll(conditionGroups);
            }
            return this;
        }

        @java.lang.Override
        public Rule build() {
            return new Rule(
                    accountId,
                    conditionGroups,
                    conditions,
                    environmentId,
                    flagId,
                    id,
                    name,
                    priority,
                    ruleType,
                    value,
                    additionalProperties);
        }
    }
}
