/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = StripeEmbedInfo.Builder.class)
public final class StripeEmbedInfo {
    private final Optional<String> accountId;

    private final Optional<String> publishableKey;

    private final String schematicPublishableKey;

    private final Optional<String> setupIntentClientSecret;

    private final Map<String, Object> additionalProperties;

    private StripeEmbedInfo(
            Optional<String> accountId,
            Optional<String> publishableKey,
            String schematicPublishableKey,
            Optional<String> setupIntentClientSecret,
            Map<String, Object> additionalProperties) {
        this.accountId = accountId;
        this.publishableKey = publishableKey;
        this.schematicPublishableKey = schematicPublishableKey;
        this.setupIntentClientSecret = setupIntentClientSecret;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("account_id")
    public Optional<String> getAccountId() {
        return accountId;
    }

    @JsonProperty("publishable_key")
    public Optional<String> getPublishableKey() {
        return publishableKey;
    }

    @JsonProperty("schematic_publishable_key")
    public String getSchematicPublishableKey() {
        return schematicPublishableKey;
    }

    @JsonProperty("setup_intent_client_secret")
    public Optional<String> getSetupIntentClientSecret() {
        return setupIntentClientSecret;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof StripeEmbedInfo && equalTo((StripeEmbedInfo) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(StripeEmbedInfo other) {
        return accountId.equals(other.accountId)
                && publishableKey.equals(other.publishableKey)
                && schematicPublishableKey.equals(other.schematicPublishableKey)
                && setupIntentClientSecret.equals(other.setupIntentClientSecret);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.accountId, this.publishableKey, this.schematicPublishableKey, this.setupIntentClientSecret);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static SchematicPublishableKeyStage builder() {
        return new Builder();
    }

    public interface SchematicPublishableKeyStage {
        _FinalStage schematicPublishableKey(@NotNull String schematicPublishableKey);

        Builder from(StripeEmbedInfo other);
    }

    public interface _FinalStage {
        StripeEmbedInfo build();

        _FinalStage accountId(Optional<String> accountId);

        _FinalStage accountId(String accountId);

        _FinalStage publishableKey(Optional<String> publishableKey);

        _FinalStage publishableKey(String publishableKey);

        _FinalStage setupIntentClientSecret(Optional<String> setupIntentClientSecret);

        _FinalStage setupIntentClientSecret(String setupIntentClientSecret);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements SchematicPublishableKeyStage, _FinalStage {
        private String schematicPublishableKey;

        private Optional<String> setupIntentClientSecret = Optional.empty();

        private Optional<String> publishableKey = Optional.empty();

        private Optional<String> accountId = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(StripeEmbedInfo other) {
            accountId(other.getAccountId());
            publishableKey(other.getPublishableKey());
            schematicPublishableKey(other.getSchematicPublishableKey());
            setupIntentClientSecret(other.getSetupIntentClientSecret());
            return this;
        }

        @java.lang.Override
        @JsonSetter("schematic_publishable_key")
        public _FinalStage schematicPublishableKey(@NotNull String schematicPublishableKey) {
            this.schematicPublishableKey =
                    Objects.requireNonNull(schematicPublishableKey, "schematicPublishableKey must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage setupIntentClientSecret(String setupIntentClientSecret) {
            this.setupIntentClientSecret = Optional.ofNullable(setupIntentClientSecret);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "setup_intent_client_secret", nulls = Nulls.SKIP)
        public _FinalStage setupIntentClientSecret(Optional<String> setupIntentClientSecret) {
            this.setupIntentClientSecret = setupIntentClientSecret;
            return this;
        }

        @java.lang.Override
        public _FinalStage publishableKey(String publishableKey) {
            this.publishableKey = Optional.ofNullable(publishableKey);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "publishable_key", nulls = Nulls.SKIP)
        public _FinalStage publishableKey(Optional<String> publishableKey) {
            this.publishableKey = publishableKey;
            return this;
        }

        @java.lang.Override
        public _FinalStage accountId(String accountId) {
            this.accountId = Optional.ofNullable(accountId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "account_id", nulls = Nulls.SKIP)
        public _FinalStage accountId(Optional<String> accountId) {
            this.accountId = accountId;
            return this;
        }

        @java.lang.Override
        public StripeEmbedInfo build() {
            return new StripeEmbedInfo(
                    accountId, publishableKey, schematicPublishableKey, setupIntentClientSecret, additionalProperties);
        }
    }
}
