/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = SubscriptionTraitUpdate.Builder.class)
public final class SubscriptionTraitUpdate {
    private final String featureId;

    private final List<String> hierarchy;

    private final String reason;

    private final String traitId;

    private final String traitName;

    private final String traitType;

    private final String value;

    private final Map<String, Object> additionalProperties;

    private SubscriptionTraitUpdate(
            String featureId,
            List<String> hierarchy,
            String reason,
            String traitId,
            String traitName,
            String traitType,
            String value,
            Map<String, Object> additionalProperties) {
        this.featureId = featureId;
        this.hierarchy = hierarchy;
        this.reason = reason;
        this.traitId = traitId;
        this.traitName = traitName;
        this.traitType = traitType;
        this.value = value;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("feature_id")
    public String getFeatureId() {
        return featureId;
    }

    @JsonProperty("hierarchy")
    public List<String> getHierarchy() {
        return hierarchy;
    }

    @JsonProperty("reason")
    public String getReason() {
        return reason;
    }

    @JsonProperty("trait_id")
    public String getTraitId() {
        return traitId;
    }

    @JsonProperty("trait_name")
    public String getTraitName() {
        return traitName;
    }

    @JsonProperty("trait_type")
    public String getTraitType() {
        return traitType;
    }

    @JsonProperty("value")
    public String getValue() {
        return value;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof SubscriptionTraitUpdate && equalTo((SubscriptionTraitUpdate) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(SubscriptionTraitUpdate other) {
        return featureId.equals(other.featureId)
                && hierarchy.equals(other.hierarchy)
                && reason.equals(other.reason)
                && traitId.equals(other.traitId)
                && traitName.equals(other.traitName)
                && traitType.equals(other.traitType)
                && value.equals(other.value);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.featureId, this.hierarchy, this.reason, this.traitId, this.traitName, this.traitType, this.value);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static FeatureIdStage builder() {
        return new Builder();
    }

    public interface FeatureIdStage {
        ReasonStage featureId(@NotNull String featureId);

        Builder from(SubscriptionTraitUpdate other);
    }

    public interface ReasonStage {
        TraitIdStage reason(@NotNull String reason);
    }

    public interface TraitIdStage {
        TraitNameStage traitId(@NotNull String traitId);
    }

    public interface TraitNameStage {
        TraitTypeStage traitName(@NotNull String traitName);
    }

    public interface TraitTypeStage {
        ValueStage traitType(@NotNull String traitType);
    }

    public interface ValueStage {
        _FinalStage value(@NotNull String value);
    }

    public interface _FinalStage {
        SubscriptionTraitUpdate build();

        _FinalStage hierarchy(List<String> hierarchy);

        _FinalStage addHierarchy(String hierarchy);

        _FinalStage addAllHierarchy(List<String> hierarchy);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder
            implements FeatureIdStage,
                    ReasonStage,
                    TraitIdStage,
                    TraitNameStage,
                    TraitTypeStage,
                    ValueStage,
                    _FinalStage {
        private String featureId;

        private String reason;

        private String traitId;

        private String traitName;

        private String traitType;

        private String value;

        private List<String> hierarchy = new ArrayList<>();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(SubscriptionTraitUpdate other) {
            featureId(other.getFeatureId());
            hierarchy(other.getHierarchy());
            reason(other.getReason());
            traitId(other.getTraitId());
            traitName(other.getTraitName());
            traitType(other.getTraitType());
            value(other.getValue());
            return this;
        }

        @java.lang.Override
        @JsonSetter("feature_id")
        public ReasonStage featureId(@NotNull String featureId) {
            this.featureId = Objects.requireNonNull(featureId, "featureId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("reason")
        public TraitIdStage reason(@NotNull String reason) {
            this.reason = Objects.requireNonNull(reason, "reason must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_id")
        public TraitNameStage traitId(@NotNull String traitId) {
            this.traitId = Objects.requireNonNull(traitId, "traitId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_name")
        public TraitTypeStage traitName(@NotNull String traitName) {
            this.traitName = Objects.requireNonNull(traitName, "traitName must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("trait_type")
        public ValueStage traitType(@NotNull String traitType) {
            this.traitType = Objects.requireNonNull(traitType, "traitType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("value")
        public _FinalStage value(@NotNull String value) {
            this.value = Objects.requireNonNull(value, "value must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage addAllHierarchy(List<String> hierarchy) {
            if (hierarchy != null) {
                this.hierarchy.addAll(hierarchy);
            }
            return this;
        }

        @java.lang.Override
        public _FinalStage addHierarchy(String hierarchy) {
            this.hierarchy.add(hierarchy);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "hierarchy", nulls = Nulls.SKIP)
        public _FinalStage hierarchy(List<String> hierarchy) {
            this.hierarchy.clear();
            if (hierarchy != null) {
                this.hierarchy.addAll(hierarchy);
            }
            return this;
        }

        @java.lang.Override
        public SubscriptionTraitUpdate build() {
            return new SubscriptionTraitUpdate(
                    featureId, hierarchy, reason, traitId, traitName, traitType, value, additionalProperties);
        }
    }
}
