/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = TraitDefinition.Builder.class)
public final class TraitDefinition {
    private final String comparableType;

    private final String entityType;

    private final String id;

    private final Map<String, Object> additionalProperties;

    private TraitDefinition(
            String comparableType, String entityType, String id, Map<String, Object> additionalProperties) {
        this.comparableType = comparableType;
        this.entityType = entityType;
        this.id = id;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("comparable_type")
    public String getComparableType() {
        return comparableType;
    }

    @JsonProperty("entity_type")
    public String getEntityType() {
        return entityType;
    }

    @JsonProperty("id")
    public String getId() {
        return id;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof TraitDefinition && equalTo((TraitDefinition) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(TraitDefinition other) {
        return comparableType.equals(other.comparableType)
                && entityType.equals(other.entityType)
                && id.equals(other.id);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.comparableType, this.entityType, this.id);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ComparableTypeStage builder() {
        return new Builder();
    }

    public interface ComparableTypeStage {
        EntityTypeStage comparableType(@NotNull String comparableType);

        Builder from(TraitDefinition other);
    }

    public interface EntityTypeStage {
        IdStage entityType(@NotNull String entityType);
    }

    public interface IdStage {
        _FinalStage id(@NotNull String id);
    }

    public interface _FinalStage {
        TraitDefinition build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ComparableTypeStage, EntityTypeStage, IdStage, _FinalStage {
        private String comparableType;

        private String entityType;

        private String id;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(TraitDefinition other) {
            comparableType(other.getComparableType());
            entityType(other.getEntityType());
            id(other.getId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("comparable_type")
        public EntityTypeStage comparableType(@NotNull String comparableType) {
            this.comparableType = Objects.requireNonNull(comparableType, "comparableType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("entity_type")
        public IdStage entityType(@NotNull String entityType) {
            this.entityType = Objects.requireNonNull(entityType, "entityType must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("id")
        public _FinalStage id(@NotNull String id) {
            this.id = Objects.requireNonNull(id, "id must not be null");
            return this;
        }

        @java.lang.Override
        public TraitDefinition build() {
            return new TraitDefinition(comparableType, entityType, id, additionalProperties);
        }
    }
}
