/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateAddOnRequestBody.Builder.class)
public final class UpdateAddOnRequestBody {
    private final String addOnId;

    private final String priceId;

    private final Map<String, Object> additionalProperties;

    private UpdateAddOnRequestBody(String addOnId, String priceId, Map<String, Object> additionalProperties) {
        this.addOnId = addOnId;
        this.priceId = priceId;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("add_on_id")
    public String getAddOnId() {
        return addOnId;
    }

    @JsonProperty("price_id")
    public String getPriceId() {
        return priceId;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateAddOnRequestBody && equalTo((UpdateAddOnRequestBody) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateAddOnRequestBody other) {
        return addOnId.equals(other.addOnId) && priceId.equals(other.priceId);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(this.addOnId, this.priceId);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static AddOnIdStage builder() {
        return new Builder();
    }

    public interface AddOnIdStage {
        PriceIdStage addOnId(@NotNull String addOnId);

        Builder from(UpdateAddOnRequestBody other);
    }

    public interface PriceIdStage {
        _FinalStage priceId(@NotNull String priceId);
    }

    public interface _FinalStage {
        UpdateAddOnRequestBody build();
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements AddOnIdStage, PriceIdStage, _FinalStage {
        private String addOnId;

        private String priceId;

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateAddOnRequestBody other) {
            addOnId(other.getAddOnId());
            priceId(other.getPriceId());
            return this;
        }

        @java.lang.Override
        @JsonSetter("add_on_id")
        public PriceIdStage addOnId(@NotNull String addOnId) {
            this.addOnId = Objects.requireNonNull(addOnId, "addOnId must not be null");
            return this;
        }

        @java.lang.Override
        @JsonSetter("price_id")
        public _FinalStage priceId(@NotNull String priceId) {
            this.priceId = Objects.requireNonNull(priceId, "priceId must not be null");
            return this;
        }

        @java.lang.Override
        public UpdateAddOnRequestBody build() {
            return new UpdateAddOnRequestBody(addOnId, priceId, additionalProperties);
        }
    }
}
