/**
 * This file was auto-generated by Fern from our API Definition.
 */
package com.schematic.api.types;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.schematic.api.core.ObjectMappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

@JsonInclude(JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder = UpdateEntitlementReqCommon.Builder.class)
public final class UpdateEntitlementReqCommon {
    private final Optional<Double> creditConsumptionRate;

    private final Optional<UpdateEntitlementReqCommonMetricPeriod> metricPeriod;

    private final Optional<UpdateEntitlementReqCommonMetricPeriodMonthReset> metricPeriodMonthReset;

    private final Optional<Boolean> valueBool;

    private final Optional<String> valueCreditId;

    private final Optional<Integer> valueNumeric;

    private final Optional<String> valueTraitId;

    private final UpdateEntitlementReqCommonValueType valueType;

    private final Map<String, Object> additionalProperties;

    private UpdateEntitlementReqCommon(
            Optional<Double> creditConsumptionRate,
            Optional<UpdateEntitlementReqCommonMetricPeriod> metricPeriod,
            Optional<UpdateEntitlementReqCommonMetricPeriodMonthReset> metricPeriodMonthReset,
            Optional<Boolean> valueBool,
            Optional<String> valueCreditId,
            Optional<Integer> valueNumeric,
            Optional<String> valueTraitId,
            UpdateEntitlementReqCommonValueType valueType,
            Map<String, Object> additionalProperties) {
        this.creditConsumptionRate = creditConsumptionRate;
        this.metricPeriod = metricPeriod;
        this.metricPeriodMonthReset = metricPeriodMonthReset;
        this.valueBool = valueBool;
        this.valueCreditId = valueCreditId;
        this.valueNumeric = valueNumeric;
        this.valueTraitId = valueTraitId;
        this.valueType = valueType;
        this.additionalProperties = additionalProperties;
    }

    @JsonProperty("credit_consumption_rate")
    public Optional<Double> getCreditConsumptionRate() {
        return creditConsumptionRate;
    }

    @JsonProperty("metric_period")
    public Optional<UpdateEntitlementReqCommonMetricPeriod> getMetricPeriod() {
        return metricPeriod;
    }

    @JsonProperty("metric_period_month_reset")
    public Optional<UpdateEntitlementReqCommonMetricPeriodMonthReset> getMetricPeriodMonthReset() {
        return metricPeriodMonthReset;
    }

    @JsonProperty("value_bool")
    public Optional<Boolean> getValueBool() {
        return valueBool;
    }

    @JsonProperty("value_credit_id")
    public Optional<String> getValueCreditId() {
        return valueCreditId;
    }

    @JsonProperty("value_numeric")
    public Optional<Integer> getValueNumeric() {
        return valueNumeric;
    }

    @JsonProperty("value_trait_id")
    public Optional<String> getValueTraitId() {
        return valueTraitId;
    }

    @JsonProperty("value_type")
    public UpdateEntitlementReqCommonValueType getValueType() {
        return valueType;
    }

    @java.lang.Override
    public boolean equals(Object other) {
        if (this == other) return true;
        return other instanceof UpdateEntitlementReqCommon && equalTo((UpdateEntitlementReqCommon) other);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    private boolean equalTo(UpdateEntitlementReqCommon other) {
        return creditConsumptionRate.equals(other.creditConsumptionRate)
                && metricPeriod.equals(other.metricPeriod)
                && metricPeriodMonthReset.equals(other.metricPeriodMonthReset)
                && valueBool.equals(other.valueBool)
                && valueCreditId.equals(other.valueCreditId)
                && valueNumeric.equals(other.valueNumeric)
                && valueTraitId.equals(other.valueTraitId)
                && valueType.equals(other.valueType);
    }

    @java.lang.Override
    public int hashCode() {
        return Objects.hash(
                this.creditConsumptionRate,
                this.metricPeriod,
                this.metricPeriodMonthReset,
                this.valueBool,
                this.valueCreditId,
                this.valueNumeric,
                this.valueTraitId,
                this.valueType);
    }

    @java.lang.Override
    public String toString() {
        return ObjectMappers.stringify(this);
    }

    public static ValueTypeStage builder() {
        return new Builder();
    }

    public interface ValueTypeStage {
        _FinalStage valueType(@NotNull UpdateEntitlementReqCommonValueType valueType);

        Builder from(UpdateEntitlementReqCommon other);
    }

    public interface _FinalStage {
        UpdateEntitlementReqCommon build();

        _FinalStage creditConsumptionRate(Optional<Double> creditConsumptionRate);

        _FinalStage creditConsumptionRate(Double creditConsumptionRate);

        _FinalStage metricPeriod(Optional<UpdateEntitlementReqCommonMetricPeriod> metricPeriod);

        _FinalStage metricPeriod(UpdateEntitlementReqCommonMetricPeriod metricPeriod);

        _FinalStage metricPeriodMonthReset(
                Optional<UpdateEntitlementReqCommonMetricPeriodMonthReset> metricPeriodMonthReset);

        _FinalStage metricPeriodMonthReset(UpdateEntitlementReqCommonMetricPeriodMonthReset metricPeriodMonthReset);

        _FinalStage valueBool(Optional<Boolean> valueBool);

        _FinalStage valueBool(Boolean valueBool);

        _FinalStage valueCreditId(Optional<String> valueCreditId);

        _FinalStage valueCreditId(String valueCreditId);

        _FinalStage valueNumeric(Optional<Integer> valueNumeric);

        _FinalStage valueNumeric(Integer valueNumeric);

        _FinalStage valueTraitId(Optional<String> valueTraitId);

        _FinalStage valueTraitId(String valueTraitId);
    }

    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder implements ValueTypeStage, _FinalStage {
        private UpdateEntitlementReqCommonValueType valueType;

        private Optional<String> valueTraitId = Optional.empty();

        private Optional<Integer> valueNumeric = Optional.empty();

        private Optional<String> valueCreditId = Optional.empty();

        private Optional<Boolean> valueBool = Optional.empty();

        private Optional<UpdateEntitlementReqCommonMetricPeriodMonthReset> metricPeriodMonthReset = Optional.empty();

        private Optional<UpdateEntitlementReqCommonMetricPeriod> metricPeriod = Optional.empty();

        private Optional<Double> creditConsumptionRate = Optional.empty();

        @JsonAnySetter
        private Map<String, Object> additionalProperties = new HashMap<>();

        private Builder() {}

        @java.lang.Override
        public Builder from(UpdateEntitlementReqCommon other) {
            creditConsumptionRate(other.getCreditConsumptionRate());
            metricPeriod(other.getMetricPeriod());
            metricPeriodMonthReset(other.getMetricPeriodMonthReset());
            valueBool(other.getValueBool());
            valueCreditId(other.getValueCreditId());
            valueNumeric(other.getValueNumeric());
            valueTraitId(other.getValueTraitId());
            valueType(other.getValueType());
            return this;
        }

        @java.lang.Override
        @JsonSetter("value_type")
        public _FinalStage valueType(@NotNull UpdateEntitlementReqCommonValueType valueType) {
            this.valueType = Objects.requireNonNull(valueType, "valueType must not be null");
            return this;
        }

        @java.lang.Override
        public _FinalStage valueTraitId(String valueTraitId) {
            this.valueTraitId = Optional.ofNullable(valueTraitId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_trait_id", nulls = Nulls.SKIP)
        public _FinalStage valueTraitId(Optional<String> valueTraitId) {
            this.valueTraitId = valueTraitId;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueNumeric(Integer valueNumeric) {
            this.valueNumeric = Optional.ofNullable(valueNumeric);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_numeric", nulls = Nulls.SKIP)
        public _FinalStage valueNumeric(Optional<Integer> valueNumeric) {
            this.valueNumeric = valueNumeric;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueCreditId(String valueCreditId) {
            this.valueCreditId = Optional.ofNullable(valueCreditId);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_credit_id", nulls = Nulls.SKIP)
        public _FinalStage valueCreditId(Optional<String> valueCreditId) {
            this.valueCreditId = valueCreditId;
            return this;
        }

        @java.lang.Override
        public _FinalStage valueBool(Boolean valueBool) {
            this.valueBool = Optional.ofNullable(valueBool);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "value_bool", nulls = Nulls.SKIP)
        public _FinalStage valueBool(Optional<Boolean> valueBool) {
            this.valueBool = valueBool;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriodMonthReset(
                UpdateEntitlementReqCommonMetricPeriodMonthReset metricPeriodMonthReset) {
            this.metricPeriodMonthReset = Optional.ofNullable(metricPeriodMonthReset);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period_month_reset", nulls = Nulls.SKIP)
        public _FinalStage metricPeriodMonthReset(
                Optional<UpdateEntitlementReqCommonMetricPeriodMonthReset> metricPeriodMonthReset) {
            this.metricPeriodMonthReset = metricPeriodMonthReset;
            return this;
        }

        @java.lang.Override
        public _FinalStage metricPeriod(UpdateEntitlementReqCommonMetricPeriod metricPeriod) {
            this.metricPeriod = Optional.ofNullable(metricPeriod);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "metric_period", nulls = Nulls.SKIP)
        public _FinalStage metricPeriod(Optional<UpdateEntitlementReqCommonMetricPeriod> metricPeriod) {
            this.metricPeriod = metricPeriod;
            return this;
        }

        @java.lang.Override
        public _FinalStage creditConsumptionRate(Double creditConsumptionRate) {
            this.creditConsumptionRate = Optional.ofNullable(creditConsumptionRate);
            return this;
        }

        @java.lang.Override
        @JsonSetter(value = "credit_consumption_rate", nulls = Nulls.SKIP)
        public _FinalStage creditConsumptionRate(Optional<Double> creditConsumptionRate) {
            this.creditConsumptionRate = creditConsumptionRate;
            return this;
        }

        @java.lang.Override
        public UpdateEntitlementReqCommon build() {
            return new UpdateEntitlementReqCommon(
                    creditConsumptionRate,
                    metricPeriod,
                    metricPeriodMonthReset,
                    valueBool,
                    valueCreditId,
                    valueNumeric,
                    valueTraitId,
                    valueType,
                    additionalProperties);
        }
    }
}
