/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.syntax.commands;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.Command;
import com.scriptbasic.interfaces.LeftValueList;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.LexicalElement;
import com.scriptbasic.syntax.commands.AbstractCommandAnalyzer;
import com.scriptbasic.utility.FactoryUtility;

public class CommandAnalyzerSub
extends AbstractCommandAnalyzer {
    @Override
    public Command analyze() throws AnalysisException {
        CommandSub node = new CommandSub();
        LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.getFactory());
        LexicalElement lexicalElement = lexicalAnalyzer.get();
        if (!lexicalElement.isIdentifier().booleanValue()) {
            throw new GenericSyntaxException("subroutine name has to follow the keyword " + this.getName());
        }
        String subName = lexicalElement.getLexeme();
        node.setSubName(subName);
        if (this.isKeyWord("(")) {
            lexicalAnalyzer.get();
            if (this.isKeyWord(")")) {
                node.setArguments(null);
                lexicalAnalyzer.get();
            } else {
                LeftValueList arguments = this.analyzeSimpleLeftValueList();
                node.setArguments(arguments);
                this.assertKeyWord(")");
            }
        } else {
            node.setArguments(null);
        }
        this.pushNode(node);
        this.consumeEndOfLine();
        return node;
    }

    @Override
    protected String getName() {
        return "SUB";
    }
}

