/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.utility;

import com.scriptbasic.exceptions.GenericSyntaxException;
import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.utility.CastUtility;
import com.scriptbasic.utility.UtilityUtility;
import java.lang.reflect.Field;

public final class KlassUtility {
    private KlassUtility() {
        UtilityUtility.throwExceptionToEnsureNobodyCallsIt();
    }

    public static void setField(Object object, String fieldName, Object valueObject) throws BasicRuntimeException {
        Class<?> klass = object.getClass();
        try {
            Field field = klass.getField(fieldName);
            Class<?> fieldClass = field.getType();
            Object typeConvertedValueObject = CastUtility.cast(valueObject, fieldClass);
            field.set(object, typeConvertedValueObject);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new BasicRuntimeException("Object access of type " + object.getClass() + " can not set field '" + fieldName + "'", e);
        }
    }

    public static Object getField(Object object, String fieldName) throws ExecutionException {
        Class<?> klass = object.getClass();
        Object result = null;
        try {
            Field field = klass.getField(fieldName);
            result = field.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new BasicRuntimeException("Object access of type " + object.getClass() + " can not access field '" + fieldName + "'", e);
        }
        return result;
    }

    private static String getterName(String fieldName) {
        String prefix = "get";
        StringBuilder sb = new StringBuilder(fieldName.length() + "get".length());
        sb.append("get");
        sb.append(fieldName);
        sb.setCharAt("get".length(), Character.toUpperCase(sb.charAt("get".length())));
        return sb.toString();
    }

    public static Class<?> forName(String s) throws ClassNotFoundException {
        StringBuilder className = new StringBuilder(s);
        Class<?> klass = null;
        ClassNotFoundException firstCatchedException = null;
        while (klass == null) {
            try {
                klass = Class.forName(className.toString());
            }
            catch (ClassNotFoundException ex) {
                int lastDotPosition;
                klass = null;
                if (firstCatchedException == null) {
                    firstCatchedException = ex;
                }
                if ((lastDotPosition = className.lastIndexOf(".")) == -1) break;
                className.setCharAt(lastDotPosition, '$');
            }
        }
        if (klass == null) {
            throw firstCatchedException;
        }
        return klass;
    }

    public static Class<?> forNameEx(String s) throws GenericSyntaxException {
        Class<Comparable<Byte>> klass = null;
        switch (s) {
            case "byte": {
                klass = Byte.TYPE;
            }
            case "short": {
                klass = Short.TYPE;
                break;
            }
            case "char": {
                klass = Character.TYPE;
                break;
            }
            case "double": {
                klass = Double.TYPE;
                break;
            }
            case "float": {
                klass = Float.TYPE;
                break;
            }
            case "long": {
                klass = Long.TYPE;
                break;
            }
            case "int": {
                klass = Integer.TYPE;
                break;
            }
            case "boolean": {
                klass = Boolean.TYPE;
                break;
            }
            default: {
                try {
                    klass = KlassUtility.forName(s);
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new GenericSyntaxException("Can not get class " + s, e);
                }
            }
        }
        return klass;
    }
}

