/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic;

import com.scriptbasic.errors.BasicInterpreterInternalError;
import com.scriptbasic.executors.commands.CommandSub;
import com.scriptbasic.factories.FactoryFactory;
import com.scriptbasic.interfaces.AnalysisException;
import com.scriptbasic.interfaces.EngineApi;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.ExtendedInterpreter;
import com.scriptbasic.interfaces.Factory;
import com.scriptbasic.interfaces.LexicalAnalyzer;
import com.scriptbasic.interfaces.Reader;
import com.scriptbasic.interfaces.ScriptBasicException;
import com.scriptbasic.interfaces.SourcePath;
import com.scriptbasic.interfaces.SourceProvider;
import com.scriptbasic.interfaces.Subroutine;
import com.scriptbasic.readers.GenericHierarchicalReader;
import com.scriptbasic.readers.GenericReader;
import com.scriptbasic.sourceproviders.BasicSourcePath;
import com.scriptbasic.sourceproviders.FileSourceProvider;
import com.scriptbasic.utility.FactoryUtility;
import com.scriptbasic.utility.RightValueUtility;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class Engine
implements EngineApi {
    private final Factory factory;
    private final ExtendedInterpreter interpreter;
    private java.io.Reader input;
    private Writer output;
    private Writer error;
    private boolean theMapHasToBeFilled = true;
    private final Map<String, Subroutine> subroutines = new HashMap<String, Subroutine>();

    @Override
    public Factory getBasicFactory() {
        return this.factory;
    }

    public Engine() {
        this.factory = FactoryFactory.getFactory();
        this.interpreter = FactoryUtility.getExtendedInterpreter(this.factory);
    }

    @Override
    public java.io.Reader getInput() {
        return this.input;
    }

    @Override
    public void setInput(java.io.Reader input) {
        this.input = input;
    }

    @Override
    public Writer getOutput() {
        return this.output;
    }

    @Override
    public void setOutput(Writer output) {
        this.output = output;
    }

    @Override
    public Writer getError() {
        return this.error;
    }

    @Override
    public void setError(Writer error) {
        this.error = error;
    }

    private void loadHelper(java.io.Reader reader, String fileName, SourceProvider sourceProvider) throws ScriptBasicException {
        try {
            Reader sourceReader;
            if (reader == null && sourceProvider != null) {
                sourceReader = sourceProvider.get(fileName);
            } else {
                GenericReader genericReader = new GenericReader();
                genericReader.set(reader);
                genericReader.setSourceProvider(sourceProvider);
                sourceReader = genericReader;
            }
            sourceReader.set(fileName);
            LexicalAnalyzer lexicalAnalyzer = FactoryUtility.getLexicalAnalyzer(this.factory);
            GenericHierarchicalReader hReader = new GenericHierarchicalReader();
            hReader.include(sourceReader);
            lexicalAnalyzer.set(hReader);
            this.interpreter.setProgram(FactoryUtility.getSyntaxAnalyzer(this.factory).analyze());
            this.interpreter.setWriter(this.output);
            this.interpreter.setErrorWriter(this.error);
            this.interpreter.setReader(this.input);
        }
        catch (IOException e) {
            throw new ScriptBasicException(e);
        }
        catch (AnalysisException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public void execute() throws ScriptBasicException {
        try {
            this.interpreter.execute();
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public void load(String sourceCode) throws ScriptBasicException {
        this.loadHelper(new StringReader(sourceCode), null, null);
    }

    @Override
    public void eval(String sourceCode) throws ScriptBasicException {
        this.load(sourceCode);
        this.execute();
    }

    @Override
    public void load(java.io.Reader reader) throws ScriptBasicException {
        this.loadHelper(reader, null, null);
    }

    @Override
    public void eval(java.io.Reader reader) throws ScriptBasicException {
        this.load(reader);
        this.execute();
    }

    @Override
    public void load(File sourceFile) throws ScriptBasicException {
        try {
            this.loadHelper(new FileReader(sourceFile), sourceFile.getAbsolutePath(), null);
        }
        catch (FileNotFoundException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public void eval(File sourceFile) throws ScriptBasicException {
        this.load(sourceFile);
        this.execute();
    }

    @Override
    public void load(String sourceFileName, String ... path) throws ScriptBasicException {
        FileSourceProvider sourceProvider = new FileSourceProvider();
        BasicSourcePath sourcePath = new BasicSourcePath();
        for (String p : path) {
            sourcePath.add(p);
        }
        sourceProvider.setSourcePath(sourcePath);
        this.loadHelper(null, sourceFileName, sourceProvider);
    }

    @Override
    public void eval(String sourceFileName, String ... path) throws ScriptBasicException {
        this.load(sourceFileName, path);
        this.execute();
    }

    @Override
    public void load(String sourceFileName, SourcePath path) throws ScriptBasicException {
        FileSourceProvider sourceProvider = new FileSourceProvider();
        sourceProvider.setSourcePath(path);
        this.loadHelper(null, sourceFileName, sourceProvider);
    }

    @Override
    public void eval(String sourceFileName, SourcePath path) throws ScriptBasicException {
        this.load(sourceFileName, path);
        this.execute();
    }

    @Override
    public void load(String sourceName, SourceProvider provider) throws ScriptBasicException {
        this.loadHelper(null, sourceName, provider);
    }

    @Override
    public void eval(String sourceName, SourceProvider provider) throws ScriptBasicException {
        this.load(sourceName, provider);
        this.execute();
    }

    @Override
    public void setVariable(String name, Object value) throws ScriptBasicException {
        try {
            this.interpreter.getVariables().setVariable(name, RightValueUtility.createRightValue(value));
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public Object getVariable(String name) throws ScriptBasicException {
        try {
            return this.interpreter.getVariable(name);
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public Iterable<String> getVariablesIterator() {
        return this.interpreter.getVariables().getGlobalMap().getVariableNameSet();
    }

    @Override
    public Object call(String subroutineName, Object ... args) throws ScriptBasicException {
        try {
            return this.interpreter.call(subroutineName, args);
        }
        catch (ExecutionException e) {
            throw new ScriptBasicException(e);
        }
    }

    @Override
    public Iterable<String> getSubroutineNames() {
        return this.interpreter.getProgram().getNamedCommandNames();
    }

    private void SubroutineDoesNotExistWTF(Exception e) {
        throw new BasicInterpreterInternalError("An already located subroutine does not exist", e);
    }

    @Override
    public Iterable<Subroutine> getSubroutines() {
        if (this.theMapHasToBeFilled) {
            for (String s : this.getSubroutineNames()) {
                try {
                    this.getSubroutine(s);
                }
                catch (ScriptBasicException e) {
                    this.SubroutineDoesNotExistWTF(e);
                }
            }
            this.theMapHasToBeFilled = false;
        }
        return this.subroutines.values();
    }

    private CommandSub getCommandSub(String subroutineName) throws ScriptBasicException {
        CommandSub commandSub = this.interpreter.getSubroutine(subroutineName);
        if (commandSub == null) {
            throw new ScriptBasicException("Sobroutine '" + subroutineName + "' is not defined in the program");
        }
        return commandSub;
    }

    @Override
    public int getNumberOfArguments(String subroutineName) throws ScriptBasicException {
        CommandSub commandSub = this.getCommandSub(subroutineName);
        int size = commandSub.getArguments() != null ? commandSub.getArguments().size() : 0;
        return size;
    }

    @Override
    public Subroutine getSubroutine(String subroutineName) throws ScriptBasicException {
        if (this.subroutines.containsKey(subroutineName)) {
            return this.subroutines.get(subroutineName);
        }
        CommandSub commandSub = this.getCommandSub(subroutineName);
        Sub sub = new Sub(commandSub.getSubName());
        this.subroutines.put(subroutineName, sub);
        return sub;
    }

    public class Sub
    implements Subroutine {
        private String name;

        Sub(String n) {
            this.name = n;
        }

        @Override
        public int getNumberOfArguments() {
            try {
                return Engine.this.getNumberOfArguments(this.name);
            }
            catch (ScriptBasicException e) {
                Engine.this.SubroutineDoesNotExistWTF(e);
                return 0;
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Object call(Object ... args) throws ScriptBasicException {
            return Engine.this.call(this.name, args);
        }
    }
}

