/*
 * Decompiled with CFR 0.152.
 */
package com.scriptbasic.memory;

import com.scriptbasic.interfaces.BasicRuntimeException;
import com.scriptbasic.interfaces.ExecutionException;
import com.scriptbasic.interfaces.HierarchicalVariableMap;
import com.scriptbasic.interfaces.RightValue;
import com.scriptbasic.interfaces.VariableMap;
import com.scriptbasic.memory.BasicLocalVariableMap;
import com.scriptbasic.memory.BasicVariableMap;
import com.scriptbasic.memory.BasicVariableRegistry;

public class MixedBasicVariableMap
extends BasicLocalVariableMap
implements HierarchicalVariableMap {
    private final BasicVariableMap globalVariableMap = new BasicVariableMap();
    private final BasicVariableRegistry globalVariableRegistry = new BasicVariableRegistry(this.globalVariableMap);
    private boolean variablesCreatedByDefault = true;
    private boolean defaultVariableScopeIsGlobal = false;

    @Override
    public VariableMap getGlobalMap() {
        return this.globalVariableMap;
    }

    @Override
    public RightValue getVariableValue(String variableName) throws ExecutionException {
        return super.variableExists(variableName) != false ? super.getVariableValue(variableName) : this.globalVariableMap.getVariableValue(variableName);
    }

    @Override
    public Boolean variableExists(String variableName) throws ExecutionException {
        return super.variableExists(variableName) != false || this.globalVariableMap.variableExists(variableName) != false;
    }

    @Override
    public Boolean variableDefined(String variableName) throws ExecutionException {
        return super.variableDefined(variableName) != false || this.globalVariableMap.variableDefined(variableName) != false;
    }

    public void requireVariableDeclaration() {
        this.variablesCreatedByDefault = false;
    }

    public void createVariablesOnTheFly() {
        this.variablesCreatedByDefault = true;
    }

    public void defaultVariableScopeShallBeLocal() {
        this.defaultVariableScopeIsGlobal = false;
    }

    public void defaultVariableScopeShallBeGlobal() {
        this.defaultVariableScopeIsGlobal = true;
    }

    @Override
    public void registerGlobalVariable(String variableName) throws ExecutionException {
        super.registerGlobalVariable(variableName);
        this.globalVariableRegistry.registerGlobal(variableName);
    }

    @Override
    public void setVariable(String variableName, RightValue rightValue) throws ExecutionException {
        if (super.isLocal(variableName)) {
            super.setVariable(variableName, rightValue);
        } else if (super.isGlobal(variableName)) {
            this.globalVariableMap.setVariable(variableName, rightValue);
        } else if (this.variablesCreatedByDefault) {
            if (this.defaultVariableScopeIsGlobal || this.currentScopeIsGlobal()) {
                this.globalVariableMap.setVariable(variableName, rightValue);
            } else {
                super.setVariable(variableName, rightValue);
            }
        } else {
            throw new BasicRuntimeException("Variable '" + variableName + "' was not properly declared");
        }
    }

    @Override
    public void setCaseSensitive() {
        super.setCaseSensitive();
        this.globalVariableMap.setCaseSensitive();
    }

    @Override
    public void setCaseFreak() {
        super.setCaseFreak();
        this.globalVariableMap.setCaseFreak();
    }

    @Override
    public void setCaseIgnorant() {
        super.setCaseIgnorant();
        this.globalVariableMap.setCaseIgnorant();
    }
}

